/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-12-19 08:21:56 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `znE_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=117 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1941 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `znE_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=26364 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `znE_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `znE_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=5671 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `znE_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_duplicator_activity_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `sub_type` varchar(100) NOT NULL,
  `severity` int(8) NOT NULL,
  `title` text NOT NULL,
  `data` longtext NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `sub_type_idx` (`sub_type`),
  KEY `severity_idx` (`severity`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `znE_duplicator_backups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL DEFAULT '',
  `package` longtext NOT NULL,
  `archive_name` varchar(350) NOT NULL DEFAULT '',
  `progress` float NOT NULL DEFAULT 0,
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE','TEMPORARY') NOT NULL DEFAULT '',
  `version` varchar(30) NOT NULL DEFAULT '',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `type` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`),
  KEY `archive_name` (`archive_name`(250)),
  KEY `type_idx` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=98 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `znE_duplicator_entities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `data` longtext NOT NULL,
  `value_1` varchar(255) NOT NULL DEFAULT '',
  `value_2` varchar(255) NOT NULL DEFAULT '',
  `value_3` varchar(255) NOT NULL DEFAULT '',
  `value_4` varchar(255) NOT NULL DEFAULT '',
  `value_5` varchar(255) NOT NULL DEFAULT '',
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`),
  KEY `value_2` (`value_2`),
  KEY `value_3` (`value_3`),
  KEY `value_4` (`value_4`),
  KEY `value_5` (`value_5`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `znE_evf_entries` (
  `entry_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `user_device` varchar(100) NOT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  `referer` text NOT NULL,
  `fields` longtext DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `viewed` tinyint(1) NOT NULL DEFAULT 0,
  `starred` tinyint(1) NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`entry_id`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `znE_evf_entrymeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `entry_id` (`entry_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `znE_evf_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `znE_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `znE_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=196314 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2429 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=1368 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_shortpixel_folders` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `path` varchar(512) DEFAULT NULL,
  `name` varchar(150) DEFAULT NULL,
  `path_md5` char(32) DEFAULT NULL,
  `file_count` int(11) DEFAULT NULL,
  `status` smallint(6) NOT NULL DEFAULT 0,
  `ts_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `ts_created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `spf_path_md5` (`path_md5`),
  KEY `path` (`path`(250))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `znE_shortpixel_meta` (
  `id` mediumint(10) NOT NULL AUTO_INCREMENT,
  `folder_id` mediumint(9) NOT NULL,
  `ext_meta_id` int(10) DEFAULT NULL,
  `path` varchar(512) DEFAULT NULL,
  `name` varchar(150) DEFAULT NULL,
  `path_md5` char(32) DEFAULT NULL,
  `compressed_size` int(10) NOT NULL DEFAULT 0,
  `compression_type` tinyint(4) DEFAULT NULL,
  `keep_exif` tinyint(4) DEFAULT 0,
  `cmyk2rgb` tinyint(4) DEFAULT 0,
  `resize` tinyint(4) DEFAULT NULL,
  `resize_width` smallint(6) DEFAULT NULL,
  `resize_height` smallint(6) DEFAULT NULL,
  `backup` tinyint(4) DEFAULT 0,
  `status` smallint(6) NOT NULL DEFAULT 0,
  `retries` tinyint(4) NOT NULL DEFAULT 0,
  `message` varchar(255) DEFAULT NULL,
  `ts_added` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `ts_optimized` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `extra_info` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sp_id` (`id`),
  UNIQUE KEY `sp_path_md5` (`path_md5`),
  KEY `fk_shortpixel_meta_folder` (`folder_id`),
  KEY `path` (`path`(250))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `znE_shortpixel_postmeta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attach_id` bigint(20) unsigned NOT NULL,
  `parent` bigint(20) unsigned NOT NULL,
  `image_type` tinyint(4) DEFAULT 0,
  `size` varchar(200) DEFAULT NULL,
  `status` tinyint(4) DEFAULT 0,
  `compression_type` tinyint(4) DEFAULT NULL,
  `compressed_size` int(11) DEFAULT NULL,
  `original_size` int(11) DEFAULT NULL,
  `tsAdded` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `tsOptimized` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `extra_info` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attach_id` (`attach_id`),
  KEY `parent` (`parent`),
  KEY `size` (`size`),
  KEY `status` (`status`),
  KEY `compression_type` (`compression_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `znE_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_tm_taskmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB AUTO_INCREMENT=815 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `znE_tm_tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `type` varchar(300) NOT NULL,
  `class_identifier` varchar(300) DEFAULT '0',
  `attempts` int(11) DEFAULT 0,
  `description` varchar(300) DEFAULT NULL,
  `time_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `last_locked_at` bigint(20) DEFAULT 0,
  `status` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=815 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `znE_wfauditevents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `request_id` bigint(20) unsigned NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT 0,
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wfblocks7` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(10) unsigned NOT NULL DEFAULT 0,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT 0,
  `blockedHits` int(10) unsigned DEFAULT 0,
  `expiration` bigint(20) unsigned NOT NULL DEFAULT 0,
  `parameters` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB AUTO_INCREMENT=1674 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob DEFAULT NULL,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `real_path` text NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int(10) unsigned NOT NULL DEFAULT 0,
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wfhits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT 0,
  `statusCode` int(11) NOT NULL DEFAULT 200,
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text DEFAULT NULL,
  `referer` text DEFAULT NULL,
  `UA` text DEFAULT NULL,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text DEFAULT NULL,
  `actionData` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=InnoDB AUTO_INCREMENT=4553 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wfhoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text DEFAULT NULL,
  `host` text DEFAULT NULL,
  `path` text DEFAULT NULL,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wfissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text DEFAULT NULL,
  `data` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB AUTO_INCREMENT=268 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wfknownfilelist` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `wordpress_path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17461 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT 0.0000000,
  `lon` float(10,7) DEFAULT 0.0000000,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wflogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int(11) DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wfls_2fa_secrets` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `vtime` int(10) unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wfls_role_counts` (
  `serialized_roles` varbinary(255) NOT NULL,
  `two_factor_inactive` tinyint(1) NOT NULL,
  `user_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`serialized_roles`,`two_factor_inactive`)
) ENGINE=MEMORY DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `znE_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob DEFAULT NULL,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint(3) unsigned NOT NULL DEFAULT 1,
  `category` varchar(255) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT 1000,
  `ctime` int(10) unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wfpendingissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text DEFAULT NULL,
  `data` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wfsecurityevents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wfsnipcache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT current_timestamp(),
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT 0,
  `type` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=1743 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wfstatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=88218 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wftrafficrates` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wfwaffailures` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `throwable` text NOT NULL,
  `rule_id` int(10) unsigned DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `znE_wpforms_payments` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `status` varchar(10) NOT NULL DEFAULT '',
  `subtotal_amount` decimal(26,8) NOT NULL DEFAULT 0.00000000,
  `discount_amount` decimal(26,8) NOT NULL DEFAULT 0.00000000,
  `total_amount` decimal(26,8) NOT NULL DEFAULT 0.00000000,
  `currency` varchar(3) NOT NULL DEFAULT '',
  `entry_id` bigint(20) NOT NULL DEFAULT 0,
  `gateway` varchar(20) NOT NULL DEFAULT '',
  `type` varchar(12) NOT NULL DEFAULT '',
  `mode` varchar(4) NOT NULL DEFAULT '',
  `transaction_id` varchar(40) NOT NULL DEFAULT '',
  `customer_id` varchar(40) NOT NULL DEFAULT '',
  `subscription_id` varchar(40) NOT NULL DEFAULT '',
  `subscription_status` varchar(10) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `date_created_gmt` datetime NOT NULL,
  `date_updated_gmt` datetime NOT NULL,
  `is_published` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `status` (`status`(8)),
  KEY `total_amount` (`total_amount`),
  KEY `type` (`type`(8)),
  KEY `transaction_id` (`transaction_id`(32)),
  KEY `customer_id` (`customer_id`(32)),
  KEY `subscription_id` (`subscription_id`(32)),
  KEY `subscription_status` (`subscription_status`(8)),
  KEY `title` (`title`(64))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `znE_wpforms_payment_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `payment_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payment_id` (`payment_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `znE_wpforms_tasks_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `action` varchar(255) NOT NULL,
  `data` longtext NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `znE_wpo_404_detector` (
  `ID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `url` text NOT NULL,
  `request_timestamp` bigint(20) unsigned NOT NULL,
  `request_count` bigint(20) unsigned NOT NULL,
  `referrer` text NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `url` (`url`(75),`request_timestamp`,`referrer`(75)),
  KEY `url_timestamp_referrer` (`url`(75),`request_timestamp`,`referrer`(75)),
  KEY `timestamp_count` (`request_timestamp`,`request_count`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `znE_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` mediumtext DEFAULT NULL,
  `permalink_hash` varchar(40) DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) NOT NULL,
  `object_sub_type` varchar(32) DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `breadcrumb_title` text DEFAULT NULL,
  `post_status` varchar(20) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT 0,
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` mediumtext DEFAULT NULL,
  `primary_focus_keyword` varchar(191) DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT 0,
  `is_robots_noindex` tinyint(1) DEFAULT 0,
  `is_robots_nofollow` tinyint(1) DEFAULT 0,
  `is_robots_noarchive` tinyint(1) DEFAULT 0,
  `is_robots_noimageindex` tinyint(1) DEFAULT 0,
  `is_robots_nosnippet` tinyint(1) DEFAULT 0,
  `twitter_title` text DEFAULT NULL,
  `twitter_image` mediumtext DEFAULT NULL,
  `twitter_description` mediumtext DEFAULT NULL,
  `twitter_image_id` varchar(191) DEFAULT NULL,
  `twitter_image_source` text DEFAULT NULL,
  `open_graph_title` text DEFAULT NULL,
  `open_graph_description` mediumtext DEFAULT NULL,
  `open_graph_image` mediumtext DEFAULT NULL,
  `open_graph_image_id` varchar(191) DEFAULT NULL,
  `open_graph_image_source` text DEFAULT NULL,
  `open_graph_image_meta` text DEFAULT NULL,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  `schema_page_type` varchar(64) DEFAULT NULL,
  `schema_article_type` varchar(64) DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT 0,
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  `version` int(11) DEFAULT 1,
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=MyISAM AUTO_INCREMENT=147 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `znE_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `znE_yoast_migrations` (
  `version` varchar(191) DEFAULT NULL,
  UNIQUE KEY `idx_znE_yoast_migrations_version` (`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `znE_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `znE_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) NOT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=MyISAM AUTO_INCREMENT=253 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `znE_yoast_seo_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT NULL,
  `incoming_link_count` int(10) unsigned DEFAULT NULL,
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `znE_users` VALUES 
("1","stronganchor","$wp$2y$10$MzEUph.JIUQCb/CbCQG/bON/dP2v1CDSyM22uWRlJP0G.4yr2nR0G","stronganchor","stronganchortech@gmail.com","","2020-04-05 13:14:15","","0","webmaster");

INSERT IGNORE INTO `znE_usermeta` VALUES 
("1","1","nickname","webmaster"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","znE_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","znE_user_level","10"),
("14","1","dismissed_wp_pointers","theme_editor_notice,perflab-admin-pointer,plugin_editor_notice,eael,perflab-feature-view-transitions,perflab-feature-nocache-bfcache"),
("15","1","show_welcome_panel","0"),
("16","1","session_tokens","a:7:{s:64:\"cf14228f1753e16cae5480c082796d2d80e396fd8d9e58ed04caa46c56e5dcd1\";a:4:{s:10:\"expiration\";i:1766197048;s:2:\"ip\";s:13:\"69.167.167.14\";s:2:\"ua\";s:50:\"WordPress/6.9; https://mainwp.stronganchortech.com\";s:5:\"login\";i:1766024248;}s:64:\"d466dd7450c31fd824d5ab8acc4eea39ea0c20bf973176891d68bae620677a10\";a:4:{s:10:\"expiration\";i:1766197053;s:2:\"ip\";s:13:\"69.167.167.14\";s:2:\"ua\";s:58:\"Mozilla/5.0 (compatible; MainWP/5.4.1; +http://mainwp.com)\";s:5:\"login\";i:1766024253;}s:64:\"2e924e6f4823b779766f723d601cef91d5de1afa0f1da5ffd411e556afbabbd2\";a:4:{s:10:\"expiration\";i:1766197053;s:2:\"ip\";s:13:\"69.167.167.14\";s:2:\"ua\";s:58:\"Mozilla/5.0 (compatible; MainWP/5.4.1; +http://mainwp.com)\";s:5:\"login\";i:1766024253;}s:64:\"6252b7442015f701c0ae23f25df410311dc210ae8bd58a170591a1a6e0ee2acf\";a:4:{s:10:\"expiration\";i:1766226211;s:2:\"ip\";s:13:\"69.167.167.14\";s:2:\"ua\";s:50:\"WordPress/6.9; https://mainwp.stronganchortech.com\";s:5:\"login\";i:1766053411;}s:64:\"e4619066f369c3e85487667d12e848c3265addea37c8872969a1d18c0108df4a\";a:4:{s:10:\"expiration\";i:1766266132;s:2:\"ip\";s:13:\"69.167.167.14\";s:2:\"ua\";s:50:\"WordPress/6.9; https://mainwp.stronganchortech.com\";s:5:\"login\";i:1766093332;}s:64:\"b04e08d29f019e84c0d449841abd6c945c4c3cb4d534fafaac907d114ebfc5ae\";a:4:{s:10:\"expiration\";i:1766269764;s:2:\"ip\";s:13:\"69.167.167.14\";s:2:\"ua\";s:50:\"WordPress/6.9; https://mainwp.stronganchortech.com\";s:5:\"login\";i:1766096964;}s:64:\"d0ad6337603497029b67cb3304c54278d15a6804ae585e8dc37e07fa2af3cc4f\";a:4:{s:10:\"expiration\";i:1767341536;s:2:\"ip\";s:14:\"88.242.209.153\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36\";s:5:\"login\";i:1766131936;}}"),
("17","1","eig_last_login","2020-04-28T08:53:38+00:00"),
("18","1","jetpack_tracks_anon_id","jetpack:+WRYGLYyuwyXTps2syf9AZwA"),
("19","1","znE_dashboard_quick_press_last_post_id","1367"),
("20","1","community-events-location","a:1:{s:2:\"ip\";s:12:\"88.242.209.0\";}"),
("22","1","znE_user-settings","editor=html&libraryContent=browse"),
("23","1","znE_user-settings-time","1599328839"),
("25","1","_yoast_wpseo_profile_updated","1599326345"),
("26","1","wpseo_title",""),
("27","1","wpseo_metadesc",""),
("28","1","wpseo_noindex_author","on"),
("29","1","wpseo_content_analysis_disable",""),
("30","1","wpseo_keyword_analysis_disable",""),
("42","1","wfls-last-login","1766131936"),
("44","1","default_password_nag",""),
("48","1","zakra_upgrade_notice_dismiss","yes"),
("55","1","bsf-optin-notice","notice-dismissed"),
("58","1","closedpostboxes_dashboard","a:0:{}"),
("59","1","metaboxhidden_dashboard","a:7:{i:0;s:27:\"wpforms_reports_widget_lite\";i:1;s:20:\"e-dashboard-overview\";i:2;s:19:\"dashboard_right_now\";i:3;s:18:\"dashboard_activity\";i:4;s:24:\"wpseo-dashboard-overview\";i:5;s:21:\"dashboard_quick_press\";i:6;s:17:\"dashboard_primary\";}"),
("60","1","wpo-hide-minify-information-notice","1"),
("61","1","header-footer-elementor-rating","notice-dismissed"),
("62","1","znE_media_library_mode","list"),
("65","1","wpforms_dismissed","a:1:{s:15:\"lite-notice-bar\";i:1600698300;}"),
("67","1","astra-sites-5-start-notice","notice-dismissed"),
("69","1","meta-box-order_dashboard","a:4:{s:6:\"normal\";s:145:\"wpforms_reports_widget_lite,e-dashboard-overview,dashboard_right_now,dashboard_activity,wordfence_activity_report_widget,wpseo-dashboard-overview\";s:4:\"side\";s:81:\"dashboard_quick_press,dashboard_primary,dashboard_site_health,wp_memory_dashboard\";s:7:\"column3\";s:0:\"\";s:7:\"column4\";s:0:\"\";}"),
("80","1","znE_wpseo-plugin-updated","15.5"),
("81","1","wpseo-dismiss-configuration-notice","yes"),
("83","1","essential_adons_elementor_opt_in","1"),
("84","1","wpdeveloper_notices_seen","a:2:{s:24:\"wpdeveloper_notice_4_3_8\";a:1:{s:25:\"essential_adons_elementor\";a:1:{i:0;s:6:\"opt_in\";}}s:24:\"wpdeveloper_notice_4_6_6\";a:1:{s:25:\"essential_adons_elementor\";a:1:{i:0;s:6:\"review\";}}}"),
("85","1","elementor_introduction","a:3:{s:18:\"yoast-introduction\";b:1;s:6:\"e-apps\";b:1;s:25:\"black_friday_pointer_2025\";b:1;}"),
("86","1","nav_menu_recently_edited","2"),
("87","1","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("88","1","metaboxhidden_nav-menus","a:2:{i:0;s:12:\"add-post_tag\";i:1;s:15:\"add-post_format\";}"),
("94","1","essential_adons_elementor_review","1"),
("100","1","hfe-popup","dismissed"),
("107","1","elementor_admin_notices","a:2:{s:20:\"experiment_promotion\";s:4:\"true\";s:20:\"design_not_appearing\";a:2:{s:9:\"is_viewed\";b:0;s:4:\"meta\";a:1:{s:7:\"version\";s:7:\"3.25.11\";}}}"),
("108","1","duplicator_user_ui_option","a:6:{s:17:\"num_packages_list\";i:10;s:19:\"created_date_format\";s:1:\"1\";s:16:\"show_note_column\";b:0;s:16:\"show_size_column\";b:1;s:19:\"show_created_column\";b:1;s:15:\"show_age_column\";b:0;}"),
("109","1","theme-min-version-notice-min-ver","4.6.0"),
("110","1","znE_backwpupbackups_per_page","99999999"),
("111","1","essential-addons-for-elementor_review_notice_dismissed","1"),
("112","1","ast-minimum-addon-version-notice-min-ver","4.11.1"),
("113","1","wpcode_default_code_type","php"),
("114","1","wpcode_snippet_activate_notice_shown","1"),
("115","1","znE_mainwp_child_user_verified_registers","[{\"hash_key\":\"d0ee4207d547fafbe8c14fe9cc03e34d46bf7f12579bb6a61038d8d80a1abe4a\",\"secure\":\"459f04520cd2db86412f2b4efa17fdb61e46096b\",\"date\":\"2024-11-29 08:34:17\"}]"),
("116","1","znE_mainwp_child_user_enable_passwd_auth_connect","1");

INSERT IGNORE INTO `znE_actionscheduler_actions` VALUES 
("1909","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-18 10:10:33","2025-11-18 10:10:33","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763460633;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763460633;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-11-18 10:15:11","2025-11-18 10:15:11","25033",NULL,"20"),
("1910","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-19 10:15:11","2025-11-19 10:15:11","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763547311;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763547311;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-11-19 10:55:41","2025-11-19 10:55:41","25075",NULL,"20"),
("1911","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-20 10:55:41","2025-11-20 10:55:41","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763636141;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763636141;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-11-20 10:56:04","2025-11-20 10:56:04","25128",NULL,"20"),
("1912","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-21 10:56:04","2025-11-21 10:56:04","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763722564;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763722564;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-11-21 12:29:07","2025-11-21 12:29:07","25186",NULL,"20"),
("1913","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-22 12:29:07","2025-11-22 12:29:07","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763814547;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763814547;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-11-22 12:31:34","2025-11-22 12:31:34","25209",NULL,"20"),
("1914","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-23 12:31:34","2025-11-23 12:31:34","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763901094;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763901094;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-11-23 12:31:39","2025-11-23 12:31:39","25250",NULL,"20"),
("1915","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-24 12:31:39","2025-11-24 12:31:39","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763987499;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763987499;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-11-24 14:31:55","2025-11-24 14:31:55","25295",NULL,"20"),
("1916","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-25 14:31:55","2025-11-25 14:31:55","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764081115;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764081115;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-11-25 16:52:11","2025-11-25 16:52:11","25320",NULL,"20"),
("1917","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-26 16:52:11","2025-11-26 16:52:11","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764175931;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764175931;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-11-26 16:55:36","2025-11-26 16:55:36","25381",NULL,"20"),
("1918","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-27 16:55:36","2025-11-27 16:55:36","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764262536;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764262536;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-11-27 16:56:09","2025-11-27 16:56:09","25443",NULL,"20"),
("1919","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-28 16:56:09","2025-11-28 16:56:09","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764348969;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764348969;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-11-28 19:24:15","2025-11-28 19:24:15","25477",NULL,"20"),
("1920","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-29 19:24:15","2025-11-29 19:24:15","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764444255;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764444255;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-11-29 21:45:25","2025-11-29 21:45:25","25506",NULL,"20"),
("1921","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-11-30 21:45:25","2025-11-30 21:45:25","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764539125;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764539125;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-11-30 21:47:02","2025-11-30 21:47:02","25532",NULL,"20"),
("1922","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-12-01 21:47:02","2025-12-01 21:47:02","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764625622;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764625622;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-12-01 22:45:04","2025-12-01 22:45:04","25602",NULL,"20"),
("1923","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-12-02 22:45:04","2025-12-02 22:45:04","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764715504;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764715504;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-12-03 05:14:19","2025-12-03 05:14:19","25628",NULL,"20"),
("1924","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-12-04 05:14:19","2025-12-04 05:14:19","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764825259;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764825259;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-12-04 05:26:56","2025-12-04 05:26:56","25661",NULL,"20"),
("1925","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-12-05 05:26:56","2025-12-05 05:26:56","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764912416;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764912416;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-12-05 05:38:13","2025-12-05 05:38:13","25733",NULL,"20"),
("1926","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-12-06 05:38:13","2025-12-06 05:38:13","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764999493;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764999493;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-12-06 09:24:40","2025-12-06 09:24:40","25770",NULL,"20"),
("1927","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-12-07 09:24:40","2025-12-07 09:24:40","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765099480;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765099480;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-12-07 09:46:54","2025-12-07 09:46:54","25808",NULL,"20"),
("1928","action_scheduler/migration_hook","complete","2025-12-07 06:28:19","2025-12-07 06:28:19","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765088899;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765088899;}","1","1","2025-12-07 06:31:30","2025-12-07 06:31:30","25799",NULL,"10"),
("1929","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-12-08 09:46:54","2025-12-08 09:46:54","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765187214;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765187214;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-12-08 09:49:19","2025-12-08 09:49:19","25845",NULL,"20"),
("1930","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-12-09 09:49:19","2025-12-09 09:49:19","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765273759;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765273759;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-12-09 10:11:53","2025-12-09 10:11:53","25895",NULL,"20"),
("1931","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-12-10 10:11:53","2025-12-10 10:11:53","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765361513;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765361513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-12-10 10:13:22","2025-12-10 10:13:22","25983",NULL,"20"),
("1932","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-12-11 10:13:22","2025-12-11 10:13:22","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765448002;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765448002;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-12-11 10:13:51","2025-12-11 10:13:51","26027",NULL,"20"),
("1933","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-12-12 10:13:51","2025-12-12 10:13:51","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765534431;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765534431;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-12-12 17:47:47","2025-12-12 17:47:47","26076",NULL,"20"),
("1934","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-12-13 17:47:47","2025-12-13 17:47:47","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765648067;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765648067;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-12-13 18:03:50","2025-12-13 18:03:50","26108",NULL,"20"),
("1935","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-12-14 18:03:50","2025-12-14 18:03:50","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765735430;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765735430;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-12-14 18:21:48","2025-12-14 18:21:48","26150",NULL,"20"),
("1936","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-12-15 18:21:48","2025-12-15 18:21:48","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765822908;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765822908;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-12-15 18:56:25","2025-12-15 18:56:25","26198",NULL,"20"),
("1937","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-12-16 18:56:25","2025-12-16 18:56:25","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765911385;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765911385;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-12-16 19:21:39","2025-12-16 19:21:39","26238",NULL,"20"),
("1938","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-12-17 19:21:39","2025-12-17 19:21:39","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765999299;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765999299;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-12-17 20:14:10","2025-12-17 20:14:10","26267",NULL,"20"),
("1939","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-12-18 20:14:10","2025-12-18 20:14:10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766088850;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766088850;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2025-12-18 20:52:34","2025-12-18 20:52:34","26319",NULL,"20"),
("1940","action_scheduler_run_recurring_actions_schedule_hook","pending","2025-12-19 20:52:34","2025-12-19 20:52:34","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766177554;s:18:\"\0*\0first_timestamp\";i:1754462252;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766177554;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL,"20");

INSERT IGNORE INTO `znE_actionscheduler_groups` VALUES 
("1","action-scheduler-migration"),
("2","wpforms"),
("3","hcaptcha"),
("4","ActionScheduler");

INSERT IGNORE INTO `znE_actionscheduler_logs` VALUES 
("5577","1909","action created","2025-11-17 10:10:33","2025-11-17 10:10:33"),
("5578","1909","action started via WP Cron","2025-11-18 10:15:11","2025-11-18 10:15:11"),
("5579","1909","action complete via WP Cron","2025-11-18 10:15:11","2025-11-18 10:15:11"),
("5580","1910","action created","2025-11-18 10:15:11","2025-11-18 10:15:11"),
("5581","1910","action started via WP Cron","2025-11-19 10:55:41","2025-11-19 10:55:41"),
("5582","1910","action complete via WP Cron","2025-11-19 10:55:41","2025-11-19 10:55:41"),
("5583","1911","action created","2025-11-19 10:55:41","2025-11-19 10:55:41"),
("5584","1911","action started via WP Cron","2025-11-20 10:56:04","2025-11-20 10:56:04"),
("5585","1911","action complete via WP Cron","2025-11-20 10:56:04","2025-11-20 10:56:04"),
("5586","1912","action created","2025-11-20 10:56:04","2025-11-20 10:56:04"),
("5587","1912","action started via WP Cron","2025-11-21 12:29:07","2025-11-21 12:29:07"),
("5588","1912","action complete via WP Cron","2025-11-21 12:29:07","2025-11-21 12:29:07"),
("5589","1913","action created","2025-11-21 12:29:07","2025-11-21 12:29:07"),
("5590","1913","action started via WP Cron","2025-11-22 12:31:34","2025-11-22 12:31:34"),
("5591","1913","action complete via WP Cron","2025-11-22 12:31:34","2025-11-22 12:31:34"),
("5592","1914","action created","2025-11-22 12:31:34","2025-11-22 12:31:34"),
("5593","1914","action started via WP Cron","2025-11-23 12:31:39","2025-11-23 12:31:39"),
("5594","1914","action complete via WP Cron","2025-11-23 12:31:39","2025-11-23 12:31:39"),
("5595","1915","action created","2025-11-23 12:31:39","2025-11-23 12:31:39"),
("5596","1915","action started via WP Cron","2025-11-24 14:31:55","2025-11-24 14:31:55"),
("5597","1915","action complete via WP Cron","2025-11-24 14:31:55","2025-11-24 14:31:55"),
("5598","1916","action created","2025-11-24 14:31:55","2025-11-24 14:31:55"),
("5599","1916","action started via WP Cron","2025-11-25 16:52:11","2025-11-25 16:52:11"),
("5600","1916","action complete via WP Cron","2025-11-25 16:52:11","2025-11-25 16:52:11"),
("5601","1917","action created","2025-11-25 16:52:11","2025-11-25 16:52:11"),
("5602","1917","action started via WP Cron","2025-11-26 16:55:36","2025-11-26 16:55:36"),
("5603","1917","action complete via WP Cron","2025-11-26 16:55:36","2025-11-26 16:55:36"),
("5604","1918","action created","2025-11-26 16:55:36","2025-11-26 16:55:36"),
("5605","1918","action started via WP Cron","2025-11-27 16:56:09","2025-11-27 16:56:09"),
("5606","1918","action complete via WP Cron","2025-11-27 16:56:09","2025-11-27 16:56:09"),
("5607","1919","action created","2025-11-27 16:56:09","2025-11-27 16:56:09"),
("5608","1919","action started via WP Cron","2025-11-28 19:24:15","2025-11-28 19:24:15"),
("5609","1919","action complete via WP Cron","2025-11-28 19:24:15","2025-11-28 19:24:15"),
("5610","1920","action created","2025-11-28 19:24:15","2025-11-28 19:24:15"),
("5611","1920","action started via WP Cron","2025-11-29 21:45:25","2025-11-29 21:45:25"),
("5612","1920","action complete via WP Cron","2025-11-29 21:45:25","2025-11-29 21:45:25"),
("5613","1921","action created","2025-11-29 21:45:25","2025-11-29 21:45:25"),
("5614","1921","action started via WP Cron","2025-11-30 21:47:02","2025-11-30 21:47:02"),
("5615","1921","action complete via WP Cron","2025-11-30 21:47:02","2025-11-30 21:47:02"),
("5616","1922","action created","2025-11-30 21:47:02","2025-11-30 21:47:02"),
("5617","1922","action started via WP Cron","2025-12-01 22:45:04","2025-12-01 22:45:04"),
("5618","1922","action complete via WP Cron","2025-12-01 22:45:04","2025-12-01 22:45:04"),
("5619","1923","action created","2025-12-01 22:45:04","2025-12-01 22:45:04"),
("5620","1923","action started via WP Cron","2025-12-03 05:14:19","2025-12-03 05:14:19"),
("5621","1923","action complete via WP Cron","2025-12-03 05:14:19","2025-12-03 05:14:19"),
("5622","1924","action created","2025-12-03 05:14:19","2025-12-03 05:14:19"),
("5623","1924","action started via WP Cron","2025-12-04 05:26:56","2025-12-04 05:26:56"),
("5624","1924","action complete via WP Cron","2025-12-04 05:26:56","2025-12-04 05:26:56"),
("5625","1925","action created","2025-12-04 05:26:56","2025-12-04 05:26:56"),
("5626","1925","action started via WP Cron","2025-12-05 05:38:13","2025-12-05 05:38:13"),
("5627","1925","action complete via WP Cron","2025-12-05 05:38:13","2025-12-05 05:38:13"),
("5628","1926","action created","2025-12-05 05:38:13","2025-12-05 05:38:13"),
("5629","1926","action started via WP Cron","2025-12-06 09:24:40","2025-12-06 09:24:40"),
("5630","1926","action complete via WP Cron","2025-12-06 09:24:40","2025-12-06 09:24:40"),
("5631","1927","action created","2025-12-06 09:24:40","2025-12-06 09:24:40"),
("5632","1928","action created","2025-12-07 06:27:19","2025-12-07 06:27:19"),
("5633","1928","action started via WP Cron","2025-12-07 06:31:30","2025-12-07 06:31:30"),
("5634","1928","action complete via WP Cron","2025-12-07 06:31:30","2025-12-07 06:31:30"),
("5635","1927","action started via WP Cron","2025-12-07 09:46:54","2025-12-07 09:46:54"),
("5636","1927","action complete via WP Cron","2025-12-07 09:46:54","2025-12-07 09:46:54"),
("5637","1929","action created","2025-12-07 09:46:54","2025-12-07 09:46:54"),
("5638","1929","action started via WP Cron","2025-12-08 09:49:19","2025-12-08 09:49:19"),
("5639","1929","action complete via WP Cron","2025-12-08 09:49:19","2025-12-08 09:49:19"),
("5640","1930","action created","2025-12-08 09:49:19","2025-12-08 09:49:19"),
("5641","1930","action started via WP Cron","2025-12-09 10:11:53","2025-12-09 10:11:53"),
("5642","1930","action complete via WP Cron","2025-12-09 10:11:53","2025-12-09 10:11:53"),
("5643","1931","action created","2025-12-09 10:11:53","2025-12-09 10:11:53"),
("5644","1931","action started via WP Cron","2025-12-10 10:13:22","2025-12-10 10:13:22"),
("5645","1931","action complete via WP Cron","2025-12-10 10:13:22","2025-12-10 10:13:22"),
("5646","1932","action created","2025-12-10 10:13:22","2025-12-10 10:13:22"),
("5647","1932","action started via WP Cron","2025-12-11 10:13:51","2025-12-11 10:13:51"),
("5648","1932","action complete via WP Cron","2025-12-11 10:13:51","2025-12-11 10:13:51"),
("5649","1933","action created","2025-12-11 10:13:51","2025-12-11 10:13:51"),
("5650","1933","action started via WP Cron","2025-12-12 17:47:47","2025-12-12 17:47:47"),
("5651","1933","action complete via WP Cron","2025-12-12 17:47:47","2025-12-12 17:47:47"),
("5652","1934","action created","2025-12-12 17:47:47","2025-12-12 17:47:47"),
("5653","1934","action started via WP Cron","2025-12-13 18:03:50","2025-12-13 18:03:50"),
("5654","1934","action complete via WP Cron","2025-12-13 18:03:50","2025-12-13 18:03:50"),
("5655","1935","action created","2025-12-13 18:03:50","2025-12-13 18:03:50"),
("5656","1935","action started via WP Cron","2025-12-14 18:21:48","2025-12-14 18:21:48"),
("5657","1935","action complete via WP Cron","2025-12-14 18:21:48","2025-12-14 18:21:48"),
("5658","1936","action created","2025-12-14 18:21:48","2025-12-14 18:21:48"),
("5659","1936","action started via WP Cron","2025-12-15 18:56:25","2025-12-15 18:56:25"),
("5660","1936","action complete via WP Cron","2025-12-15 18:56:25","2025-12-15 18:56:25"),
("5661","1937","action created","2025-12-15 18:56:25","2025-12-15 18:56:25"),
("5662","1937","action started via WP Cron","2025-12-16 19:21:39","2025-12-16 19:21:39"),
("5663","1937","action complete via WP Cron","2025-12-16 19:21:39","2025-12-16 19:21:39"),
("5664","1938","action created","2025-12-16 19:21:39","2025-12-16 19:21:39"),
("5665","1938","action started via WP Cron","2025-12-17 20:14:10","2025-12-17 20:14:10"),
("5666","1938","action complete via WP Cron","2025-12-17 20:14:10","2025-12-17 20:14:10"),
("5667","1939","action created","2025-12-17 20:14:10","2025-12-17 20:14:10"),
("5668","1939","action started via WP Cron","2025-12-18 20:52:34","2025-12-18 20:52:34"),
("5669","1939","action complete via WP Cron","2025-12-18 20:52:34","2025-12-18 20:52:34"),
("5670","1940","action created","2025-12-18 20:52:34","2025-12-18 20:52:34");

INSERT IGNORE INTO `znE_duplicator_activity_logs` VALUES 
("1","schedule_process","","10","Processing schedule: Monthly","{\n    \"scheduleId\": 11,\n    \"scheduleName\": \"Monthly\",\n    \"templateName\": \"Default\",\n    \"storageNames\": [\n        \"InMotion Server\"\n    ]\n}","0","4.5.22.3","2025-08-01 02:21:28","2025-08-01 02:21:28"),
("2","websites_scan","scan_start","10","Scan","{\n    \"packageId\": 91,\n    \"packageName\": \"20250801_templatewebsite\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16863,\n    \"dirCount\": 3580,\n    \"size\": 373667247\n}","0","4.5.22.3","2025-08-01 02:21:31","2025-08-01 02:21:31"),
("3","websites_scan","scan_end","10","Scan Completed","{\n    \"packageId\": 91,\n    \"packageName\": \"20250801_templatewebsite\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16863,\n    \"dirCount\": 3580,\n    \"size\": 373667247\n}","2","4.5.22.3","2025-08-01 02:21:32","2025-08-01 02:21:32"),
("4","backup_create","start","10","Backup create: 20250801_templatewebsite","{\n    \"packageId\": 91,\n    \"packageName\": \"20250801_templatewebsite\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16863,\n    \"dirCount\": 3580,\n    \"size\": 373667247,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","0","4.5.22.3","2025-08-01 02:21:33","2025-08-01 02:21:33"),
("5","backup_create","db_dump","10","Backup create: 20250801_templatewebsite - DB Dump","{\n    \"packageId\": 91,\n    \"packageName\": \"20250801_templatewebsite\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16863,\n    \"dirCount\": 3580,\n    \"size\": 373667247,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","4","4.5.22.3","2025-08-01 02:21:33","2025-08-01 02:21:33"),
("6","backup_create","file_dump","10","Backup create: 20250801_templatewebsite - File Dump","{\n    \"packageId\": 91,\n    \"packageName\": \"20250801_templatewebsite\",\n    \"packageStatus\": 40,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16863,\n    \"dirCount\": 3580,\n    \"size\": 373667247,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","4","4.5.22.3","2025-08-01 02:21:38","2025-08-01 02:21:38"),
("7","backup_create","transfer","10","Backup create: 20250801_templatewebsite - Transfer","{\n    \"packageId\": 91,\n    \"packageName\": \"20250801_templatewebsite\",\n    \"packageStatus\": 75,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16863,\n    \"dirCount\": 3580,\n    \"size\": 132488522,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","4","4.5.22.3","2025-08-01 02:22:34","2025-08-01 02:22:34"),
("8","backup_create","end","10","Backup create: 20250801_templatewebsite - Completed","{\n    \"packageId\": 91,\n    \"packageName\": \"20250801_templatewebsite\",\n    \"packageStatus\": 100,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16863,\n    \"dirCount\": 3580,\n    \"size\": 132488522,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","4","4.5.22.3","2025-08-01 02:22:35","2025-08-01 02:22:35"),
("9","schedule_process","","10","Processing schedule: Monthly","{\n    \"scheduleId\": 11,\n    \"scheduleName\": \"Monthly\",\n    \"templateName\": \"Default\",\n    \"storageNames\": [\n        \"InMotion Server\"\n    ]\n}","0","4.5.22.5","2025-09-01 09:10:52","2025-09-01 09:10:52"),
("10","websites_scan","scan_start","10","Scan","{\n    \"packageId\": 92,\n    \"packageName\": \"20250901_templatewebsite\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16974,\n    \"dirCount\": 3604,\n    \"size\": 378722843\n}","0","4.5.22.5","2025-09-01 10:33:36","2025-09-01 10:33:36"),
("11","websites_scan","scan_end","10","Scan Completed","{\n    \"packageId\": 92,\n    \"packageName\": \"20250901_templatewebsite\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16974,\n    \"dirCount\": 3604,\n    \"size\": 378722843\n}","10","4.5.22.5","2025-09-01 10:33:37","2025-09-01 10:33:37"),
("12","backup_create","start","10","Backup create: 20250901_templatewebsite","{\n    \"packageId\": 92,\n    \"packageName\": \"20250901_templatewebsite\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16974,\n    \"dirCount\": 3604,\n    \"size\": 378722843,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","0","4.5.22.5","2025-09-01 10:33:37","2025-09-01 10:33:37"),
("13","backup_create","db_dump","10","Backup create: 20250901_templatewebsite - DB Dump","{\n    \"packageId\": 92,\n    \"packageName\": \"20250901_templatewebsite\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16974,\n    \"dirCount\": 3604,\n    \"size\": 378722843,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","12","4.5.22.5","2025-09-01 10:33:37","2025-09-01 10:33:37"),
("14","backup_create","file_dump","10","Backup create: 20250901_templatewebsite - File Dump","{\n    \"packageId\": 92,\n    \"packageName\": \"20250901_templatewebsite\",\n    \"packageStatus\": 40,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16974,\n    \"dirCount\": 3604,\n    \"size\": 378722843,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","12","4.5.22.5","2025-09-01 10:33:43","2025-09-01 10:33:43"),
("15","backup_create","transfer","10","Backup create: 20250901_templatewebsite - Transfer","{\n    \"packageId\": 92,\n    \"packageName\": \"20250901_templatewebsite\",\n    \"packageStatus\": 75,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16974,\n    \"dirCount\": 3604,\n    \"size\": 134669588,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","12","4.5.22.5","2025-09-01 10:34:44","2025-09-01 10:34:44"),
("16","backup_create","end","10","Backup create: 20250901_templatewebsite - Completed","{\n    \"packageId\": 92,\n    \"packageName\": \"20250901_templatewebsite\",\n    \"packageStatus\": 100,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16974,\n    \"dirCount\": 3604,\n    \"size\": 134669588,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","12","4.5.22.5","2025-09-01 10:34:45","2025-09-01 10:34:45"),
("17","schedule_process","","10","Processing schedule: Monthly","{\n    \"scheduleId\": 11,\n    \"scheduleName\": \"Monthly\",\n    \"templateName\": \"Default\",\n    \"storageNames\": [\n        \"InMotion Server\"\n    ]\n}","0","4.5.22.6","2025-10-01 01:14:31","2025-10-01 01:14:31"),
("18","websites_scan","scan_start","10","Scan","{\n    \"packageId\": 93,\n    \"packageName\": \"20251001_templatewebsite\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16988,\n    \"dirCount\": 3607,\n    \"size\": 382866838\n}","0","4.5.22.6","2025-10-01 01:14:34","2025-10-01 01:14:34"),
("19","websites_scan","scan_end","10","Scan Completed","{\n    \"packageId\": 93,\n    \"packageName\": \"20251001_templatewebsite\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16988,\n    \"dirCount\": 3607,\n    \"size\": 382866838\n}","18","4.5.22.6","2025-10-01 01:14:35","2025-10-01 01:14:35"),
("20","backup_create","start","10","Backup create: 20251001_templatewebsite","{\n    \"packageId\": 93,\n    \"packageName\": \"20251001_templatewebsite\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16988,\n    \"dirCount\": 3607,\n    \"size\": 382866838,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","0","4.5.22.6","2025-10-01 01:14:36","2025-10-01 01:14:36"),
("21","backup_create","db_dump","10","Backup create: 20251001_templatewebsite - DB Dump","{\n    \"packageId\": 93,\n    \"packageName\": \"20251001_templatewebsite\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16988,\n    \"dirCount\": 3607,\n    \"size\": 382866838,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","20","4.5.22.6","2025-10-01 01:14:36","2025-10-01 01:14:36"),
("22","backup_create","file_dump","10","Backup create: 20251001_templatewebsite - File Dump","{\n    \"packageId\": 93,\n    \"packageName\": \"20251001_templatewebsite\",\n    \"packageStatus\": 40,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16988,\n    \"dirCount\": 3607,\n    \"size\": 382866838,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","20","4.5.22.6","2025-10-01 01:14:41","2025-10-01 01:14:41"),
("23","backup_create","transfer","10","Backup create: 20251001_templatewebsite - Transfer","{\n    \"packageId\": 93,\n    \"packageName\": \"20251001_templatewebsite\",\n    \"packageStatus\": 75,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16988,\n    \"dirCount\": 3607,\n    \"size\": 136500853,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","20","4.5.22.6","2025-10-01 01:15:33","2025-10-01 01:15:33"),
("24","backup_create","end","10","Backup create: 20251001_templatewebsite - Completed","{\n    \"packageId\": 93,\n    \"packageName\": \"20251001_templatewebsite\",\n    \"packageStatus\": 100,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16988,\n    \"dirCount\": 3607,\n    \"size\": 136500853,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","20","4.5.22.6","2025-10-01 01:15:34","2025-10-01 01:15:34"),
("25","schedule_process","","10","Processing schedule: Monthly","{\n    \"scheduleId\": 11,\n    \"scheduleName\": \"Monthly\",\n    \"templateName\": \"Default\",\n    \"storageNames\": [\n        \"InMotion Server\"\n    ]\n}","0","4.5.23.2","2025-11-01 01:32:48","2025-11-01 01:32:48"),
("26","websites_scan","scan_start","10","Scan","{\n    \"packageId\": 94,\n    \"packageName\": \"20251101_templatewebsite\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16896,\n    \"dirCount\": 3590,\n    \"size\": 383298328,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 0,\n    \"dbSize\": 0,\n    \"dbRowCount\": 0\n}","0","4.5.23.2","2025-11-01 01:32:53","2025-11-01 01:32:53"),
("27","websites_scan","scan_end","10","Scan Completed","{\n    \"packageId\": 94,\n    \"packageName\": \"20251101_templatewebsite\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16896,\n    \"dirCount\": 3590,\n    \"size\": 383298328,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 63,\n    \"dbSize\": 23689360,\n    \"dbRowCount\": 37652\n}","26","4.5.23.2","2025-11-01 01:32:54","2025-11-01 01:32:54"),
("28","backup_create","start","10","Backup create: 20251101_templatewebsite","{\n    \"packageId\": 94,\n    \"packageName\": \"20251101_templatewebsite\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16896,\n    \"dirCount\": 3590,\n    \"size\": 383298328,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Schedule\",\n    \"scheduleName\": \"Monthly\",\n    \"storageNames\": [\n        \"InMotion Server\"\n    ],\n    \"archiveSizeDisplay\": \"0B\",\n    \"dbExcluded\": false,\n    \"dbTableCount\": 63,\n    \"dbSizeDisplay\": \"22.59MB\",\n    \"execution_start_time\": 1761960774.83409404754638671875\n}","0","4.5.23.2","2025-11-01 01:32:54","2025-11-01 01:32:54"),
("29","backup_create","db_dump","10","Backup create: 20251101_templatewebsite - DB Dump","{\n    \"packageId\": 94,\n    \"packageName\": \"20251101_templatewebsite\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16896,\n    \"dirCount\": 3590,\n    \"size\": 383298328,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Schedule\",\n    \"scheduleName\": \"Monthly\",\n    \"storageNames\": [\n        \"InMotion Server\"\n    ],\n    \"archiveSizeDisplay\": \"0B\",\n    \"dbExcluded\": false,\n    \"dbTableCount\": 63,\n    \"dbSizeDisplay\": \"22.59MB\",\n    \"execution_start_time\": 1761960774.83409404754638671875\n}","28","4.5.23.2","2025-11-01 01:32:54","2025-11-01 01:32:54"),
("30","backup_create","file_dump","10","Backup create: 20251101_templatewebsite - File Dump","{\n    \"packageId\": 94,\n    \"packageName\": \"20251101_templatewebsite\",\n    \"packageStatus\": 40,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16896,\n    \"dirCount\": 3590,\n    \"size\": 383298328,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Schedule\",\n    \"scheduleName\": \"Monthly\",\n    \"storageNames\": [\n        \"InMotion Server\"\n    ],\n    \"archiveSizeDisplay\": \"0B\",\n    \"dbExcluded\": false,\n    \"dbTableCount\": 63,\n    \"dbSizeDisplay\": \"22.59MB\",\n    \"execution_start_time\": 1761960774.83409404754638671875\n}","28","4.5.23.2","2025-11-01 01:32:59","2025-11-01 01:32:59"),
("31","backup_create","transfer","10","Backup create: 20251101_templatewebsite - Transfer","{\n    \"packageId\": 94,\n    \"packageName\": \"20251101_templatewebsite\",\n    \"packageStatus\": 75,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16896,\n    \"dirCount\": 3590,\n    \"size\": 138290692,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Schedule\",\n    \"scheduleName\": \"Monthly\",\n    \"storageNames\": [\n        \"InMotion Server\"\n    ],\n    \"archiveSizeDisplay\": \"131.88MB\",\n    \"dbExcluded\": false,\n    \"dbTableCount\": 63,\n    \"dbSizeDisplay\": \"22.59MB\",\n    \"execution_start_time\": 1761960774.83409404754638671875,\n    \"uploadSummaries\": [\n        {\n            \"storageId\": 10,\n            \"name\": \"InMotion Server\",\n            \"status\": \"Pending\",\n            \"progress\": 0,\n            \"startedAt\": 0,\n            \"stoppedAt\": 0\n        }\n    ]\n}","28","4.5.23.2","2025-11-01 01:33:53","2025-11-01 01:33:53"),
("32","backup_create","end","10","Backup create: 20251101_templatewebsite - Completed","{\n    \"packageId\": 94,\n    \"packageName\": \"20251101_templatewebsite\",\n    \"packageStatus\": 100,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16896,\n    \"dirCount\": 3590,\n    \"size\": 138290692,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Schedule\",\n    \"scheduleName\": \"Monthly\",\n    \"storageNames\": [\n        \"InMotion Server\"\n    ],\n    \"archiveSizeDisplay\": \"131.88MB\",\n    \"dbExcluded\": false,\n    \"dbTableCount\": 63,\n    \"dbSizeDisplay\": \"22.59MB\",\n    \"execution_start_time\": 1761960774.83409404754638671875,\n    \"total_runtime\": \"57.672 sec.\",\n    \"uploadSummaries\": [\n        {\n            \"storageId\": 10,\n            \"name\": \"InMotion Server\",\n            \"status\": \"Succeeded\",\n            \"progress\": 0,\n            \"startedAt\": 1761960833,\n            \"stoppedAt\": 1761960834\n        }\n    ]\n}","28","4.5.23.2","2025-11-01 01:33:54","2025-11-01 01:33:54"),
("33","schedule_process","","10","Backup schedule processing: Monthly","{\n    \"scheduleId\": 11,\n    \"scheduleName\": \"Monthly\",\n    \"templateName\": \"Default\",\n    \"storageNames\": [\n        \"InMotion Server\"\n    ]\n}","0","4.5.24.1","2025-12-01 01:17:28","2025-12-01 01:17:28"),
("34","websites_scan","scan_start","10","Scan","{\n    \"packageId\": 95,\n    \"packageName\": \"20251201_templatewebsite\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17059,\n    \"dirCount\": 3616,\n    \"size\": 388588551,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 0,\n    \"dbSize\": 0,\n    \"dbRowCount\": 0\n}","0","4.5.24.1","2025-12-01 01:17:32","2025-12-01 01:17:32"),
("35","websites_scan","scan_end","10","Scan Completed","{\n    \"packageId\": 95,\n    \"packageName\": \"20251201_templatewebsite\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17059,\n    \"dirCount\": 3616,\n    \"size\": 388588551,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 63,\n    \"dbSize\": 23548528,\n    \"dbRowCount\": 36623\n}","34","4.5.24.1","2025-12-01 01:17:33","2025-12-01 01:17:33"),
("36","backup_create","start","10","Backup creation: 20251201_templatewebsite","{\n    \"packageId\": 95,\n    \"packageName\": \"20251201_templatewebsite\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251201_templatewebsite_2332235a50743cb67272_20251201011728\",\n    \"logFileName\": \"20251201_templatewebsite_2332235a50743cb67272_20251201011728_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17059,\n    \"dirCount\": 3616,\n    \"size\": 388588551,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Schedule\",\n    \"scheduleName\": \"Monthly\",\n    \"storageNames\": [\n        \"InMotion Server\"\n    ],\n    \"archiveSizeDisplay\": \"133.06MB\",\n    \"uploadSummaries\": {\n        \"completed\": 1,\n        \"total\": 1\n    },\n    \"dbExcluded\": false,\n    \"dbTableCount\": 63,\n    \"dbSizeDisplay\": \"22.46MB\",\n    \"execution_start_time\": 1764551854.2721059322357177734375\n}","0","4.5.24.1","2025-12-01 01:17:34","2025-12-01 01:18:37"),
("37","backup_create","db_dump","10","Backup creation: 20251201_templatewebsite - Database Dump","{\n    \"packageId\": 95,\n    \"packageName\": \"20251201_templatewebsite\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251201_templatewebsite_2332235a50743cb67272_20251201011728\",\n    \"logFileName\": \"20251201_templatewebsite_2332235a50743cb67272_20251201011728_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17059,\n    \"dirCount\": 3616,\n    \"size\": 388588551,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Schedule\",\n    \"scheduleName\": \"Monthly\",\n    \"storageNames\": [\n        \"InMotion Server\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 63,\n    \"dbSizeDisplay\": \"22.46MB\",\n    \"execution_start_time\": 1764551854.2721059322357177734375\n}","36","4.5.24.1","2025-12-01 01:17:34","2025-12-01 01:17:34"),
("38","backup_create","file_dump","10","Backup creation: 20251201_templatewebsite - File Archive","{\n    \"packageId\": 95,\n    \"packageName\": \"20251201_templatewebsite\",\n    \"packageStatus\": 40,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251201_templatewebsite_2332235a50743cb67272_20251201011728\",\n    \"logFileName\": \"20251201_templatewebsite_2332235a50743cb67272_20251201011728_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17059,\n    \"dirCount\": 3616,\n    \"size\": 388588551,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Schedule\",\n    \"scheduleName\": \"Monthly\",\n    \"storageNames\": [\n        \"InMotion Server\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 63,\n    \"dbSizeDisplay\": \"22.46MB\",\n    \"execution_start_time\": 1764551854.2721059322357177734375\n}","36","4.5.24.1","2025-12-01 01:17:39","2025-12-01 01:17:39"),
("39","backup_create","transfer","10","Backup creation: 20251201_templatewebsite - Transfer","{\n    \"packageId\": 95,\n    \"packageName\": \"20251201_templatewebsite\",\n    \"packageStatus\": 75,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251201_templatewebsite_2332235a50743cb67272_20251201011728\",\n    \"logFileName\": \"20251201_templatewebsite_2332235a50743cb67272_20251201011728_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17059,\n    \"dirCount\": 3616,\n    \"size\": 139523738,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Schedule\",\n    \"scheduleName\": \"Monthly\",\n    \"storageNames\": [\n        \"InMotion Server\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 63,\n    \"dbSizeDisplay\": \"22.46MB\",\n    \"execution_start_time\": 1764551854.2721059322357177734375\n}","36","4.5.24.1","2025-12-01 01:18:36","2025-12-01 01:18:36"),
("40","backup_create","end","10","Backup creation: 20251201_templatewebsite - Completed","{\n    \"packageId\": 95,\n    \"packageName\": \"20251201_templatewebsite\",\n    \"packageStatus\": 100,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251201_templatewebsite_2332235a50743cb67272_20251201011728\",\n    \"logFileName\": \"20251201_templatewebsite_2332235a50743cb67272_20251201011728_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17059,\n    \"dirCount\": 3616,\n    \"size\": 139523738,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Schedule\",\n    \"scheduleName\": \"Monthly\",\n    \"storageNames\": [\n        \"InMotion Server\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 63,\n    \"dbSizeDisplay\": \"22.46MB\",\n    \"execution_start_time\": 1764551854.2721059322357177734375,\n    \"total_runtime\": \"61.395 sec.\"\n}","36","4.5.24.1","2025-12-01 01:18:37","2025-12-01 01:18:37"),
("41","schedule_process","","10","Backup schedule processing: Monthly","{\n    \"scheduleId\": 11,\n    \"scheduleName\": \"Monthly\",\n    \"templateName\": \"Default\",\n    \"storageNames\": [\n        \"BackBlaze\"\n    ]\n}","0","4.5.24.1","2025-12-01 06:28:37","2025-12-01 06:28:37"),
("42","websites_scan","scan_start","10","Scan","{\n    \"packageId\": 96,\n    \"packageName\": \"20251201_templatewebsite\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17059,\n    \"dirCount\": 3616,\n    \"size\": 388588877,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 0,\n    \"dbSize\": 0,\n    \"dbRowCount\": 0\n}","0","4.5.24.1","2025-12-01 06:28:40","2025-12-01 06:28:40"),
("43","websites_scan","scan_end","10","Scan Completed","{\n    \"packageId\": 96,\n    \"packageName\": \"20251201_templatewebsite\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17059,\n    \"dirCount\": 3616,\n    \"size\": 388588877,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 63,\n    \"dbSize\": 23565372,\n    \"dbRowCount\": 36643\n}","42","4.5.24.1","2025-12-01 06:28:41","2025-12-01 06:28:41"),
("44","backup_create","start","10","Backup creation: 20251201_templatewebsite","{\n    \"packageId\": 96,\n    \"packageName\": \"20251201_templatewebsite\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251201_templatewebsite_11ac5eab1fa7323b6183_20251201062837\",\n    \"logFileName\": \"20251201_templatewebsite_11ac5eab1fa7323b6183_20251201062837_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17059,\n    \"dirCount\": 3616,\n    \"size\": 388588877,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Schedule (Run Now)\",\n    \"scheduleName\": \"Monthly\",\n    \"storageNames\": [\n        \"BackBlaze\"\n    ],\n    \"archiveSizeDisplay\": \"133.06MB\",\n    \"uploadSummaries\": {\n        \"completed\": 2,\n        \"total\": 2\n    },\n    \"dbExcluded\": false,\n    \"dbTableCount\": 63,\n    \"dbSizeDisplay\": \"22.47MB\",\n    \"execution_start_time\": 1764570522.266686916351318359375\n}","0","4.5.24.1","2025-12-01 06:28:42","2025-12-01 06:32:20"),
("45","backup_create","db_dump","10","Backup creation: 20251201_templatewebsite - Database Dump","{\n    \"packageId\": 96,\n    \"packageName\": \"20251201_templatewebsite\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251201_templatewebsite_11ac5eab1fa7323b6183_20251201062837\",\n    \"logFileName\": \"20251201_templatewebsite_11ac5eab1fa7323b6183_20251201062837_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17059,\n    \"dirCount\": 3616,\n    \"size\": 388588877,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Schedule (Run Now)\",\n    \"scheduleName\": \"Monthly\",\n    \"storageNames\": [\n        \"BackBlaze\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 63,\n    \"dbSizeDisplay\": \"22.47MB\",\n    \"execution_start_time\": 1764570522.266686916351318359375\n}","44","4.5.24.1","2025-12-01 06:28:42","2025-12-01 06:28:42"),
("46","backup_create","file_dump","10","Backup creation: 20251201_templatewebsite - File Archive","{\n    \"packageId\": 96,\n    \"packageName\": \"20251201_templatewebsite\",\n    \"packageStatus\": 40,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251201_templatewebsite_11ac5eab1fa7323b6183_20251201062837\",\n    \"logFileName\": \"20251201_templatewebsite_11ac5eab1fa7323b6183_20251201062837_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17059,\n    \"dirCount\": 3616,\n    \"size\": 388588877,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Schedule (Run Now)\",\n    \"scheduleName\": \"Monthly\",\n    \"storageNames\": [\n        \"BackBlaze\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 63,\n    \"dbSizeDisplay\": \"22.47MB\",\n    \"execution_start_time\": 1764570522.266686916351318359375\n}","44","4.5.24.1","2025-12-01 06:28:48","2025-12-01 06:28:48"),
("47","backup_create","transfer","10","Backup creation: 20251201_templatewebsite - Transfer","{\n    \"packageId\": 96,\n    \"packageName\": \"20251201_templatewebsite\",\n    \"packageStatus\": 75,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251201_templatewebsite_11ac5eab1fa7323b6183_20251201062837\",\n    \"logFileName\": \"20251201_templatewebsite_11ac5eab1fa7323b6183_20251201062837_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17059,\n    \"dirCount\": 3616,\n    \"size\": 139523168,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Schedule (Run Now)\",\n    \"scheduleName\": \"Monthly\",\n    \"storageNames\": [\n        \"BackBlaze\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 63,\n    \"dbSizeDisplay\": \"22.47MB\",\n    \"execution_start_time\": 1764570522.266686916351318359375\n}","44","4.5.24.1","2025-12-01 06:29:44","2025-12-01 06:29:44"),
("48","backup_create","end","10","Backup creation: 20251201_templatewebsite - Completed","{\n    \"packageId\": 96,\n    \"packageName\": \"20251201_templatewebsite\",\n    \"packageStatus\": 100,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251201_templatewebsite_11ac5eab1fa7323b6183_20251201062837\",\n    \"logFileName\": \"20251201_templatewebsite_11ac5eab1fa7323b6183_20251201062837_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17059,\n    \"dirCount\": 3616,\n    \"size\": 139523168,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Schedule (Run Now)\",\n    \"scheduleName\": \"Monthly\",\n    \"storageNames\": [\n        \"BackBlaze\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 63,\n    \"dbSizeDisplay\": \"22.47MB\",\n    \"execution_start_time\": 1764570522.266686916351318359375,\n    \"total_runtime\": \"61.259 sec.\"\n}","44","4.5.24.1","2025-12-01 06:30:52","2025-12-01 06:30:52"),
("49","backup_create","transfer","10","Backup creation: 20251201_templatewebsite - Transfer","{\n    \"packageId\": 96,\n    \"packageName\": \"20251201_templatewebsite\",\n    \"packageStatus\": 75,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251201_templatewebsite_11ac5eab1fa7323b6183_20251201062837\",\n    \"logFileName\": \"20251201_templatewebsite_11ac5eab1fa7323b6183_20251201062837_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17059,\n    \"dirCount\": 3616,\n    \"size\": 139523168,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Schedule (Run Now)\",\n    \"scheduleName\": \"Monthly\",\n    \"storageNames\": [\n        \"BackBlaze\",\n        \"BackBlaze\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 63,\n    \"dbSizeDisplay\": \"22.47MB\",\n    \"execution_start_time\": 1764570709.420855045318603515625\n}","44","4.5.24.1","2025-12-01 06:31:49","2025-12-01 06:31:49"),
("50","backup_create","end","10","Backup creation: 20251201_templatewebsite - Completed","{\n    \"packageId\": 96,\n    \"packageName\": \"20251201_templatewebsite\",\n    \"packageStatus\": 100,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251201_templatewebsite_11ac5eab1fa7323b6183_20251201062837\",\n    \"logFileName\": \"20251201_templatewebsite_11ac5eab1fa7323b6183_20251201062837_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 17059,\n    \"dirCount\": 3616,\n    \"size\": 139523168,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Schedule (Run Now)\",\n    \"scheduleName\": \"Monthly\",\n    \"storageNames\": [\n        \"Default\",\n        \"BackBlaze\",\n        \"BackBlaze\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 63,\n    \"dbSizeDisplay\": \"22.47MB\",\n    \"execution_start_time\": 1764570709.420855045318603515625,\n    \"total_runtime\": \"61.259 sec.\"\n}","44","4.5.24.1","2025-12-01 06:32:20","2025-12-01 06:32:20"),
("51","settings_change","import_export","10","Settings exported to file","{\n    \"user_id\": 1,\n    \"user_display\": \"webmaster\",\n    \"role\": \"administrator\",\n    \"screen\": \"\\/wp-admin\\/admin-ajax.php?action=duplicator_pro_export_settings&nonce=2a2e3f7d5a\",\n    \"ip_address\": \"173.239.214.179\",\n    \"timestamp\": 1764570925,\n    \"changes\": [],\n    \"action_type\": \"settings_export\"\n}","0","4.5.24.1","2025-12-01 06:35:25","2025-12-01 06:35:25"),
("52","settings_change","import_export","10","Settings exported to file","{\n    \"user_id\": 1,\n    \"user_display\": \"webmaster\",\n    \"role\": \"administrator\",\n    \"screen\": \"\\/wp-admin\\/admin-ajax.php?action=duplicator_pro_export_settings&nonce=2a2e3f7d5a\",\n    \"ip_address\": \"185.198.240.173\",\n    \"timestamp\": 1764571033,\n    \"changes\": [],\n    \"action_type\": \"settings_export\"\n}","0","4.5.24.1","2025-12-01 06:37:13","2025-12-01 06:37:13"),
("53","schedule_process","","10","Backup schedule processing: Monthly","{\n    \"scheduleId\": 11,\n    \"scheduleName\": \"Monthly\",\n    \"templateName\": \"Default\",\n    \"storageNames\": [\n        \"BackBlaze\"\n    ]\n}","0","4.5.24.3","2025-12-19 08:21:50","2025-12-19 08:21:50"),
("54","websites_scan","scan_start","10","Scan","{\n    \"packageId\": 97,\n    \"packageName\": \"20251219_templatewebsite\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16746,\n    \"dirCount\": 3552,\n    \"size\": 372350156,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 0,\n    \"dbSize\": 0,\n    \"dbRowCount\": 0\n}","0","4.5.24.3","2025-12-19 08:21:52","2025-12-19 08:21:52"),
("55","websites_scan","scan_end","10","Scan Completed","{\n    \"packageId\": 97,\n    \"packageName\": \"20251219_templatewebsite\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16746,\n    \"dirCount\": 3552,\n    \"size\": 372350156,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 63,\n    \"dbSize\": 21832704,\n    \"dbRowCount\": 38841\n}","54","4.5.24.3","2025-12-19 08:21:53","2025-12-19 08:21:53"),
("56","backup_create","start","10","Backup creation: 20251219_templatewebsite","{\n    \"packageId\": 97,\n    \"packageName\": \"20251219_templatewebsite\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251219_templatewebsite_b8ef4feccbfa49d43620_20251219082150\",\n    \"logFileName\": \"20251219_templatewebsite_b8ef4feccbfa49d43620_20251219082150_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16746,\n    \"dirCount\": 3552,\n    \"size\": 372350156,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Schedule (Run Now)\",\n    \"scheduleName\": \"Monthly\",\n    \"storageNames\": [\n        \"BackBlaze\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 63,\n    \"dbSizeDisplay\": \"20.82MB\",\n    \"execution_start_time\": 1766132514.4693310260772705078125\n}","0","4.5.24.3","2025-12-19 08:21:54","2025-12-19 08:21:54"),
("57","backup_create","db_dump","10","Backup creation: 20251219_templatewebsite - Database Dump","{\n    \"packageId\": 97,\n    \"packageName\": \"20251219_templatewebsite\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251219_templatewebsite_b8ef4feccbfa49d43620_20251219082150\",\n    \"logFileName\": \"20251219_templatewebsite_b8ef4feccbfa49d43620_20251219082150_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 16746,\n    \"dirCount\": 3552,\n    \"size\": 372350156,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Schedule (Run Now)\",\n    \"scheduleName\": \"Monthly\",\n    \"storageNames\": [\n        \"BackBlaze\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 63,\n    \"dbSizeDisplay\": \"20.82MB\",\n    \"execution_start_time\": 1766132514.4693310260772705078125\n}","56","4.5.24.3","2025-12-19 08:21:55","2025-12-19 08:21:55");

INSERT IGNORE INTO `znE_duplicator_backups` VALUES 
("17","20201103_003233_Monthly_templatewebsite","433c1614a5c17f029265_20201103003233","-1","2020-11-03 00:32:33","System","{\n    \"ID\": 17,\n    \"VersionWP\": \"5.5.1\",\n    \"VersionDB\": \"10.2.34\",\n    \"VersionPHP\": \"7.4.11\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20201103_003233_Monthly_templatewebsite\",\n    \"hash\": \"433c1614a5c17f029265_20201103003233\",\n    \"execType\": -1,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/satbiz5\\/charisclassical.com\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"http:\\/\\/template.strng.us\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20201103_003233_Monthly_templatewebsite_433c1614a5c17f029265_20201103003233_scan.json\",\n    \"timer_start\": 1604363558.4014871120452880859375,\n    \"Runtime\": \"43.364 sec.\",\n    \"ExeSize\": null,\n    \"ZipSize\": 0,\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/satbiz5\\/_backup\\/_template\\/\",\n            \"\\/home\\/satbiz5\\/_template\\/.opcache\",\n            \"\\/home\\/satbiz5\\/_template\\/.tmb\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/bps-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/old-cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/updraft\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wfcache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/satbiz5\\/_template\\/.htaccess\",\n            \"\\/home\\/satbiz5\\/_template\\/.user.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/php.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/web.config\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20201103_003233_Monthly_templatewebsite_433c1614a5c17f029265_20201103003233_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\",\n        \"Size\": 53352880,\n        \"Dirs\": null,\n        \"DirCount\": 1453,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 8239,\n        \"file_count\": 9693,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20201103_003233_Monthly_templatewebsite_433c1614a5c17f029265_20201103003233_installer.php\",\n        \"Size\": false,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"GDg2iY58rP1QQ6bYgMceIr7viXsQR+tk0yvHC9csRszXzY+KnII4Ik3dr\\/+srb3nNggAcx+NiYMPkz8xNBf2fw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8_general_ci\",\n                \"utf8_unicode_ci\"\n            ],\n            \"engineList\": [],\n            \"isTablesUpperCase\": 1,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"satbiz5_template\",\n            \"tablesBaseCount\": 54,\n            \"tablesFinalCount\": 54,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 17967,\n            \"tablesSizeOnDisk\": 6016562,\n            \"tablesList\": {\n                \"znE_actionscheduler_actions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"znE_actionscheduler_claims\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_groups\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_logs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"znE_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 17700\n                },\n                \"znE_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 35180\n                },\n                \"znE_eum_logs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32500\n                },\n                \"znE_evf_entries\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_entrymeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_sessions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_options\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 2025856\n                },\n                \"znE_postmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 544904\n                },\n                \"znE_posts\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 36004\n                },\n                \"znE_shortpixel_folders\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_shortpixel_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_term_relationships\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 3261\n                },\n                \"znE_term_taxonomy\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4272\n                },\n                \"znE_termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 9384\n                },\n                \"znE_terms\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 11392\n                },\n                \"znE_tm_taskmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"znE_tm_tasks\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_usermeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16848\n                },\n                \"znE_users\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 7288\n                },\n                \"znE_wfblockediplog\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 2480\n                },\n                \"znE_wfblocks7\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfconfig\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 415764\n                },\n                \"znE_wfcrawlers\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 2300\n                },\n                \"znE_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wffilemods\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1507240\n                },\n                \"znE_wfhits\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 26356\n                },\n                \"znE_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfknownfilelist\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 706336\n                },\n                \"znE_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 3012\n                },\n                \"znE_wflogins\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 7904\n                },\n                \"znE_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfls_settings\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfnotifications\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 9904\n                },\n                \"znE_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfreversecache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 2084\n                },\n                \"znE_wfsnipcache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfstatus\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 139888\n                },\n                \"znE_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wpforms_tasks_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_yoast_indexable\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 16756\n                },\n                \"znE_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_yoast_migrations\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 8552\n                },\n                \"znE_yoast_primary_term\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_yoast_seo_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 6340\n                },\n                \"znE_yoast_seo_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 2337\n                }\n            },\n            \"dbEngine\": \"\",\n            \"version\": \"10.2.34\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 5594846,\n        \"File\": \"20201103_003233_Monthly_templatewebsite_433c1614a5c17f029265_20201103003233_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": null,\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/satbiz5\\/charisclassical.com\\/wp-content\\/backups-dup-pro\\/tmp\\/20201103_003233_Monthly_templatewebsite_433c1614a5c17f029265_20201103003233_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": -1,\n    \"schedule_id\": \"11\",\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 0,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2020-11-03 00:32:33\",\n    \"updated\": \"2025-12-15 07:29:36\",\n    \"flags\": [\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 0,\n    \"mainActivityLogId\": 0\n}","20201103_003233_Monthly_templatewebsite_433c1614a5c17f029265_20201103003233_archive.zip","0","ZIP_ARCHIVE","4.5.24.2","2025-12-15 07:29:36","Standard"),
("18","20201103_060522_Monthly_templatewebsite","e4672942149a354e7877_20201103060522","-1","2020-11-03 06:05:22","System","{\n    \"ID\": 18,\n    \"Created\": \"2020-11-03 06:05:22\",\n    \"Version\": \"4.0.0.1\",\n    \"VersionWP\": \"5.5.3\",\n    \"VersionDB\": \"10.2.34\",\n    \"VersionPHP\": \"7.4.11\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20201103_060522_Monthly_templatewebsite\",\n    \"Hash\": \"e4672942149a354e7877_20201103060522\",\n    \"NameHash\": \"20201103_060522_Monthly_templatewebsite_e4672942149a354e7877_20201103060522\",\n    \"Type\": 2,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/template.strng.us\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": null,\n    \"timer_start\": 1604383825.1063320636749267578125,\n    \"Runtime\": null,\n    \"ExeSize\": null,\n    \"ZipSize\": 0,\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": null,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": null,\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/satbiz5\\/_template\",\n        \"Size\": 0,\n        \"Dirs\": [],\n        \"DirCount\": 0,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 0,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": null,\n        \"Size\": 0,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"R3OpbwlQdrtMGIXqjcN0XDnU7QBhqwdz9dP2R1CRUSHKS0h1pc403qGydboxDMqHWhcJC8vbP9d7Mhb9B2UXPg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": null,\n            \"charSetList\": [],\n            \"collationList\": [],\n            \"engineList\": [],\n            \"isTablesUpperCase\": null,\n            \"isNameUpperCase\": null,\n            \"name\": null,\n            \"tablesBaseCount\": null,\n            \"tablesFinalCount\": null,\n            \"muFilteredTableCount\": null,\n            \"tablesRowCount\": null,\n            \"tablesSizeOnDisk\": null,\n            \"tablesList\": [],\n            \"dbEngine\": \"\",\n            \"version\": null,\n            \"versionComment\": null,\n            \"viewCount\": null,\n            \"procCount\": null,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": null,\n        \"File\": null,\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": null,\n        \"Compatible\": null,\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": null\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": -1,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"10\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": null,\n            \"stopped_timestamp\": null,\n            \"chunkPosition\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1\n}","","0","","","2023-11-08 23:48:30","Standard"),
("43","20220301_025131_Monthly_templatewebsite","6f2b2ed66b7c83435347_20220301025131","-2","2022-03-01 02:51:31","System","{\n    \"ID\": 43,\n    \"VersionWP\": \"5.9.1\",\n    \"VersionDB\": \"10.2.43\",\n    \"VersionPHP\": \"7.4.28\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20220301_025131_Monthly_templatewebsite\",\n    \"hash\": \"6f2b2ed66b7c83435347_20220301025131\",\n    \"execType\": -1,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/template.strng.us\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20220301_025131_Monthly_templatewebsite_6f2b2ed66b7c83435347_20220301025131_scan.json\",\n    \"timer_start\": 1646103100.2486579418182373046875,\n    \"Runtime\": null,\n    \"ExeSize\": null,\n    \"ZipSize\": 0,\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/satbiz5\\/_backup\\/_template\\/\",\n            \"\\/home\\/satbiz5\\/_template\\/.opcache\",\n            \"\\/home\\/satbiz5\\/_template\\/.tmb\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/bps-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/old-cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/updraft\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wfcache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/satbiz5\\/_template\\/.htaccess\",\n            \"\\/home\\/satbiz5\\/_template\\/.user.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/php.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/web.config\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20220301_025131_Monthly_templatewebsite_6f2b2ed66b7c83435347_20220301025131_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/satbiz5\\/_template\",\n        \"Size\": 74146005,\n        \"Dirs\": null,\n        \"DirCount\": 2213,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 11137,\n        \"file_count\": 13350,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20220301_025131_Monthly_templatewebsite_6f2b2ed66b7c83435347_20220301025131_installer.php\",\n        \"Size\": 73353,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"5ZQm0WeDg5sd9GXBrWq3dLv43vc35DOXu\\/cynGNlNEY3+gpRmT8BTA4A7loleG3uPVWgHdzQth9FJp2Q5IFZVQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8\"\n            ],\n            \"collationList\": [\n                \"utf8_general_ci\",\n                \"utf8_unicode_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MyISAM\"\n            ],\n            \"isTablesUpperCase\": 1,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"satbiz5_template\",\n            \"tablesBaseCount\": 53,\n            \"tablesFinalCount\": 53,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 25450,\n            \"tablesSizeOnDisk\": 12218698,\n            \"tablesList\": {\n                \"znE_actionscheduler_actions\": {\n                    \"inaccurateRows\": 86,\n                    \"insertedRows\": 86,\n                    \"size\": 212992\n                },\n                \"znE_actionscheduler_claims\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_groups\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_logs\": {\n                    \"inaccurateRows\": 206,\n                    \"insertedRows\": 246,\n                    \"size\": 49152\n                },\n                \"znE_commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_comments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_duplicator_pro_entities\": {\n                    \"inaccurateRows\": 8,\n                    \"insertedRows\": 8,\n                    \"size\": 13336\n                },\n                \"znE_duplicator_pro_packages\": {\n                    \"inaccurateRows\": 28,\n                    \"insertedRows\": 28,\n                    \"size\": 758548\n                },\n                \"znE_evf_entries\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_entrymeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_sessions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_options\": {\n                    \"inaccurateRows\": 588,\n                    \"insertedRows\": 587,\n                    \"size\": 4683012\n                },\n                \"znE_postmeta\": {\n                    \"inaccurateRows\": 689,\n                    \"insertedRows\": 689,\n                    \"size\": 988028\n                },\n                \"znE_posts\": {\n                    \"inaccurateRows\": 66,\n                    \"insertedRows\": 66,\n                    \"size\": 41824\n                },\n                \"znE_shortpixel_folders\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_shortpixel_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_termmeta\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 9440\n                },\n                \"znE_terms\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": 5,\n                    \"size\": 11424\n                },\n                \"znE_term_relationships\": {\n                    \"inaccurateRows\": 14,\n                    \"insertedRows\": 14,\n                    \"size\": 3366\n                },\n                \"znE_term_taxonomy\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": 5,\n                    \"size\": 4312\n                },\n                \"znE_tm_taskmeta\": {\n                    \"inaccurateRows\": 25,\n                    \"insertedRows\": 25,\n                    \"size\": 49152\n                },\n                \"znE_tm_tasks\": {\n                    \"inaccurateRows\": 25,\n                    \"insertedRows\": 25,\n                    \"size\": 32768\n                },\n                \"znE_usermeta\": {\n                    \"inaccurateRows\": 61,\n                    \"insertedRows\": 61,\n                    \"size\": 17372\n                },\n                \"znE_users\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 7288\n                },\n                \"znE_wfblockediplog\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 2568\n                },\n                \"znE_wfblocks7\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 5216\n                },\n                \"znE_wfconfig\": {\n                    \"inaccurateRows\": 267,\n                    \"insertedRows\": 267,\n                    \"size\": 1558544\n                },\n                \"znE_wfcrawlers\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 2668\n                },\n                \"znE_wffilechanges\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wffilemods\": {\n                    \"inaccurateRows\": 10896,\n                    \"insertedRows\": 10896,\n                    \"size\": 2117720\n                },\n                \"znE_wfhits\": {\n                    \"inaccurateRows\": 118,\n                    \"insertedRows\": 118,\n                    \"size\": 177972\n                },\n                \"znE_wfhoover\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 7696\n                },\n                \"znE_wfknownfilelist\": {\n                    \"inaccurateRows\": 10896,\n                    \"insertedRows\": 10896,\n                    \"size\": 1003324\n                },\n                \"znE_wflivetraffichuman\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wflocs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 3860\n                },\n                \"znE_wflogins\": {\n                    \"inaccurateRows\": 45,\n                    \"insertedRows\": 45,\n                    \"size\": 12060\n                },\n                \"znE_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfls_settings\": {\n                    \"inaccurateRows\": 22,\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"znE_wfnotifications\": {\n                    \"inaccurateRows\": 236,\n                    \"insertedRows\": 236,\n                    \"size\": 42920\n                },\n                \"znE_wfpendingissues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfreversecache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 2348\n                },\n                \"znE_wfsnipcache\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 5164\n                },\n                \"znE_wfstatus\": {\n                    \"inaccurateRows\": 962,\n                    \"insertedRows\": 966,\n                    \"size\": 182216\n                },\n                \"znE_wftrafficrates\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wpforms_tasks_meta\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 10,\n                    \"size\": 16384\n                },\n                \"znE_yoast_indexable\": {\n                    \"inaccurateRows\": 66,\n                    \"insertedRows\": 66,\n                    \"size\": 38340\n                },\n                \"znE_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": 31,\n                    \"insertedRows\": 31,\n                    \"size\": 5771\n                },\n                \"znE_yoast_migrations\": {\n                    \"inaccurateRows\": 23,\n                    \"insertedRows\": 23,\n                    \"size\": 8652\n                },\n                \"znE_yoast_primary_term\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_yoast_seo_links\": {\n                    \"inaccurateRows\": 45,\n                    \"insertedRows\": 45,\n                    \"size\": 8828\n                },\n                \"znE_yoast_seo_meta\": {\n                    \"inaccurateRows\": 17,\n                    \"insertedRows\": 17,\n                    \"size\": 2337\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.2.43\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 10663900,\n        \"File\": \"20220301_025131_Monthly_templatewebsite_6f2b2ed66b7c83435347_20220301025131_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\\/20220301_025131_Monthly_templatewebsite_6f2b2ed66b7c83435347_20220301025131_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": -2,\n    \"schedule_id\": \"11\",\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 0,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2022-03-01 02:51:31\",\n    \"updated\": \"2025-12-15 07:29:36\",\n    \"flags\": [\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 0,\n    \"mainActivityLogId\": 0\n}","20220301_025131_Monthly_templatewebsite_6f2b2ed66b7c83435347_20220301025131_archive.zip","0","ZIP_ARCHIVE","4.5.24.2","2025-12-15 07:29:36","Standard"),
("71","20240101_012600_Monthly_templatewebsite","a62a991bc4c375b55748_20240101012600","100","2024-01-01 01:26:00","unknown","{\n    \"ID\": 71,\n    \"VersionWP\": \"6.4.2\",\n    \"VersionDB\": \"10.2.44\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20240101_012600_Monthly_templatewebsite\",\n    \"hash\": \"a62a991bc4c375b55748_20240101012600\",\n    \"execType\": 1,\n    \"notes\": \"Created by schedule Monthly\",\n    \"StorePath\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/template.strng.us\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240101_012600_Monthly_templatewebsite_a62a991bc4c375b55748_20240101012600_scan.json\",\n    \"timer_start\": 1704072367.6965649127960205078125,\n    \"Runtime\": \"73.656 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"85.12MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/satbiz5\\/_backup\\/_template\",\n            \"\\/home\\/satbiz5\\/_template\\/.opcache\",\n            \"\\/home\\/satbiz5\\/_template\\/.tmb\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/bps-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/old-cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/updraft\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wfcache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/satbiz5\\/_template\\/.htaccess\",\n            \"\\/home\\/satbiz5\\/_template\\/.user.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/php.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/web.config\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-config.php\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240101_012600_Monthly_templatewebsite_a62a991bc4c375b55748_20240101012600_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/satbiz5\\/_template\",\n        \"Size\": 89259232,\n        \"Dirs\": [],\n        \"DirCount\": 3008,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 14077,\n        \"file_count\": 17085,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240101_012600_Monthly_templatewebsite_a62a991bc4c375b55748_20240101012600_installer.php\",\n        \"Size\": 131962,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"dxsypz8\\/Ug+ZcHWGlVIupY+piE5KMIp3Hu9jReY5\\/3WibxgiDoaWDquqWxJDhsJ+aFMKBbWUN6hHbZTy24XoPA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8_unicode_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MyISAM\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": true,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"satbiz5_template\",\n            \"tablesBaseCount\": 60,\n            \"tablesFinalCount\": 60,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 30142,\n            \"tablesSizeOnDisk\": 35907809,\n            \"tablesList\": {\n                \"znE_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 89,\n                    \"size\": 212992\n                },\n                \"znE_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"252\",\n                    \"insertedRows\": 260,\n                    \"size\": 81920\n                },\n                \"znE_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_duplicator_backups\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 175200\n                },\n                \"znE_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 45636\n                },\n                \"znE_evf_entries\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_entrymeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_options\": {\n                    \"inaccurateRows\": \"586\",\n                    \"insertedRows\": 586,\n                    \"size\": 25156288\n                },\n                \"znE_postmeta\": {\n                    \"inaccurateRows\": \"706\",\n                    \"insertedRows\": 706,\n                    \"size\": 1006608\n                },\n                \"znE_posts\": {\n                    \"inaccurateRows\": \"66\",\n                    \"insertedRows\": 66,\n                    \"size\": 41440\n                },\n                \"znE_shortpixel_folders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_postmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_termmeta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 9440\n                },\n                \"znE_terms\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 11424\n                },\n                \"znE_term_relationships\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 3366\n                },\n                \"znE_term_taxonomy\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 4312\n                },\n                \"znE_tm_taskmeta\": {\n                    \"inaccurateRows\": \"25\",\n                    \"insertedRows\": 25,\n                    \"size\": 81920\n                },\n                \"znE_tm_tasks\": {\n                    \"inaccurateRows\": \"25\",\n                    \"insertedRows\": 25,\n                    \"size\": 32768\n                },\n                \"znE_usermeta\": {\n                    \"inaccurateRows\": \"62\",\n                    \"insertedRows\": 62,\n                    \"size\": 14004\n                },\n                \"znE_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 7288\n                },\n                \"znE_wfblockediplog\": {\n                    \"inaccurateRows\": \"42\",\n                    \"insertedRows\": 42,\n                    \"size\": 4388\n                },\n                \"znE_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfconfig\": {\n                    \"inaccurateRows\": \"280\",\n                    \"insertedRows\": 280,\n                    \"size\": 1728024\n                },\n                \"znE_wfcrawlers\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 2760\n                },\n                \"znE_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wffilemods\": {\n                    \"inaccurateRows\": \"12963\",\n                    \"insertedRows\": 12963,\n                    \"size\": 3823296\n                },\n                \"znE_wfhits\": {\n                    \"inaccurateRows\": \"370\",\n                    \"insertedRows\": 370,\n                    \"size\": 437920\n                },\n                \"znE_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 22196\n                },\n                \"znE_wfknownfilelist\": {\n                    \"inaccurateRows\": \"12963\",\n                    \"insertedRows\": 12963,\n                    \"size\": 2482208\n                },\n                \"znE_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wflogins\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 58,\n                    \"size\": 14356\n                },\n                \"znE_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"znE_wfls_settings\": {\n                    \"inaccurateRows\": \"27\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"znE_wfnotifications\": {\n                    \"inaccurateRows\": \"505\",\n                    \"insertedRows\": 505,\n                    \"size\": 89912\n                },\n                \"znE_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfreversecache\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 2348\n                },\n                \"znE_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 5152\n                },\n                \"znE_wfstatus\": {\n                    \"inaccurateRows\": \"957\",\n                    \"insertedRows\": 957,\n                    \"size\": 199620\n                },\n                \"znE_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wpforms_payments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"znE_wpforms_payment_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_wpforms_tasks_meta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"znE_yoast_indexable\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 16740\n                },\n                \"znE_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 5414\n                },\n                \"znE_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 8672\n                },\n                \"znE_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_yoast_seo_links\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 39,\n                    \"size\": 7876\n                },\n                \"znE_yoast_seo_meta\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 2337\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.2.44\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 34007595,\n        \"File\": \"20240101_012600_Monthly_templatewebsite_a62a991bc4c375b55748_20240101012600_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\\/20240101_012600_Monthly_templatewebsite_a62a991bc4c375b55748_20240101012600_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 100,\n    \"schedule_id\": 11,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 0,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2024-01-01 01:26:00\",\n    \"updated\": \"2025-12-15 08:55:56\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 0,\n    \"mainActivityLogId\": 0\n}","20240101_012600_Monthly_templatewebsite_a62a991bc4c375b55748_20240101012600_archive.zip","100","SCHEDULE,ZIP_ARCHIVE","4.5.24.2","2025-12-15 08:55:56","Standard"),
("72","20240201_025209_Monthly_templatewebsite","2f0b3f0c7b62c1f44526_20240201025209","100","2024-02-01 02:52:09","unknown","{\n    \"ID\": 72,\n    \"VersionWP\": \"6.4.3\",\n    \"VersionDB\": \"10.2.44\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20240201_025209_Monthly_templatewebsite\",\n    \"hash\": \"2f0b3f0c7b62c1f44526_20240201025209\",\n    \"execType\": 1,\n    \"notes\": \"Created by schedule Monthly\",\n    \"StorePath\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/template.strng.us\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240201_025209_Monthly_templatewebsite_2f0b3f0c7b62c1f44526_20240201025209_scan.json\",\n    \"timer_start\": 1706755948.0670850276947021484375,\n    \"Runtime\": \"83.700 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"86.56MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/satbiz5\\/_backup\\/_template\",\n            \"\\/home\\/satbiz5\\/_template\\/.opcache\",\n            \"\\/home\\/satbiz5\\/_template\\/.tmb\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/bps-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/old-cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/updraft\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wfcache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/satbiz5\\/_template\\/.htaccess\",\n            \"\\/home\\/satbiz5\\/_template\\/.user.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/php.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/web.config\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-config.php\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240201_025209_Monthly_templatewebsite_2f0b3f0c7b62c1f44526_20240201025209_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/satbiz5\\/_template\",\n        \"Size\": 90759689,\n        \"Dirs\": [],\n        \"DirCount\": 3072,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 14363,\n        \"file_count\": 17435,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240201_025209_Monthly_templatewebsite_2f0b3f0c7b62c1f44526_20240201025209_installer.php\",\n        \"Size\": 131962,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"Z2HU+OH\\/Xn4DfJLq2lFzzbn5YkSSHEEVs78\\/FKAds9AK6d5Nvvl8WEwkGDpd5GnIFPaJDVk3LIeGdjBNMoOlJA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8_unicode_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MyISAM\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": true,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"satbiz5_template\",\n            \"tablesBaseCount\": 60,\n            \"tablesFinalCount\": 60,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 30656,\n            \"tablesSizeOnDisk\": 36133633,\n            \"tablesList\": {\n                \"znE_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 89,\n                    \"size\": 212992\n                },\n                \"znE_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"252\",\n                    \"insertedRows\": 260,\n                    \"size\": 81920\n                },\n                \"znE_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_duplicator_backups\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 203304\n                },\n                \"znE_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 46148\n                },\n                \"znE_evf_entries\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_entrymeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_options\": {\n                    \"inaccurateRows\": \"573\",\n                    \"insertedRows\": 573,\n                    \"size\": 25170476\n                },\n                \"znE_postmeta\": {\n                    \"inaccurateRows\": \"714\",\n                    \"insertedRows\": 714,\n                    \"size\": 1006852\n                },\n                \"znE_posts\": {\n                    \"inaccurateRows\": \"65\",\n                    \"insertedRows\": 65,\n                    \"size\": 41440\n                },\n                \"znE_shortpixel_folders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_postmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_termmeta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 9440\n                },\n                \"znE_terms\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 11424\n                },\n                \"znE_term_relationships\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 3366\n                },\n                \"znE_term_taxonomy\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 4312\n                },\n                \"znE_tm_taskmeta\": {\n                    \"inaccurateRows\": \"25\",\n                    \"insertedRows\": 25,\n                    \"size\": 81920\n                },\n                \"znE_tm_tasks\": {\n                    \"inaccurateRows\": \"25\",\n                    \"insertedRows\": 25,\n                    \"size\": 32768\n                },\n                \"znE_usermeta\": {\n                    \"inaccurateRows\": \"63\",\n                    \"insertedRows\": 63,\n                    \"size\": 14068\n                },\n                \"znE_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 7288\n                },\n                \"znE_wfblockediplog\": {\n                    \"inaccurateRows\": \"52\",\n                    \"insertedRows\": 52,\n                    \"size\": 4496\n                },\n                \"znE_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfconfig\": {\n                    \"inaccurateRows\": \"283\",\n                    \"insertedRows\": 284,\n                    \"size\": 1728024\n                },\n                \"znE_wfcrawlers\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 2760\n                },\n                \"znE_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wffilemods\": {\n                    \"inaccurateRows\": \"13239\",\n                    \"insertedRows\": 13239,\n                    \"size\": 3922668\n                },\n                \"znE_wfhits\": {\n                    \"inaccurateRows\": \"300\",\n                    \"insertedRows\": 300,\n                    \"size\": 438112\n                },\n                \"znE_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 22196\n                },\n                \"znE_wfknownfilelist\": {\n                    \"inaccurateRows\": \"13239\",\n                    \"insertedRows\": 13239,\n                    \"size\": 2556880\n                },\n                \"znE_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wflogins\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 58,\n                    \"size\": 14356\n                },\n                \"znE_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"znE_wfls_settings\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"znE_wfnotifications\": {\n                    \"inaccurateRows\": \"526\",\n                    \"insertedRows\": 526,\n                    \"size\": 93228\n                },\n                \"znE_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2348\n                },\n                \"znE_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 5152\n                },\n                \"znE_wfstatus\": {\n                    \"inaccurateRows\": \"962\",\n                    \"insertedRows\": 962,\n                    \"size\": 204672\n                },\n                \"znE_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wpforms_payments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"znE_wpforms_payment_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_wpforms_tasks_meta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"znE_yoast_indexable\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 16740\n                },\n                \"znE_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 5414\n                },\n                \"znE_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 8672\n                },\n                \"znE_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_yoast_seo_links\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 39,\n                    \"size\": 7876\n                },\n                \"znE_yoast_seo_meta\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 2337\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.2.44\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 34138787,\n        \"File\": \"20240201_025209_Monthly_templatewebsite_2f0b3f0c7b62c1f44526_20240201025209_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\\/20240201_025209_Monthly_templatewebsite_2f0b3f0c7b62c1f44526_20240201025209_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 100,\n    \"schedule_id\": 11,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 0,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2024-02-01 02:52:09\",\n    \"updated\": \"2025-12-15 08:55:56\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 0,\n    \"mainActivityLogId\": 0\n}","20240201_025209_Monthly_templatewebsite_2f0b3f0c7b62c1f44526_20240201025209_archive.zip","100","SCHEDULE,ZIP_ARCHIVE","4.5.24.2","2025-12-15 08:55:56","Standard"),
("73","20240301_043013_Monthly_templatewebsite","395ac1e31b3178176922_20240301043013","100","2024-03-01 04:30:13","unknown","{\n    \"ID\": 73,\n    \"VersionWP\": \"6.4.3\",\n    \"VersionDB\": \"10.2.44\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20240301_043013_Monthly_templatewebsite\",\n    \"hash\": \"395ac1e31b3178176922_20240301043013\",\n    \"execType\": 1,\n    \"notes\": \"Created by schedule Monthly\",\n    \"StorePath\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/template.strng.us\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240301_043013_Monthly_templatewebsite_395ac1e31b3178176922_20240301043013_scan.json\",\n    \"timer_start\": 1709267424.49586200714111328125,\n    \"Runtime\": \"88.427 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"86.74MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/satbiz5\\/_backup\\/_template\",\n            \"\\/home\\/satbiz5\\/_template\\/.opcache\",\n            \"\\/home\\/satbiz5\\/_template\\/.tmb\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/bps-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/old-cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/updraft\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wfcache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/satbiz5\\/_template\\/.htaccess\",\n            \"\\/home\\/satbiz5\\/_template\\/.user.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/php.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/web.config\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-config.php\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240301_043013_Monthly_templatewebsite_395ac1e31b3178176922_20240301043013_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/satbiz5\\/_template\",\n        \"Size\": 90950966,\n        \"Dirs\": [],\n        \"DirCount\": 3079,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 14381,\n        \"file_count\": 17460,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240301_043013_Monthly_templatewebsite_395ac1e31b3178176922_20240301043013_installer.php\",\n        \"Size\": 131962,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"yZpAwBMcUfXnyKfRwcZUwsHJsSH5AiJoYuIUU2uk1KbZlSj6+Q+35LPbGdQdswdrzyy8A+5d84xEBWI7GmKxCA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8_unicode_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MyISAM\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": true,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"satbiz5_template\",\n            \"tablesBaseCount\": 60,\n            \"tablesFinalCount\": 60,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 30742,\n            \"tablesSizeOnDisk\": 36737729,\n            \"tablesList\": {\n                \"znE_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 89,\n                    \"size\": 212992\n                },\n                \"znE_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"252\",\n                    \"insertedRows\": 260,\n                    \"size\": 81920\n                },\n                \"znE_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_duplicator_backups\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 223992\n                },\n                \"znE_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 46212\n                },\n                \"znE_evf_entries\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_entrymeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_options\": {\n                    \"inaccurateRows\": \"573\",\n                    \"insertedRows\": 573,\n                    \"size\": 25638680\n                },\n                \"znE_postmeta\": {\n                    \"inaccurateRows\": \"714\",\n                    \"insertedRows\": 714,\n                    \"size\": 1006852\n                },\n                \"znE_posts\": {\n                    \"inaccurateRows\": \"65\",\n                    \"insertedRows\": 65,\n                    \"size\": 41440\n                },\n                \"znE_shortpixel_folders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_postmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_termmeta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 9440\n                },\n                \"znE_terms\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 11424\n                },\n                \"znE_term_relationships\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 3366\n                },\n                \"znE_term_taxonomy\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 4312\n                },\n                \"znE_tm_taskmeta\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 19,\n                    \"size\": 49152\n                },\n                \"znE_tm_tasks\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 19,\n                    \"size\": 32768\n                },\n                \"znE_usermeta\": {\n                    \"inaccurateRows\": \"63\",\n                    \"insertedRows\": 63,\n                    \"size\": 14068\n                },\n                \"znE_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 7288\n                },\n                \"znE_wfblockediplog\": {\n                    \"inaccurateRows\": \"43\",\n                    \"insertedRows\": 43,\n                    \"size\": 4532\n                },\n                \"znE_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfconfig\": {\n                    \"inaccurateRows\": \"285\",\n                    \"insertedRows\": 285,\n                    \"size\": 1728024\n                },\n                \"znE_wfcrawlers\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 2780\n                },\n                \"znE_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wffilemods\": {\n                    \"inaccurateRows\": \"13262\",\n                    \"insertedRows\": 13262,\n                    \"size\": 3931152\n                },\n                \"znE_wfhits\": {\n                    \"inaccurateRows\": \"307\",\n                    \"insertedRows\": 307,\n                    \"size\": 438284\n                },\n                \"znE_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 146344\n                },\n                \"znE_wfknownfilelist\": {\n                    \"inaccurateRows\": \"13262\",\n                    \"insertedRows\": 13262,\n                    \"size\": 2562500\n                },\n                \"znE_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wflogins\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 58,\n                    \"size\": 14356\n                },\n                \"znE_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"znE_wfls_settings\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"znE_wfnotifications\": {\n                    \"inaccurateRows\": \"545\",\n                    \"insertedRows\": 545,\n                    \"size\": 96204\n                },\n                \"znE_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 2380\n                },\n                \"znE_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 5152\n                },\n                \"znE_wfstatus\": {\n                    \"inaccurateRows\": \"987\",\n                    \"insertedRows\": 987,\n                    \"size\": 211092\n                },\n                \"znE_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wpforms_payments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"znE_wpforms_payment_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_wpforms_tasks_meta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"znE_yoast_indexable\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 16740\n                },\n                \"znE_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 5414\n                },\n                \"znE_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 8672\n                },\n                \"znE_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_yoast_seo_links\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 39,\n                    \"size\": 7876\n                },\n                \"znE_yoast_seo_meta\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 2337\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.2.44\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 34849492,\n        \"File\": \"20240301_043013_Monthly_templatewebsite_395ac1e31b3178176922_20240301043013_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\\/20240301_043013_Monthly_templatewebsite_395ac1e31b3178176922_20240301043013_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 100,\n    \"schedule_id\": 11,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 0,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2024-03-01 04:30:13\",\n    \"updated\": \"2025-12-15 07:29:36\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 0,\n    \"mainActivityLogId\": 0\n}","20240301_043013_Monthly_templatewebsite_395ac1e31b3178176922_20240301043013_archive.zip","100","SCHEDULE,ZIP_ARCHIVE","4.5.24.2","2025-12-15 07:29:36","Standard"),
("74","20240401_035510_Monthly_templatewebsite","282c8b6117ec27618136_20240401035510","100","2024-04-01 03:55:10","unknown","{\n    \"ID\": 74,\n    \"VersionWP\": \"6.4.3\",\n    \"VersionDB\": \"10.2.44\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20240401_035510_Monthly_templatewebsite\",\n    \"hash\": \"282c8b6117ec27618136_20240401035510\",\n    \"execType\": 1,\n    \"notes\": \"Created by schedule Monthly\",\n    \"StorePath\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/template.strng.us\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240401_035510_Monthly_templatewebsite_282c8b6117ec27618136_20240401035510_scan.json\",\n    \"timer_start\": 1711943718.2695109844207763671875,\n    \"Runtime\": \"64.254 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"88.82MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/satbiz5\\/_backup\\/_template\",\n            \"\\/home\\/satbiz5\\/_template\\/.opcache\",\n            \"\\/home\\/satbiz5\\/_template\\/.tmb\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/bps-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/old-cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/updraft\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wfcache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/satbiz5\\/_template\\/.htaccess\",\n            \"\\/home\\/satbiz5\\/_template\\/.user.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/php.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/web.config\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-config.php\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240401_035510_Monthly_templatewebsite_282c8b6117ec27618136_20240401035510_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/satbiz5\\/_template\",\n        \"Size\": 93138022,\n        \"Dirs\": [],\n        \"DirCount\": 3261,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 15058,\n        \"file_count\": 18319,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240401_035510_Monthly_templatewebsite_282c8b6117ec27618136_20240401035510_installer.php\",\n        \"Size\": 131962,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"mI4fCj\\/f\\/aD\\/lwZI0lfKHr0uGOgwUpxyAObTg9ZJvHT5I+I72x9nfUwiV5gB72XRmJS2W9QLYsWQ8MXI183CYg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8_unicode_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MyISAM\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": true,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"satbiz5_template\",\n            \"tablesBaseCount\": 60,\n            \"tablesFinalCount\": 60,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 32294,\n            \"tablesSizeOnDisk\": 37123957,\n            \"tablesList\": {\n                \"znE_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 89,\n                    \"size\": 212992\n                },\n                \"znE_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"252\",\n                    \"insertedRows\": 260,\n                    \"size\": 81920\n                },\n                \"znE_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_duplicator_backups\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 7,\n                    \"size\": 128404\n                },\n                \"znE_duplicator_entities\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 12,\n                    \"size\": 47520\n                },\n                \"znE_evf_entries\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_entrymeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_options\": {\n                    \"inaccurateRows\": \"563\",\n                    \"insertedRows\": 562,\n                    \"size\": 25615900\n                },\n                \"znE_postmeta\": {\n                    \"inaccurateRows\": \"714\",\n                    \"insertedRows\": 714,\n                    \"size\": 1006852\n                },\n                \"znE_posts\": {\n                    \"inaccurateRows\": \"65\",\n                    \"insertedRows\": 65,\n                    \"size\": 41324\n                },\n                \"znE_shortpixel_folders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_postmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_termmeta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 9440\n                },\n                \"znE_terms\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 11424\n                },\n                \"znE_term_relationships\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 3366\n                },\n                \"znE_term_taxonomy\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 4312\n                },\n                \"znE_tm_taskmeta\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 19,\n                    \"size\": 49152\n                },\n                \"znE_tm_tasks\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 19,\n                    \"size\": 32768\n                },\n                \"znE_usermeta\": {\n                    \"inaccurateRows\": \"63\",\n                    \"insertedRows\": 63,\n                    \"size\": 14068\n                },\n                \"znE_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 7288\n                },\n                \"znE_wfblockediplog\": {\n                    \"inaccurateRows\": \"45\",\n                    \"insertedRows\": 45,\n                    \"size\": 3816\n                },\n                \"znE_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfconfig\": {\n                    \"inaccurateRows\": \"286\",\n                    \"insertedRows\": 285,\n                    \"size\": 1740452\n                },\n                \"znE_wfcrawlers\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 2468\n                },\n                \"znE_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wffilemods\": {\n                    \"inaccurateRows\": \"13919\",\n                    \"insertedRows\": 13919,\n                    \"size\": 4214256\n                },\n                \"znE_wfhits\": {\n                    \"inaccurateRows\": \"566\",\n                    \"insertedRows\": 566,\n                    \"size\": 551824\n                },\n                \"znE_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 23804\n                },\n                \"znE_wfknownfilelist\": {\n                    \"inaccurateRows\": \"13919\",\n                    \"insertedRows\": 8500,\n                    \"size\": 2778952\n                },\n                \"znE_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wflogins\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 58,\n                    \"size\": 14356\n                },\n                \"znE_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"znE_wfls_settings\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"znE_wfnotifications\": {\n                    \"inaccurateRows\": \"563\",\n                    \"insertedRows\": 563,\n                    \"size\": 99028\n                },\n                \"znE_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfreversecache\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 2192\n                },\n                \"znE_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 5184\n                },\n                \"znE_wfstatus\": {\n                    \"inaccurateRows\": \"952\",\n                    \"insertedRows\": 975,\n                    \"size\": 209872\n                },\n                \"znE_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wpforms_payments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"znE_wpforms_payment_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_wpforms_tasks_meta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"znE_yoast_indexable\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 16740\n                },\n                \"znE_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 5414\n                },\n                \"znE_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 8672\n                },\n                \"znE_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_yoast_seo_links\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 39,\n                    \"size\": 7876\n                },\n                \"znE_yoast_seo_meta\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 2337\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.2.44\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 29980202,\n        \"File\": \"20240401_035510_Monthly_templatewebsite_282c8b6117ec27618136_20240401035510_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\\/20240401_035510_Monthly_templatewebsite_282c8b6117ec27618136_20240401035510_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 100,\n    \"schedule_id\": 11,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 0,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2024-04-01 03:55:10\",\n    \"updated\": \"2025-12-15 08:55:56\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 0,\n    \"mainActivityLogId\": 0\n}","20240401_035510_Monthly_templatewebsite_282c8b6117ec27618136_20240401035510_archive.zip","100","SCHEDULE,ZIP_ARCHIVE","4.5.24.2","2025-12-15 08:55:56","Standard");

INSERT IGNORE INTO `znE_duplicator_backups` VALUES 
("75","20240501_054241_Monthly_templatewebsite","0f3e4c16bba2eccd8250_20240501054241","100","2024-05-01 05:42:41","unknown","{\n    \"ID\": 75,\n    \"VersionWP\": \"6.5.2\",\n    \"VersionDB\": \"10.2.44\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20240501_054241_Monthly_templatewebsite\",\n    \"hash\": \"0f3e4c16bba2eccd8250_20240501054241\",\n    \"execType\": 1,\n    \"notes\": \"Created by schedule Monthly\",\n    \"StorePath\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/template.strng.us\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240501_054241_Monthly_templatewebsite_0f3e4c16bba2eccd8250_20240501054241_scan.json\",\n    \"timer_start\": 1714542166.5221550464630126953125,\n    \"Runtime\": \"63.447 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"86.9MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/satbiz5\\/_backup\\/_template\",\n            \"\\/home\\/satbiz5\\/_template\\/.opcache\",\n            \"\\/home\\/satbiz5\\/_template\\/.tmb\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/bps-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/old-cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/updraft\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wfcache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/satbiz5\\/_template\\/.htaccess\",\n            \"\\/home\\/satbiz5\\/_template\\/.user.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/php.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/web.config\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-config.php\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240501_054241_Monthly_templatewebsite_0f3e4c16bba2eccd8250_20240501054241_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/satbiz5\\/_template\",\n        \"Size\": 91121939,\n        \"Dirs\": [],\n        \"DirCount\": 3307,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 15228,\n        \"file_count\": 18535,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240501_054241_Monthly_templatewebsite_0f3e4c16bba2eccd8250_20240501054241_installer.php\",\n        \"Size\": 131962,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"SFFWGTq3yJejGa35sFY+lKxKqFrQU5bM9VkrA+iAAv7GMV6F9C6PTRPgGC939qeVFYvvAaVwOXYXc+6xU2VGYQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8_unicode_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MyISAM\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": true,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"satbiz5_template\",\n            \"tablesBaseCount\": 60,\n            \"tablesFinalCount\": 60,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 32889,\n            \"tablesSizeOnDisk\": 17689357,\n            \"tablesList\": {\n                \"znE_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 89,\n                    \"size\": 212992\n                },\n                \"znE_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"252\",\n                    \"insertedRows\": 260,\n                    \"size\": 81920\n                },\n                \"znE_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_duplicator_backups\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 149192\n                },\n                \"znE_duplicator_entities\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 12,\n                    \"size\": 47164\n                },\n                \"znE_evf_entries\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_entrymeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_options\": {\n                    \"inaccurateRows\": \"556\",\n                    \"insertedRows\": 556,\n                    \"size\": 5816900\n                },\n                \"znE_postmeta\": {\n                    \"inaccurateRows\": \"714\",\n                    \"insertedRows\": 714,\n                    \"size\": 1006852\n                },\n                \"znE_posts\": {\n                    \"inaccurateRows\": \"65\",\n                    \"insertedRows\": 65,\n                    \"size\": 41324\n                },\n                \"znE_shortpixel_folders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_postmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_termmeta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 9440\n                },\n                \"znE_terms\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 11424\n                },\n                \"znE_term_relationships\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 3366\n                },\n                \"znE_term_taxonomy\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 4312\n                },\n                \"znE_tm_taskmeta\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 19,\n                    \"size\": 49152\n                },\n                \"znE_tm_tasks\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 19,\n                    \"size\": 32768\n                },\n                \"znE_usermeta\": {\n                    \"inaccurateRows\": \"63\",\n                    \"insertedRows\": 63,\n                    \"size\": 14068\n                },\n                \"znE_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 7288\n                },\n                \"znE_wfblockediplog\": {\n                    \"inaccurateRows\": \"35\",\n                    \"insertedRows\": 35,\n                    \"size\": 3488\n                },\n                \"znE_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfconfig\": {\n                    \"inaccurateRows\": \"285\",\n                    \"insertedRows\": 285,\n                    \"size\": 1754108\n                },\n                \"znE_wfcrawlers\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 2584\n                },\n                \"znE_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wffilemods\": {\n                    \"inaccurateRows\": \"14021\",\n                    \"insertedRows\": 0,\n                    \"size\": 4248624\n                },\n                \"znE_wfhits\": {\n                    \"inaccurateRows\": \"945\",\n                    \"insertedRows\": 945,\n                    \"size\": 816344\n                },\n                \"znE_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 52588\n                },\n                \"znE_wfknownfilelist\": {\n                    \"inaccurateRows\": \"14021\",\n                    \"insertedRows\": 0,\n                    \"size\": 2797984\n                },\n                \"znE_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wflogins\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 58,\n                    \"size\": 14356\n                },\n                \"znE_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"znE_wfls_settings\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"znE_wfnotifications\": {\n                    \"inaccurateRows\": \"582\",\n                    \"insertedRows\": 582,\n                    \"size\": 102068\n                },\n                \"znE_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2268\n                },\n                \"znE_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfstatus\": {\n                    \"inaccurateRows\": \"962\",\n                    \"insertedRows\": 982,\n                    \"size\": 194736\n                },\n                \"znE_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wpforms_payments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"znE_wpforms_payment_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_wpforms_tasks_meta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"znE_yoast_indexable\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 16740\n                },\n                \"znE_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 5414\n                },\n                \"znE_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 8672\n                },\n                \"znE_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_yoast_seo_links\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 39,\n                    \"size\": 7876\n                },\n                \"znE_yoast_seo_meta\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 2337\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.2.44\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 8974563,\n        \"File\": \"20240501_054241_Monthly_templatewebsite_0f3e4c16bba2eccd8250_20240501054241_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\\/20240501_054241_Monthly_templatewebsite_0f3e4c16bba2eccd8250_20240501054241_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 100,\n    \"schedule_id\": 11,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 0,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2024-05-01 05:42:41\",\n    \"updated\": \"2025-12-15 08:55:56\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 0,\n    \"mainActivityLogId\": 0\n}","20240501_054241_Monthly_templatewebsite_0f3e4c16bba2eccd8250_20240501054241_archive.zip","100","SCHEDULE,ZIP_ARCHIVE","4.5.24.2","2025-12-15 08:55:56","Standard"),
("76","20240601_032444_Monthly_templatewebsite","6859ac079cae9b5f6587_20240601032444","100","2024-06-01 03:24:44","unknown","{\n    \"ID\": 76,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"10.2.44\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20240601_032444_Monthly_templatewebsite\",\n    \"hash\": \"6859ac079cae9b5f6587_20240601032444\",\n    \"execType\": 1,\n    \"notes\": \"Created by schedule Monthly\",\n    \"StorePath\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/template.strng.us\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240601_032444_Monthly_templatewebsite_6859ac079cae9b5f6587_20240601032444_scan.json\",\n    \"timer_start\": 1717212289.8742949962615966796875,\n    \"Runtime\": \"79.625 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"100.65MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/satbiz5\\/_backup\\/_template\",\n            \"\\/home\\/satbiz5\\/_template\\/.opcache\",\n            \"\\/home\\/satbiz5\\/_template\\/.tmb\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/bps-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/old-cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/updraft\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wfcache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/satbiz5\\/_template\\/.htaccess\",\n            \"\\/home\\/satbiz5\\/_template\\/.user.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/php.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/web.config\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-config.php\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240601_032444_Monthly_templatewebsite_6859ac079cae9b5f6587_20240601032444_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/satbiz5\\/_template\",\n        \"Size\": 105540872,\n        \"Dirs\": [],\n        \"DirCount\": 3918,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 19075,\n        \"file_count\": 22993,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240601_032444_Monthly_templatewebsite_6859ac079cae9b5f6587_20240601032444_installer.php\",\n        \"Size\": 131963,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"59tmbN6MOKLYxiQ77662NWgJ4JGfo9R2SAiSeB+WjABVQtZqGh6T8Yv2qZiHDEQieh3C8p5tiyHKxqtg5Ge3EA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8_unicode_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MyISAM\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": true,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"satbiz5_template\",\n            \"tablesBaseCount\": 60,\n            \"tablesFinalCount\": 60,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 40056,\n            \"tablesSizeOnDisk\": 21040729,\n            \"tablesList\": {\n                \"znE_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 89,\n                    \"size\": 212992\n                },\n                \"znE_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"252\",\n                    \"insertedRows\": 260,\n                    \"size\": 81920\n                },\n                \"znE_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_duplicator_backups\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 169976\n                },\n                \"znE_duplicator_entities\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 12,\n                    \"size\": 47192\n                },\n                \"znE_evf_entries\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_entrymeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_options\": {\n                    \"inaccurateRows\": \"564\",\n                    \"insertedRows\": 565,\n                    \"size\": 5917584\n                },\n                \"znE_postmeta\": {\n                    \"inaccurateRows\": \"546\",\n                    \"insertedRows\": 546,\n                    \"size\": 1310960\n                },\n                \"znE_posts\": {\n                    \"inaccurateRows\": \"53\",\n                    \"insertedRows\": 53,\n                    \"size\": 42088\n                },\n                \"znE_shortpixel_folders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_postmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_termmeta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 9440\n                },\n                \"znE_terms\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 11424\n                },\n                \"znE_term_relationships\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 3366\n                },\n                \"znE_term_taxonomy\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 4312\n                },\n                \"znE_tm_taskmeta\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 19,\n                    \"size\": 49152\n                },\n                \"znE_tm_tasks\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 19,\n                    \"size\": 32768\n                },\n                \"znE_usermeta\": {\n                    \"inaccurateRows\": \"54\",\n                    \"insertedRows\": 54,\n                    \"size\": 15524\n                },\n                \"znE_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 7288\n                },\n                \"znE_wfblockediplog\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 3560\n                },\n                \"znE_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfconfig\": {\n                    \"inaccurateRows\": \"287\",\n                    \"insertedRows\": 287,\n                    \"size\": 2236192\n                },\n                \"znE_wfcrawlers\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 2668\n                },\n                \"znE_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wffilemods\": {\n                    \"inaccurateRows\": \"17979\",\n                    \"insertedRows\": 17979,\n                    \"size\": 5628916\n                },\n                \"znE_wfhits\": {\n                    \"inaccurateRows\": \"390\",\n                    \"insertedRows\": 390,\n                    \"size\": 893288\n                },\n                \"znE_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfissues\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 11020\n                },\n                \"znE_wfknownfilelist\": {\n                    \"inaccurateRows\": \"17979\",\n                    \"insertedRows\": 17979,\n                    \"size\": 3782136\n                },\n                \"znE_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wflogins\": {\n                    \"inaccurateRows\": \"59\",\n                    \"insertedRows\": 59,\n                    \"size\": 14532\n                },\n                \"znE_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"znE_wfls_settings\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"znE_wfnotifications\": {\n                    \"inaccurateRows\": \"607\",\n                    \"insertedRows\": 607,\n                    \"size\": 108136\n                },\n                \"znE_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 2264\n                },\n                \"znE_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfstatus\": {\n                    \"inaccurateRows\": \"931\",\n                    \"insertedRows\": 931,\n                    \"size\": 229984\n                },\n                \"znE_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wpforms_payments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"znE_wpforms_payment_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_wpforms_tasks_meta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"znE_yoast_indexable\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 16740\n                },\n                \"znE_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 5414\n                },\n                \"znE_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 8672\n                },\n                \"znE_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_yoast_seo_links\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 39,\n                    \"size\": 7876\n                },\n                \"znE_yoast_seo_meta\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 2337\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.2.44\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 14013510,\n        \"File\": \"20240601_032444_Monthly_templatewebsite_6859ac079cae9b5f6587_20240601032444_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\\/20240601_032444_Monthly_templatewebsite_6859ac079cae9b5f6587_20240601032444_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 100,\n    \"schedule_id\": 11,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 0,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2024-06-01 03:24:44\",\n    \"updated\": \"2025-12-15 09:51:44\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 0,\n    \"mainActivityLogId\": 0\n}","20240601_032444_Monthly_templatewebsite_6859ac079cae9b5f6587_20240601032444_archive.zip","100","SCHEDULE,ZIP_ARCHIVE","4.5.24.2","2025-12-15 09:51:44","Standard"),
("77","20240701_014956_Monthly_templatewebsite","b6751d1e982932055750_20240701014956","100","2024-07-01 01:49:56","unknown","{\n    \"ID\": 77,\n    \"VersionWP\": \"6.5.5\",\n    \"VersionDB\": \"10.2.44\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20240701_014956_Monthly_templatewebsite\",\n    \"hash\": \"b6751d1e982932055750_20240701014956\",\n    \"execType\": 1,\n    \"notes\": \"Created by schedule Monthly\",\n    \"StorePath\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/template.strng.us\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240701_014956_Monthly_templatewebsite_b6751d1e982932055750_20240701014956_scan.json\",\n    \"timer_start\": 1719798605.2240750789642333984375,\n    \"Runtime\": \"92.320 sec.\",\n    \"ExeSize\": \"128.87KB\",\n    \"ZipSize\": \"102.64MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/satbiz5\\/_backup\\/_template\",\n            \"\\/home\\/satbiz5\\/_template\\/.opcache\",\n            \"\\/home\\/satbiz5\\/_template\\/.tmb\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/bps-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/old-cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/updraft\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wfcache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/satbiz5\\/_template\\/.htaccess\",\n            \"\\/home\\/satbiz5\\/_template\\/.user.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/php.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/web.config\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-config.php\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240701_014956_Monthly_templatewebsite_b6751d1e982932055750_20240701014956_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/satbiz5\\/_template\",\n        \"Size\": 107621817,\n        \"Dirs\": [],\n        \"DirCount\": 4022,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 19218,\n        \"file_count\": 23240,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240701_014956_Monthly_templatewebsite_b6751d1e982932055750_20240701014956_installer.php\",\n        \"Size\": 131963,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"n3KAHiRxkZHsKdomjYqMpCiVkGAobv\\/j5ouCQRLz03IdVokUHSV+yK7mVzvJfdswL5FJC2gI6NLAAIcFNm\\/XQQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8_unicode_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MyISAM\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": true,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"satbiz5_template\",\n            \"tablesBaseCount\": 60,\n            \"tablesFinalCount\": 60,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 39947,\n            \"tablesSizeOnDisk\": 21046437,\n            \"tablesList\": {\n                \"znE_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 89,\n                    \"size\": 212992\n                },\n                \"znE_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"252\",\n                    \"insertedRows\": 260,\n                    \"size\": 81920\n                },\n                \"znE_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_duplicator_backups\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 203964\n                },\n                \"znE_duplicator_entities\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 12,\n                    \"size\": 47208\n                },\n                \"znE_evf_entries\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_entrymeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_options\": {\n                    \"inaccurateRows\": \"562\",\n                    \"insertedRows\": 572,\n                    \"size\": 5917584\n                },\n                \"znE_postmeta\": {\n                    \"inaccurateRows\": \"547\",\n                    \"insertedRows\": 547,\n                    \"size\": 1310960\n                },\n                \"znE_posts\": {\n                    \"inaccurateRows\": \"53\",\n                    \"insertedRows\": 53,\n                    \"size\": 42088\n                },\n                \"znE_shortpixel_folders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_postmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_termmeta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 9440\n                },\n                \"znE_terms\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 11424\n                },\n                \"znE_term_relationships\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 3366\n                },\n                \"znE_term_taxonomy\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 4312\n                },\n                \"znE_tm_taskmeta\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 19,\n                    \"size\": 49152\n                },\n                \"znE_tm_tasks\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 19,\n                    \"size\": 32768\n                },\n                \"znE_usermeta\": {\n                    \"inaccurateRows\": \"54\",\n                    \"insertedRows\": 54,\n                    \"size\": 16136\n                },\n                \"znE_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 7288\n                },\n                \"znE_wfblockediplog\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 3560\n                },\n                \"znE_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfconfig\": {\n                    \"inaccurateRows\": \"287\",\n                    \"insertedRows\": 287,\n                    \"size\": 2284284\n                },\n                \"znE_wfcrawlers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2668\n                },\n                \"znE_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wffilemods\": {\n                    \"inaccurateRows\": \"17799\",\n                    \"insertedRows\": 17799,\n                    \"size\": 5584684\n                },\n                \"znE_wfhits\": {\n                    \"inaccurateRows\": \"630\",\n                    \"insertedRows\": 630,\n                    \"size\": 893288\n                },\n                \"znE_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfissues\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 12184\n                },\n                \"znE_wfknownfilelist\": {\n                    \"inaccurateRows\": \"17799\",\n                    \"insertedRows\": 17799,\n                    \"size\": 3744328\n                },\n                \"znE_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wflogins\": {\n                    \"inaccurateRows\": \"59\",\n                    \"insertedRows\": 59,\n                    \"size\": 14532\n                },\n                \"znE_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"znE_wfls_settings\": {\n                    \"inaccurateRows\": \"29\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"znE_wfnotifications\": {\n                    \"inaccurateRows\": \"625\",\n                    \"insertedRows\": 625,\n                    \"size\": 112012\n                },\n                \"znE_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2264\n                },\n                \"znE_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfstatus\": {\n                    \"inaccurateRows\": \"931\",\n                    \"insertedRows\": 931,\n                    \"size\": 229984\n                },\n                \"znE_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wpforms_payments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"znE_wpforms_payment_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_wpforms_tasks_meta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"znE_yoast_indexable\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 16740\n                },\n                \"znE_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 5414\n                },\n                \"znE_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 8672\n                },\n                \"znE_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_yoast_seo_links\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 39,\n                    \"size\": 7876\n                },\n                \"znE_yoast_seo_meta\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 2337\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.2.44\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 14169983,\n        \"File\": \"20240701_014956_Monthly_templatewebsite_b6751d1e982932055750_20240701014956_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\\/20240701_014956_Monthly_templatewebsite_b6751d1e982932055750_20240701014956_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 100,\n    \"schedule_id\": 11,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 0,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2024-07-01 01:49:56\",\n    \"updated\": \"2025-12-15 09:51:44\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 0,\n    \"mainActivityLogId\": 0\n}","20240701_014956_Monthly_templatewebsite_b6751d1e982932055750_20240701014956_archive.zip","100","SCHEDULE,ZIP_ARCHIVE","4.5.24.2","2025-12-15 09:51:44","Standard"),
("78","20240801_templatewebsite","99ee9d92b29d1b029713_20240801033320","-2","2024-08-01 03:33:20","unknown","{\n    \"ID\": 78,\n    \"VersionWP\": \"6.6.1\",\n    \"VersionDB\": \"10.2.44\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20240801_templatewebsite\",\n    \"hash\": \"99ee9d92b29d1b029713_20240801033320\",\n    \"execType\": 1,\n    \"notes\": \"Created by schedule Monthly\",\n    \"StorePath\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/template.strng.us\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240801_templatewebsite_99ee9d92b29d1b029713_20240801033320_scan.json\",\n    \"timer_start\": 1722483211.85167598724365234375,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/satbiz5\\/_backup\\/_template\",\n            \"\\/home\\/satbiz5\\/_template\\/.opcache\",\n            \"\\/home\\/satbiz5\\/_template\\/.tmb\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/bps-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/old-cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/updraft\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wfcache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/satbiz5\\/_template\\/.htaccess\",\n            \"\\/home\\/satbiz5\\/_template\\/.user.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/php.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/web.config\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-config.php\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240801_templatewebsite_99ee9d92b29d1b029713_20240801033320_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/satbiz5\\/_template\",\n        \"Size\": 308149000,\n        \"Dirs\": [],\n        \"DirCount\": 3275,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 14584,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240801_templatewebsite_99ee9d92b29d1b029713_20240801033320_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"8eJUXQU0VTYCG5\\/Yp\\/hjCCDDs0VVauRA57asvUvia4+75FY1gOkLOOfVfwi\\/VzJxgNXdEKuc504H7NdW3lrh+A==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8_unicode_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MyISAM\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": true,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"satbiz5_template\",\n            \"tablesBaseCount\": 60,\n            \"tablesFinalCount\": 60,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 31854,\n            \"tablesSizeOnDisk\": 19068169,\n            \"tablesList\": {\n                \"znE_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 89,\n                    \"size\": 212992\n                },\n                \"znE_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"252\",\n                    \"insertedRows\": 260,\n                    \"size\": 81920\n                },\n                \"znE_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_duplicator_backups\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 232076\n                },\n                \"znE_duplicator_entities\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 12,\n                    \"size\": 47304\n                },\n                \"znE_evf_entries\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_entrymeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_options\": {\n                    \"inaccurateRows\": \"574\",\n                    \"insertedRows\": 574,\n                    \"size\": 5917584\n                },\n                \"znE_postmeta\": {\n                    \"inaccurateRows\": \"548\",\n                    \"insertedRows\": 548,\n                    \"size\": 1310960\n                },\n                \"znE_posts\": {\n                    \"inaccurateRows\": \"53\",\n                    \"insertedRows\": 53,\n                    \"size\": 42088\n                },\n                \"znE_shortpixel_folders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_postmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_termmeta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 9440\n                },\n                \"znE_terms\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 11424\n                },\n                \"znE_term_relationships\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 3366\n                },\n                \"znE_term_taxonomy\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 4312\n                },\n                \"znE_tm_taskmeta\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 19,\n                    \"size\": 49152\n                },\n                \"znE_tm_tasks\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 19,\n                    \"size\": 32768\n                },\n                \"znE_usermeta\": {\n                    \"inaccurateRows\": \"54\",\n                    \"insertedRows\": 54,\n                    \"size\": 16420\n                },\n                \"znE_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 7288\n                },\n                \"znE_wfblockediplog\": {\n                    \"inaccurateRows\": \"50\",\n                    \"insertedRows\": 50,\n                    \"size\": 4216\n                },\n                \"znE_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 5216\n                },\n                \"znE_wfconfig\": {\n                    \"inaccurateRows\": \"287\",\n                    \"insertedRows\": 287,\n                    \"size\": 2284284\n                },\n                \"znE_wfcrawlers\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 2668\n                },\n                \"znE_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wffilemods\": {\n                    \"inaccurateRows\": \"13457\",\n                    \"insertedRows\": 13457,\n                    \"size\": 4089320\n                },\n                \"znE_wfhits\": {\n                    \"inaccurateRows\": \"1154\",\n                    \"insertedRows\": 1154,\n                    \"size\": 1410888\n                },\n                \"znE_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 12404\n                },\n                \"znE_wfknownfilelist\": {\n                    \"inaccurateRows\": \"13458\",\n                    \"insertedRows\": 13458,\n                    \"size\": 2703524\n                },\n                \"znE_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wflogins\": {\n                    \"inaccurateRows\": \"59\",\n                    \"insertedRows\": 59,\n                    \"size\": 14532\n                },\n                \"znE_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"znE_wfls_settings\": {\n                    \"inaccurateRows\": \"29\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"znE_wfnotifications\": {\n                    \"inaccurateRows\": \"641\",\n                    \"insertedRows\": 641,\n                    \"size\": 114556\n                },\n                \"znE_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2264\n                },\n                \"znE_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 5220\n                },\n                \"znE_wfstatus\": {\n                    \"inaccurateRows\": \"941\",\n                    \"insertedRows\": 941,\n                    \"size\": 229984\n                },\n                \"znE_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wpforms_payments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"znE_wpforms_payment_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_wpforms_tasks_meta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"znE_yoast_indexable\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 16740\n                },\n                \"znE_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 5414\n                },\n                \"znE_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 8672\n                },\n                \"znE_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_yoast_seo_links\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 39,\n                    \"size\": 7876\n                },\n                \"znE_yoast_seo_meta\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 2337\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.2.44\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 12100346,\n        \"File\": \"20240801_templatewebsite_99ee9d92b29d1b029713_20240801033320_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\\/20240801_templatewebsite_99ee9d92b29d1b029713_20240801033320_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": -2,\n    \"schedule_id\": 11,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 0,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": true,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2024-08-01 03:33:20\",\n    \"updated\": \"2025-12-15 09:51:44\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 0,\n    \"mainActivityLogId\": 0\n}","20240801_templatewebsite_99ee9d92b29d1b029713_20240801033320_archive.zip","-2","SCHEDULE,ZIP_ARCHIVE","4.5.24.2","2025-12-15 09:51:44","Standard"),
("79","20240805_templatewebsite","8fea04b979a6669b4562_20240805032707","100","2024-08-05 03:27:07","unknown","{\n    \"ID\": 79,\n    \"VersionWP\": \"6.6.1\",\n    \"VersionDB\": \"10.2.44\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20240805_templatewebsite\",\n    \"hash\": \"8fea04b979a6669b4562_20240805032707\",\n    \"execType\": 2,\n    \"notes\": \"Created by schedule Monthly\",\n    \"StorePath\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/template.strng.us\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240805_templatewebsite_8fea04b979a6669b4562_20240805032707_scan.json\",\n    \"timer_start\": 1722828432.047010898590087890625,\n    \"Runtime\": \"68.706 sec.\",\n    \"ExeSize\": \"128.85KB\",\n    \"ZipSize\": \"94.38MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/satbiz5\\/_backup\\/_template\",\n            \"\\/home\\/satbiz5\\/_template\\/.opcache\",\n            \"\\/home\\/satbiz5\\/_template\\/.tmb\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/bps-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/old-cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/updraft\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wfcache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/satbiz5\\/_template\\/.htaccess\",\n            \"\\/home\\/satbiz5\\/_template\\/.user.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/php.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/web.config\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-config.php\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240805_templatewebsite_8fea04b979a6669b4562_20240805032707_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/satbiz5\\/_template\",\n        \"Size\": 98965812,\n        \"Dirs\": [],\n        \"DirCount\": 3275,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 14585,\n        \"file_count\": 17860,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240805_templatewebsite_8fea04b979a6669b4562_20240805032707_installer.php\",\n        \"Size\": 131947,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"wWfYBO8yh4jReOrk6z4n+zzdWXht7o1pFphUIhDt7JgkULrm2PJLcyjAP66SXy7XVQN5cE2a5fa4Db7uSXD2rw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8_unicode_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MyISAM\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": true,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"satbiz5_template\",\n            \"tablesBaseCount\": 60,\n            \"tablesFinalCount\": 60,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 32247,\n            \"tablesSizeOnDisk\": 19091645,\n            \"tablesList\": {\n                \"znE_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 89,\n                    \"size\": 212992\n                },\n                \"znE_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"252\",\n                    \"insertedRows\": 260,\n                    \"size\": 81920\n                },\n                \"znE_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_duplicator_backups\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 12,\n                    \"size\": 252696\n                },\n                \"znE_duplicator_entities\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 12,\n                    \"size\": 47992\n                },\n                \"znE_evf_entries\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_entrymeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_options\": {\n                    \"inaccurateRows\": \"580\",\n                    \"insertedRows\": 580,\n                    \"size\": 5917584\n                },\n                \"znE_postmeta\": {\n                    \"inaccurateRows\": \"541\",\n                    \"insertedRows\": 541,\n                    \"size\": 1310960\n                },\n                \"znE_posts\": {\n                    \"inaccurateRows\": \"54\",\n                    \"insertedRows\": 54,\n                    \"size\": 42088\n                },\n                \"znE_shortpixel_folders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_postmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_termmeta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 9440\n                },\n                \"znE_terms\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 11424\n                },\n                \"znE_term_relationships\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 3366\n                },\n                \"znE_term_taxonomy\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 4312\n                },\n                \"znE_tm_taskmeta\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 19,\n                    \"size\": 49152\n                },\n                \"znE_tm_tasks\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 19,\n                    \"size\": 32768\n                },\n                \"znE_usermeta\": {\n                    \"inaccurateRows\": \"55\",\n                    \"insertedRows\": 55,\n                    \"size\": 16420\n                },\n                \"znE_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 7288\n                },\n                \"znE_wfblockediplog\": {\n                    \"inaccurateRows\": \"43\",\n                    \"insertedRows\": 43,\n                    \"size\": 4216\n                },\n                \"znE_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 5216\n                },\n                \"znE_wfconfig\": {\n                    \"inaccurateRows\": \"287\",\n                    \"insertedRows\": 287,\n                    \"size\": 2284284\n                },\n                \"znE_wfcrawlers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2668\n                },\n                \"znE_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wffilemods\": {\n                    \"inaccurateRows\": \"13453\",\n                    \"insertedRows\": 13453,\n                    \"size\": 4089884\n                },\n                \"znE_wfhits\": {\n                    \"inaccurateRows\": \"1100\",\n                    \"insertedRows\": 1100,\n                    \"size\": 1410888\n                },\n                \"znE_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 12404\n                },\n                \"znE_wfknownfilelist\": {\n                    \"inaccurateRows\": \"13454\",\n                    \"insertedRows\": 13454,\n                    \"size\": 2703392\n                },\n                \"znE_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wflocs\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 2120\n                },\n                \"znE_wflogins\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 14708\n                },\n                \"znE_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"znE_wfls_settings\": {\n                    \"inaccurateRows\": \"29\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"znE_wfnotifications\": {\n                    \"inaccurateRows\": \"644\",\n                    \"insertedRows\": 644,\n                    \"size\": 115020\n                },\n                \"znE_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 2264\n                },\n                \"znE_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 5220\n                },\n                \"znE_wfstatus\": {\n                    \"inaccurateRows\": \"1396\",\n                    \"insertedRows\": 1396,\n                    \"size\": 229984\n                },\n                \"znE_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wpforms_payments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"znE_wpforms_payment_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_wpforms_tasks_meta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"znE_yoast_indexable\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 16740\n                },\n                \"znE_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 5414\n                },\n                \"znE_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 8672\n                },\n                \"znE_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_yoast_seo_links\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 39,\n                    \"size\": 7876\n                },\n                \"znE_yoast_seo_meta\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 2337\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.2.44\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 12060016,\n        \"File\": \"20240805_templatewebsite_8fea04b979a6669b4562_20240805032707_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\\/20240805_templatewebsite_8fea04b979a6669b4562_20240805032707_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 100,\n    \"schedule_id\": 11,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 0,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2024-08-05 03:27:07\",\n    \"updated\": \"2025-12-15 09:51:44\",\n    \"flags\": [\n        \"SCHEDULE_RUN_NOW\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 0,\n    \"mainActivityLogId\": 0\n}","20240805_templatewebsite_8fea04b979a6669b4562_20240805032707_archive.zip","100","SCHEDULE_RUN_NOW,ZIP_ARCHIVE","4.5.24.2","2025-12-15 09:51:44","Standard"),
("80","20240901_templatewebsite","b2deedfbc025561e9587_20240901004644","100","2024-09-01 00:46:44","unknown","{\n    \"ID\": 80,\n    \"VersionWP\": \"6.6.1\",\n    \"VersionDB\": \"10.2.44\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20240901_templatewebsite\",\n    \"hash\": \"b2deedfbc025561e9587_20240901004644\",\n    \"execType\": 1,\n    \"notes\": \"Created by schedule Monthly\",\n    \"StorePath\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/template.strng.us\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240901_templatewebsite_b2deedfbc025561e9587_20240901004644_scan.json\",\n    \"timer_start\": 1725151613.078775882720947265625,\n    \"Runtime\": \"93.715 sec.\",\n    \"ExeSize\": \"128.85KB\",\n    \"ZipSize\": \"95.44MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/satbiz5\\/_backup\\/_template\",\n            \"\\/home\\/satbiz5\\/_template\\/.opcache\",\n            \"\\/home\\/satbiz5\\/_template\\/.tmb\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/bps-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/old-cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/updraft\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wfcache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/satbiz5\\/_template\\/.htaccess\",\n            \"\\/home\\/satbiz5\\/_template\\/.user.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/php.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/web.config\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-config.php\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240901_templatewebsite_b2deedfbc025561e9587_20240901004644_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/satbiz5\\/_template\",\n        \"Size\": 100078706,\n        \"Dirs\": [],\n        \"DirCount\": 3294,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 14767,\n        \"file_count\": 18061,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240901_templatewebsite_b2deedfbc025561e9587_20240901004644_installer.php\",\n        \"Size\": 131947,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"1DCRRK52NlzAfk6GvDqfy10peb1ICzD0j68edSj3qOuzdqXfa6bBuTJFdiDFE3gegBj2cU3AxPnK4kwkVe04rw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8_general_ci\",\n                \"utf8_unicode_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MyISAM\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": true,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"satbiz5_template\",\n            \"tablesBaseCount\": 60,\n            \"tablesFinalCount\": 60,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 31308,\n            \"tablesSizeOnDisk\": 19234005,\n            \"tablesList\": {\n                \"znE_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 89,\n                    \"size\": 212992\n                },\n                \"znE_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"252\",\n                    \"insertedRows\": 260,\n                    \"size\": 81920\n                },\n                \"znE_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_duplicator_backups\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 273244\n                },\n                \"znE_duplicator_entities\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 12,\n                    \"size\": 48032\n                },\n                \"znE_evf_entries\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_entrymeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_options\": {\n                    \"inaccurateRows\": \"566\",\n                    \"insertedRows\": 566,\n                    \"size\": 5917584\n                },\n                \"znE_postmeta\": {\n                    \"inaccurateRows\": \"546\",\n                    \"insertedRows\": 546,\n                    \"size\": 1310960\n                },\n                \"znE_posts\": {\n                    \"inaccurateRows\": \"53\",\n                    \"insertedRows\": 53,\n                    \"size\": 42088\n                },\n                \"znE_shortpixel_folders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_postmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_termmeta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 9440\n                },\n                \"znE_terms\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 11424\n                },\n                \"znE_term_relationships\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 3366\n                },\n                \"znE_term_taxonomy\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 4312\n                },\n                \"znE_tm_taskmeta\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 19,\n                    \"size\": 49152\n                },\n                \"znE_tm_tasks\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 19,\n                    \"size\": 32768\n                },\n                \"znE_usermeta\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 56,\n                    \"size\": 16420\n                },\n                \"znE_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 7288\n                },\n                \"znE_wfblockediplog\": {\n                    \"inaccurateRows\": \"22\",\n                    \"insertedRows\": 22,\n                    \"size\": 4216\n                },\n                \"znE_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 5216\n                },\n                \"znE_wfconfig\": {\n                    \"inaccurateRows\": \"287\",\n                    \"insertedRows\": 287,\n                    \"size\": 2284284\n                },\n                \"znE_wfcrawlers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2668\n                },\n                \"znE_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wffilemods\": {\n                    \"inaccurateRows\": \"13652\",\n                    \"insertedRows\": 13652,\n                    \"size\": 4156368\n                },\n                \"znE_wfhits\": {\n                    \"inaccurateRows\": \"222\",\n                    \"insertedRows\": 222,\n                    \"size\": 1410888\n                },\n                \"znE_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 12404\n                },\n                \"znE_wfknownfilelist\": {\n                    \"inaccurateRows\": \"13653\",\n                    \"insertedRows\": 13653,\n                    \"size\": 2756032\n                },\n                \"znE_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2120\n                },\n                \"znE_wflogins\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 14708\n                },\n                \"znE_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"znE_wfls_settings\": {\n                    \"inaccurateRows\": \"29\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"znE_wfnotifications\": {\n                    \"inaccurateRows\": \"661\",\n                    \"insertedRows\": 661,\n                    \"size\": 117668\n                },\n                \"znE_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2264\n                },\n                \"znE_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 5220\n                },\n                \"znE_wfstatus\": {\n                    \"inaccurateRows\": \"951\",\n                    \"insertedRows\": 951,\n                    \"size\": 229984\n                },\n                \"znE_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_wpforms_payments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"znE_wpforms_payment_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_wpforms_tasks_meta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"znE_yoast_indexable\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 16740\n                },\n                \"znE_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 5414\n                },\n                \"znE_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 8672\n                },\n                \"znE_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_yoast_seo_links\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 39,\n                    \"size\": 7876\n                },\n                \"znE_yoast_seo_meta\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 2337\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.2.44\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 11350993,\n        \"File\": \"20240901_templatewebsite_b2deedfbc025561e9587_20240901004644_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\\/20240901_templatewebsite_b2deedfbc025561e9587_20240901004644_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 100,\n    \"schedule_id\": 11,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 0,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2024-09-01 00:46:44\",\n    \"updated\": \"2025-12-15 10:10:06\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 0,\n    \"mainActivityLogId\": 0\n}","20240901_templatewebsite_b2deedfbc025561e9587_20240901004644_archive.zip","100","SCHEDULE,ZIP_ARCHIVE","4.5.24.2","2025-12-15 10:10:06","Standard");

INSERT IGNORE INTO `znE_duplicator_backups` VALUES 
("81","20241001_templatewebsite","feb589a17bdd65ce8245_20241001011122","100","2024-10-01 01:11:22","unknown","{\n    \"ID\": 81,\n    \"VersionWP\": \"6.6.2\",\n    \"VersionDB\": \"10.6.19\",\n    \"VersionPHP\": \"8.2.23\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20241001_templatewebsite\",\n    \"hash\": \"feb589a17bdd65ce8245_20241001011122\",\n    \"execType\": 1,\n    \"notes\": \"Created by schedule Monthly\",\n    \"StorePath\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/template.strng.us\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20241001_templatewebsite_feb589a17bdd65ce8245_20241001011122_scan.json\",\n    \"timer_start\": 1727748438.42224788665771484375,\n    \"Runtime\": \"3842.799 sec.\",\n    \"ExeSize\": \"128.85KB\",\n    \"ZipSize\": \"95.89MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/satbiz5\\/_backup\\/_template\",\n            \"\\/home\\/satbiz5\\/_template\\/.opcache\",\n            \"\\/home\\/satbiz5\\/_template\\/.tmb\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/bps-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/old-cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/updraft\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wfcache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/satbiz5\\/_template\\/.htaccess\",\n            \"\\/home\\/satbiz5\\/_template\\/.user.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/php.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/web.config\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-config.php\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20241001_templatewebsite_feb589a17bdd65ce8245_20241001011122_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/satbiz5\\/_template\",\n        \"Size\": 100547926,\n        \"Dirs\": [],\n        \"DirCount\": 3211,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 14672,\n        \"file_count\": 17883,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20241001_templatewebsite_feb589a17bdd65ce8245_20241001011122_installer.php\",\n        \"Size\": 131947,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"W+W2KAzY\\/u7opT5Ym7ky1fErZIXe1Yo6gwgYgMei8qK8nQBvQdgD6eWDYNAlLXEhovPgZ+aAoCLBgE45mBesPw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb3_unicode_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MyISAM\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": true,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"satbiz5_template\",\n            \"tablesBaseCount\": 60,\n            \"tablesFinalCount\": 60,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 30600,\n            \"tablesSizeOnDisk\": 17206869,\n            \"tablesList\": {\n                \"znE_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 89,\n                    \"size\": 196608\n                },\n                \"znE_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"260\",\n                    \"insertedRows\": 260,\n                    \"size\": 81920\n                },\n                \"znE_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_duplicator_backups\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 273196\n                },\n                \"znE_duplicator_entities\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 12,\n                    \"size\": 47384\n                },\n                \"znE_evf_entries\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_entrymeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_options\": {\n                    \"inaccurateRows\": \"584\",\n                    \"insertedRows\": 584,\n                    \"size\": 2606580\n                },\n                \"znE_postmeta\": {\n                    \"inaccurateRows\": \"537\",\n                    \"insertedRows\": 537,\n                    \"size\": 615996\n                },\n                \"znE_posts\": {\n                    \"inaccurateRows\": \"53\",\n                    \"insertedRows\": 53,\n                    \"size\": 40072\n                },\n                \"znE_shortpixel_folders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_postmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_termmeta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 9440\n                },\n                \"znE_terms\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 11424\n                },\n                \"znE_term_relationships\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 3282\n                },\n                \"znE_term_taxonomy\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 4304\n                },\n                \"znE_tm_taskmeta\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 49152\n                },\n                \"znE_tm_tasks\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 32768\n                },\n                \"znE_usermeta\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 56,\n                    \"size\": 16752\n                },\n                \"znE_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 7288\n                },\n                \"znE_wfblockediplog\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"znE_wfconfig\": {\n                    \"inaccurateRows\": \"261\",\n                    \"insertedRows\": 264,\n                    \"size\": 507904\n                },\n                \"znE_wfcrawlers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wffilemods\": {\n                    \"inaccurateRows\": \"13566\",\n                    \"insertedRows\": 14800,\n                    \"size\": 7880704\n                },\n                \"znE_wfhits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"znE_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfissues\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 81920\n                },\n                \"znE_wfknownfilelist\": {\n                    \"inaccurateRows\": \"13939\",\n                    \"insertedRows\": 14801,\n                    \"size\": 3686400\n                },\n                \"znE_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wflogins\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"znE_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"znE_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"znE_wfnotifications\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"znE_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"znE_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"znE_wfstatus\": {\n                    \"inaccurateRows\": \"1014\",\n                    \"insertedRows\": 927,\n                    \"size\": 311296\n                },\n                \"znE_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wpforms_payments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"znE_wpforms_payment_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_wpforms_tasks_meta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"znE_yoast_indexable\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 16740\n                },\n                \"znE_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 5414\n                },\n                \"znE_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 8672\n                },\n                \"znE_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_yoast_seo_links\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 39,\n                    \"size\": 7876\n                },\n                \"znE_yoast_seo_meta\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 2337\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.6.19\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 11742471,\n        \"File\": \"20241001_templatewebsite_feb589a17bdd65ce8245_20241001011122_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\\/20241001_templatewebsite_feb589a17bdd65ce8245_20241001011122_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 100,\n    \"schedule_id\": 11,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 0,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2024-10-01 01:11:22\",\n    \"updated\": \"2025-12-15 10:10:06\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 0,\n    \"mainActivityLogId\": 0\n}","20241001_templatewebsite_feb589a17bdd65ce8245_20241001011122_archive.zip","100","SCHEDULE,ZIP_ARCHIVE","4.5.24.2","2025-12-15 10:10:06","Standard"),
("82","20241101_templatewebsite","4241d27c5e295ae66958_20241101001517","100","2024-11-01 00:15:17","unknown","{\n    \"ID\": 82,\n    \"VersionWP\": \"6.6.2\",\n    \"VersionDB\": \"10.6.19\",\n    \"VersionPHP\": \"8.2.25\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20241101_templatewebsite\",\n    \"hash\": \"4241d27c5e295ae66958_20241101001517\",\n    \"execType\": 1,\n    \"notes\": \"Created by schedule Monthly\",\n    \"StorePath\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/template.strng.us\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20241101_templatewebsite_4241d27c5e295ae66958_20241101001517_scan.json\",\n    \"timer_start\": 1730420121.0237529277801513671875,\n    \"Runtime\": \"46.414 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"102.35MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/satbiz5\\/_backup\\/_template\",\n            \"\\/home\\/satbiz5\\/_template\\/.opcache\",\n            \"\\/home\\/satbiz5\\/_template\\/.tmb\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/bps-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/old-cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/updraft\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wfcache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/satbiz5\\/_template\\/.htaccess\",\n            \"\\/home\\/satbiz5\\/_template\\/.user.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/php.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/web.config\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-config.php\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20241101_templatewebsite_4241d27c5e295ae66958_20241101001517_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/satbiz5\\/_template\",\n        \"Size\": 107323141,\n        \"Dirs\": [],\n        \"DirCount\": 3239,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 15156,\n        \"file_count\": 18395,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20241101_templatewebsite_4241d27c5e295ae66958_20241101001517_installer.php\",\n        \"Size\": 131948,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"qzHtFbGRzLGuFQugGM+DsNOeHn98kJN4PRh\\/2k5ewNdBIKD3+MRU+WnLoH2m6sIvShvIXUGfvzuxPwnUfbBOSQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb3_unicode_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MyISAM\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": true,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"satbiz5_template\",\n            \"tablesBaseCount\": 60,\n            \"tablesFinalCount\": 60,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 32420,\n            \"tablesSizeOnDisk\": 19380860,\n            \"tablesList\": {\n                \"znE_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 89,\n                    \"size\": 196608\n                },\n                \"znE_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"260\",\n                    \"insertedRows\": 260,\n                    \"size\": 81920\n                },\n                \"znE_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_duplicator_backups\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 15,\n                    \"size\": 307368\n                },\n                \"znE_duplicator_entities\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 12,\n                    \"size\": 47436\n                },\n                \"znE_evf_entries\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_entrymeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_options\": {\n                    \"inaccurateRows\": \"593\",\n                    \"insertedRows\": 594,\n                    \"size\": 2626536\n                },\n                \"znE_postmeta\": {\n                    \"inaccurateRows\": \"549\",\n                    \"insertedRows\": 549,\n                    \"size\": 615996\n                },\n                \"znE_posts\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 58,\n                    \"size\": 44616\n                },\n                \"znE_shortpixel_folders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_postmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_termmeta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 9440\n                },\n                \"znE_terms\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 11700\n                },\n                \"znE_term_relationships\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 21,\n                    \"size\": 3513\n                },\n                \"znE_term_taxonomy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 4740\n                },\n                \"znE_tm_taskmeta\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 36,\n                    \"size\": 49152\n                },\n                \"znE_tm_tasks\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 36,\n                    \"size\": 32768\n                },\n                \"znE_usermeta\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 58,\n                    \"size\": 17540\n                },\n                \"znE_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 7288\n                },\n                \"znE_wfblockediplog\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 17,\n                    \"size\": 16384\n                },\n                \"znE_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"znE_wfconfig\": {\n                    \"inaccurateRows\": \"272\",\n                    \"insertedRows\": 275,\n                    \"size\": 2637824\n                },\n                \"znE_wfcrawlers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"znE_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wffilemods\": {\n                    \"inaccurateRows\": \"14220\",\n                    \"insertedRows\": 14823,\n                    \"size\": 7880704\n                },\n                \"znE_wfhits\": {\n                    \"inaccurateRows\": \"55\",\n                    \"insertedRows\": 90,\n                    \"size\": 131072\n                },\n                \"znE_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"znE_wfknownfilelist\": {\n                    \"inaccurateRows\": \"14994\",\n                    \"insertedRows\": 14824,\n                    \"size\": 3686400\n                },\n                \"znE_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"znE_wflogins\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"znE_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"znE_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"znE_wfnotifications\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 25,\n                    \"size\": 16384\n                },\n                \"znE_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"znE_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"znE_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"znE_wfstatus\": {\n                    \"inaccurateRows\": \"945\",\n                    \"insertedRows\": 945,\n                    \"size\": 229376\n                },\n                \"znE_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wpforms_payments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"znE_wpforms_payment_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_wpforms_tasks_meta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"znE_yoast_indexable\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 16740\n                },\n                \"znE_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 5414\n                },\n                \"znE_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 8672\n                },\n                \"znE_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_yoast_seo_links\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 39,\n                    \"size\": 7876\n                },\n                \"znE_yoast_seo_meta\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 2337\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.6.19\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 11870151,\n        \"File\": \"20241101_templatewebsite_4241d27c5e295ae66958_20241101001517_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\\/20241101_templatewebsite_4241d27c5e295ae66958_20241101001517_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 100,\n    \"schedule_id\": 11,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 0,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2024-11-01 00:15:17\",\n    \"updated\": \"2025-12-15 10:10:06\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 0,\n    \"mainActivityLogId\": 0\n}","20241101_templatewebsite_4241d27c5e295ae66958_20241101001517_archive.zip","100","SCHEDULE,ZIP_ARCHIVE","4.5.24.2","2025-12-15 10:10:06","Standard"),
("83","20241201_templatewebsite","b78a4741a81d1d8b1347_20241201000156","100","2024-12-01 00:01:56","unknown","{\n    \"ID\": 83,\n    \"VersionWP\": \"6.7.1\",\n    \"VersionDB\": \"10.6.20\",\n    \"VersionPHP\": \"8.2.25\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20241201_templatewebsite\",\n    \"hash\": \"b78a4741a81d1d8b1347_20241201000156\",\n    \"execType\": 1,\n    \"notes\": \"Created by schedule Monthly\",\n    \"StorePath\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/template.strng.us\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20241201_templatewebsite_b78a4741a81d1d8b1347_20241201000156_scan.json\",\n    \"timer_start\": 1733011320.2206089496612548828125,\n    \"Runtime\": \"3556.605 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"117.3MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/satbiz5\\/_backup\\/_template\",\n            \"\\/home\\/satbiz5\\/_template\\/.opcache\",\n            \"\\/home\\/satbiz5\\/_template\\/.tmb\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/bps-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/old-cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/updraft\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wfcache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/satbiz5\\/_template\\/.htaccess\",\n            \"\\/home\\/satbiz5\\/_template\\/.user.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/php.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/web.config\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-config.php\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20241201_templatewebsite_b78a4741a81d1d8b1347_20241201000156_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/satbiz5\\/_template\",\n        \"Size\": 123001597,\n        \"Dirs\": [],\n        \"DirCount\": 3317,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 15672,\n        \"file_count\": 18989,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20241201_templatewebsite_b78a4741a81d1d8b1347_20241201000156_installer.php\",\n        \"Size\": 131948,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"xs8wPaNU3r5DVHdkfNqZ2u7\\/1B3hMhZ3QJla7mp97D776eizJjQG37V61muzdCIMKxa9XjO5b7d3N7LD20lCuA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb3_unicode_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MyISAM\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": true,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"satbiz5_template\",\n            \"tablesBaseCount\": 61,\n            \"tablesFinalCount\": 61,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 34998,\n            \"tablesSizeOnDisk\": 20378728,\n            \"tablesList\": {\n                \"znE_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 89,\n                    \"size\": 196608\n                },\n                \"znE_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"260\",\n                    \"insertedRows\": 260,\n                    \"size\": 81920\n                },\n                \"znE_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_duplicator_backups\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 335416\n                },\n                \"znE_duplicator_entities\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 12,\n                    \"size\": 47436\n                },\n                \"znE_evf_entries\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_entrymeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_options\": {\n                    \"inaccurateRows\": \"599\",\n                    \"insertedRows\": 600,\n                    \"size\": 2626536\n                },\n                \"znE_postmeta\": {\n                    \"inaccurateRows\": \"553\",\n                    \"insertedRows\": 553,\n                    \"size\": 617020\n                },\n                \"znE_posts\": {\n                    \"inaccurateRows\": \"57\",\n                    \"insertedRows\": 57,\n                    \"size\": 46756\n                },\n                \"znE_shortpixel_folders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_postmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_termmeta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 9440\n                },\n                \"znE_terms\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 11700\n                },\n                \"znE_term_relationships\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 21,\n                    \"size\": 3513\n                },\n                \"znE_term_taxonomy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 4740\n                },\n                \"znE_tm_taskmeta\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 36,\n                    \"size\": 49152\n                },\n                \"znE_tm_tasks\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 36,\n                    \"size\": 32768\n                },\n                \"znE_usermeta\": {\n                    \"inaccurateRows\": \"59\",\n                    \"insertedRows\": 59,\n                    \"size\": 17540\n                },\n                \"znE_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 7288\n                },\n                \"znE_wfauditevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfblockediplog\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"znE_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"znE_wfconfig\": {\n                    \"inaccurateRows\": \"280\",\n                    \"insertedRows\": 282,\n                    \"size\": 2473984\n                },\n                \"znE_wfcrawlers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"znE_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wffilemods\": {\n                    \"inaccurateRows\": \"16497\",\n                    \"insertedRows\": 15707,\n                    \"size\": 8929280\n                },\n                \"znE_wfhits\": {\n                    \"inaccurateRows\": \"125\",\n                    \"insertedRows\": 119,\n                    \"size\": 180224\n                },\n                \"znE_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfissues\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"znE_wfknownfilelist\": {\n                    \"inaccurateRows\": \"15213\",\n                    \"insertedRows\": 15708,\n                    \"size\": 3686400\n                },\n                \"znE_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wflogins\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"znE_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"znE_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"znE_wfnotifications\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 46,\n                    \"size\": 16384\n                },\n                \"znE_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"znE_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"znE_wfstatus\": {\n                    \"inaccurateRows\": \"933\",\n                    \"insertedRows\": 978,\n                    \"size\": 245760\n                },\n                \"znE_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wpforms_payments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"znE_wpforms_payment_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_wpforms_tasks_meta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"znE_yoast_indexable\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 16740\n                },\n                \"znE_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 5414\n                },\n                \"znE_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 8672\n                },\n                \"znE_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_yoast_seo_links\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 39,\n                    \"size\": 7876\n                },\n                \"znE_yoast_seo_meta\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 2337\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.6.20\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 12406558,\n        \"File\": \"20241201_templatewebsite_b78a4741a81d1d8b1347_20241201000156_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\\/20241201_templatewebsite_b78a4741a81d1d8b1347_20241201000156_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 100,\n    \"schedule_id\": 11,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 0,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2024-12-01 00:01:56\",\n    \"updated\": \"2025-12-15 10:10:06\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 0,\n    \"mainActivityLogId\": 0\n}","20241201_templatewebsite_b78a4741a81d1d8b1347_20241201000156_archive.zip","100","SCHEDULE,ZIP_ARCHIVE","4.5.24.2","2025-12-15 10:10:06","Standard"),
("84","20250101_templatewebsite","3c876ab06fff866c3672_20250101003314","100","2025-01-01 00:33:14","unknown","{\n    \"ID\": 84,\n    \"VersionWP\": \"6.7.1\",\n    \"VersionDB\": \"10.6.20\",\n    \"VersionPHP\": \"8.2.26\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20250101_templatewebsite\",\n    \"hash\": \"3c876ab06fff866c3672_20250101003314\",\n    \"execType\": 1,\n    \"notes\": \"Created by schedule Monthly\",\n    \"StorePath\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"http:\\/\\/template.strng.us\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250101_templatewebsite_3c876ab06fff866c3672_20250101003314_scan.json\",\n    \"timer_start\": 1735691597.8537070751190185546875,\n    \"Runtime\": \"50.497 sec.\",\n    \"ExeSize\": \"128.66KB\",\n    \"ZipSize\": \"123MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/satbiz5\\/_backup\\/_template\",\n            \"\\/home\\/satbiz5\\/_template\\/.opcache\",\n            \"\\/home\\/satbiz5\\/_template\\/.tmb\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/bps-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/old-cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/updraft\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wfcache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/satbiz5\\/_template\\/.htaccess\",\n            \"\\/home\\/satbiz5\\/_template\\/.user.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/php.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/web.config\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-config.php\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250101_templatewebsite_3c876ab06fff866c3672_20250101003314_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/satbiz5\\/_template\",\n        \"Size\": 128975725,\n        \"Dirs\": [],\n        \"DirCount\": 3458,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 16370,\n        \"file_count\": 19827,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250101_templatewebsite_3c876ab06fff866c3672_20250101003314_installer.php\",\n        \"Size\": 131751,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"SCHc60CdjefQSUFV1VZj1MES0ljG2D9z\\/Mqubg5ZfD9yD1Rb+8bTAHRsYIGc6iRfXs\\/7z1liZLiB87ccd46+oA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb3_unicode_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MyISAM\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": true,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"satbiz5_template\",\n            \"tablesBaseCount\": 62,\n            \"tablesFinalCount\": 62,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 37475,\n            \"tablesSizeOnDisk\": 20959368,\n            \"tablesList\": {\n                \"znE_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 89,\n                    \"size\": 196608\n                },\n                \"znE_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"260\",\n                    \"insertedRows\": 260,\n                    \"size\": 81920\n                },\n                \"znE_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_duplicator_backups\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 356104\n                },\n                \"znE_duplicator_entities\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 12,\n                    \"size\": 47436\n                },\n                \"znE_evf_entries\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_entrymeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_options\": {\n                    \"inaccurateRows\": \"605\",\n                    \"insertedRows\": 606,\n                    \"size\": 2626536\n                },\n                \"znE_postmeta\": {\n                    \"inaccurateRows\": \"549\",\n                    \"insertedRows\": 549,\n                    \"size\": 652520\n                },\n                \"znE_posts\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 56,\n                    \"size\": 46756\n                },\n                \"znE_shortpixel_folders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_postmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_termmeta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 9440\n                },\n                \"znE_terms\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 11700\n                },\n                \"znE_term_relationships\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 21,\n                    \"size\": 3513\n                },\n                \"znE_term_taxonomy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 4740\n                },\n                \"znE_tm_taskmeta\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 36,\n                    \"size\": 49152\n                },\n                \"znE_tm_tasks\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 36,\n                    \"size\": 32768\n                },\n                \"znE_usermeta\": {\n                    \"inaccurateRows\": \"59\",\n                    \"insertedRows\": 59,\n                    \"size\": 17704\n                },\n                \"znE_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 7288\n                },\n                \"znE_wfauditevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfblockediplog\": {\n                    \"inaccurateRows\": \"22\",\n                    \"insertedRows\": 25,\n                    \"size\": 16384\n                },\n                \"znE_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"znE_wfconfig\": {\n                    \"inaccurateRows\": \"279\",\n                    \"insertedRows\": 282,\n                    \"size\": 2473984\n                },\n                \"znE_wfcrawlers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wffilemods\": {\n                    \"inaccurateRows\": \"17653\",\n                    \"insertedRows\": 16544,\n                    \"size\": 8929280\n                },\n                \"znE_wfhits\": {\n                    \"inaccurateRows\": \"464\",\n                    \"insertedRows\": 552,\n                    \"size\": 589824\n                },\n                \"znE_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 81920\n                },\n                \"znE_wfknownfilelist\": {\n                    \"inaccurateRows\": \"15792\",\n                    \"insertedRows\": 16545,\n                    \"size\": 3686400\n                },\n                \"znE_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wflogins\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"znE_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"znE_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"znE_wfnotifications\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 69,\n                    \"size\": 16384\n                },\n                \"znE_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"znE_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfsnipcache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"znE_wfstatus\": {\n                    \"inaccurateRows\": \"1328\",\n                    \"insertedRows\": 1459,\n                    \"size\": 294912\n                },\n                \"znE_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wpforms_payments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"znE_wpforms_payment_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_wpforms_tasks_meta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"znE_wpo_404_detector\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"znE_yoast_indexable\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 16740\n                },\n                \"znE_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 5414\n                },\n                \"znE_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 8672\n                },\n                \"znE_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_yoast_seo_links\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 39,\n                    \"size\": 7876\n                },\n                \"znE_yoast_seo_meta\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 2337\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.6.20\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 13239902,\n        \"File\": \"20250101_templatewebsite_3c876ab06fff866c3672_20250101003314_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\\/20250101_templatewebsite_3c876ab06fff866c3672_20250101003314_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 100,\n    \"schedule_id\": 11,\n    \"descriptorsMng\": {\n        \"hash\": \"3c876ab-01003314\",\n        \"date\": \"20250101003314\",\n        \"mapping\": {\n            \"orig_files\": \"orig_files\",\n            \"archive_config\": \"archive.txt\",\n            \"scan\": \"scan.json\",\n            \"file_list\": \"scanned-files.txt\",\n            \"dir_list\": \"scanned-dirs.txt\",\n            \"manual_extract\": \"manual-extract\",\n            \"db_dump\": \"db_dumps\\/20250101003314-dump.sql\",\n            \"inst_chunk_data\": \"installer-chunk-data.json\",\n            \"inst_notices\": \"installer-notices.json\",\n            \"inst_db_data\": \"installer-db-data.json\",\n            \"inst_db_seek_log\": \"installer-db-seek-tell-log.txt\",\n            \"inst_extraction_data\": \"installer-extraction.json\",\n            \"inst_s3_data\": \"installer-s3data.json\",\n            \"inst_php_error_log\": \"php_error.log\",\n            \"params\": \"params.json\"\n        }\n    },\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 0,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2025-01-01 00:33:14\",\n    \"updated\": \"2025-12-15 12:26:59\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 0,\n    \"mainActivityLogId\": 0\n}","20250101_templatewebsite_3c876ab06fff866c3672_20250101003314_archive.zip","100","SCHEDULE,ZIP_ARCHIVE","4.5.24.2","2025-12-15 12:26:59","Standard"),
("85","20250201_templatewebsite","f98a615d59c6e29b4392_20250201002652","100","2025-02-01 00:26:52","unknown","{\n    \"ID\": 85,\n    \"VersionWP\": \"6.7.1\",\n    \"VersionDB\": \"10.6.20\",\n    \"VersionPHP\": \"8.2.27\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20250201_templatewebsite\",\n    \"hash\": \"f98a615d59c6e29b4392_20250201002652\",\n    \"execType\": 1,\n    \"notes\": \"Created by schedule Monthly\",\n    \"StorePath\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/template.strng.us\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250201_templatewebsite_f98a615d59c6e29b4392_20250201002652_scan.json\",\n    \"timer_start\": 1738369615.712421894073486328125,\n    \"Runtime\": \"51.050 sec.\",\n    \"ExeSize\": \"128.66KB\",\n    \"ZipSize\": \"124.39MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/satbiz5\\/_backup\\/_template\",\n            \"\\/home\\/satbiz5\\/_template\\/.opcache\",\n            \"\\/home\\/satbiz5\\/_template\\/.tmb\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/bps-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/old-cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/updraft\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wfcache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/satbiz5\\/_template\\/.htaccess\",\n            \"\\/home\\/satbiz5\\/_template\\/.user.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/php.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/web.config\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-config.php\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250201_templatewebsite_f98a615d59c6e29b4392_20250201002652_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/satbiz5\\/_template\",\n        \"Size\": 130428260,\n        \"Dirs\": [],\n        \"DirCount\": 3481,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 16517,\n        \"file_count\": 19997,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250201_templatewebsite_f98a615d59c6e29b4392_20250201002652_installer.php\",\n        \"Size\": 131751,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"UaCVF02mQDde7eT9ppwK55vH\\/TfLyYI+K1nxxsEVxBzzFMS1\\/x2nQ50+fu4Wx8m4MJpRKqfhmm7iYu6eRGVvzA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb3_unicode_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MyISAM\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": true,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"satbiz5_template\",\n            \"tablesBaseCount\": 62,\n            \"tablesFinalCount\": 62,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 36444,\n            \"tablesSizeOnDisk\": 22734212,\n            \"tablesList\": {\n                \"znE_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 89,\n                    \"size\": 196608\n                },\n                \"znE_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"260\",\n                    \"insertedRows\": 260,\n                    \"size\": 81920\n                },\n                \"znE_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_duplicator_backups\": {\n                    \"inaccurateRows\": \"18\",\n                    \"insertedRows\": 18,\n                    \"size\": 383464\n                },\n                \"znE_duplicator_entities\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 12,\n                    \"size\": 47456\n                },\n                \"znE_evf_entries\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_entrymeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_options\": {\n                    \"inaccurateRows\": \"604\",\n                    \"insertedRows\": 605,\n                    \"size\": 2670064\n                },\n                \"znE_postmeta\": {\n                    \"inaccurateRows\": \"558\",\n                    \"insertedRows\": 558,\n                    \"size\": 652520\n                },\n                \"znE_posts\": {\n                    \"inaccurateRows\": \"57\",\n                    \"insertedRows\": 57,\n                    \"size\": 46756\n                },\n                \"znE_shortpixel_folders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_postmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_termmeta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 9440\n                },\n                \"znE_terms\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 11700\n                },\n                \"znE_term_relationships\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 21,\n                    \"size\": 3513\n                },\n                \"znE_term_taxonomy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 4740\n                },\n                \"znE_tm_taskmeta\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 36,\n                    \"size\": 49152\n                },\n                \"znE_tm_tasks\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 36,\n                    \"size\": 32768\n                },\n                \"znE_usermeta\": {\n                    \"inaccurateRows\": \"59\",\n                    \"insertedRows\": 59,\n                    \"size\": 17704\n                },\n                \"znE_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 7288\n                },\n                \"znE_wfauditevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfblockediplog\": {\n                    \"inaccurateRows\": \"27\",\n                    \"insertedRows\": 21,\n                    \"size\": 16384\n                },\n                \"znE_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"znE_wfconfig\": {\n                    \"inaccurateRows\": \"279\",\n                    \"insertedRows\": 282,\n                    \"size\": 2473984\n                },\n                \"znE_wfcrawlers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"znE_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wffilemods\": {\n                    \"inaccurateRows\": \"16362\",\n                    \"insertedRows\": 16627,\n                    \"size\": 8929280\n                },\n                \"znE_wfhits\": {\n                    \"inaccurateRows\": \"414\",\n                    \"insertedRows\": 446,\n                    \"size\": 1228800\n                },\n                \"znE_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"znE_wfknownfilelist\": {\n                    \"inaccurateRows\": \"16470\",\n                    \"insertedRows\": 16628,\n                    \"size\": 4734976\n                },\n                \"znE_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wflogins\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"znE_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"znE_wfls_settings\": {\n                    \"inaccurateRows\": \"29\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"znE_wfnotifications\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 81,\n                    \"size\": 16384\n                },\n                \"znE_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"znE_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfsnipcache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"znE_wfstatus\": {\n                    \"inaccurateRows\": \"946\",\n                    \"insertedRows\": 943,\n                    \"size\": 311296\n                },\n                \"znE_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wpforms_payments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"znE_wpforms_payment_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_wpforms_tasks_meta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"znE_wpo_404_detector\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"znE_yoast_indexable\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 16740\n                },\n                \"znE_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 5414\n                },\n                \"znE_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 8672\n                },\n                \"znE_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_yoast_seo_links\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 39,\n                    \"size\": 7876\n                },\n                \"znE_yoast_seo_meta\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 2337\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.6.20\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 13287329,\n        \"File\": \"20250201_templatewebsite_f98a615d59c6e29b4392_20250201002652_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\\/20250201_templatewebsite_f98a615d59c6e29b4392_20250201002652_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 100,\n    \"schedule_id\": 11,\n    \"descriptorsMng\": {\n        \"hash\": \"f98a615-01002652\",\n        \"date\": \"20250201002652\",\n        \"mapping\": {\n            \"orig_files\": \"orig_files\",\n            \"archive_config\": \"archive.txt\",\n            \"scan\": \"scan.json\",\n            \"file_list\": \"scanned-files.txt\",\n            \"dir_list\": \"scanned-dirs.txt\",\n            \"manual_extract\": \"manual-extract\",\n            \"db_dump\": \"db_dumps\\/20250201002652-dump.sql\",\n            \"inst_chunk_data\": \"installer-chunk-data.json\",\n            \"inst_notices\": \"installer-notices.json\",\n            \"inst_db_data\": \"installer-db-data.json\",\n            \"inst_db_seek_log\": \"installer-db-seek-tell-log.txt\",\n            \"inst_extraction_data\": \"installer-extraction.json\",\n            \"inst_s3_data\": \"installer-s3data.json\",\n            \"inst_php_error_log\": \"php_error.log\",\n            \"params\": \"params.json\"\n        }\n    },\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 0,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2025-02-01 00:26:52\",\n    \"updated\": \"2025-12-15 12:26:59\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 0,\n    \"mainActivityLogId\": 0\n}","20250201_templatewebsite_f98a615d59c6e29b4392_20250201002652_archive.zip","100","SCHEDULE,ZIP_ARCHIVE","4.5.24.2","2025-12-15 12:26:59","Standard"),
("95","20251201_templatewebsite","2332235a50743cb67272_20251201011728","100","2025-12-01 01:17:28","","{\n    \"ID\": 95,\n    \"VersionWP\": \"6.8.3\",\n    \"VersionDB\": \"10.6.24\",\n    \"VersionPHP\": \"8.2.29\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20251201_templatewebsite\",\n    \"hash\": \"2332235a50743cb67272_20251201011728\",\n    \"execType\": 1,\n    \"notes\": \"Created by schedule Monthly\",\n    \"StorePath\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/template.strng.us\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20251201_templatewebsite_2332235a50743cb67272_20251201011728_scan.json\",\n    \"timer_start\": 1764551854.2721059322357177734375,\n    \"Runtime\": \"61.395 sec.\",\n    \"ExeSize\": \"127.68KB\",\n    \"ZipSize\": \"133.06MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/satbiz5\\/_backup\\/_template\",\n            \"\\/home\\/satbiz5\\/_template\\/.opcache\",\n            \"\\/home\\/satbiz5\\/_template\\/.tmb\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/bps-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/old-cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/updraft\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wfcache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/satbiz5\\/_template\\/.htaccess\",\n            \"\\/home\\/satbiz5\\/_template\\/.user.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/php.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/web.config\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-config.php\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20251201_templatewebsite_2332235a50743cb67272_20251201011728_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/satbiz5\\/_template\\/\",\n        \"Size\": 139523738,\n        \"Dirs\": [],\n        \"DirCount\": 3616,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 17059,\n        \"file_count\": 20675,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20251201_templatewebsite_2332235a50743cb67272_20251201011728_installer.php\",\n        \"Size\": 130749,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"FoZVZXc4XftD0Snz4F+KErjIGFerIb5lrsWsGPq6Fnc\\/YydU52i3KkOb5Qvx4itgsXRfZxEimqjzb9vHktOlEw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb3_unicode_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MyISAM\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": true,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"satbiz5_template\",\n            \"tablesBaseCount\": 63,\n            \"tablesFinalCount\": 63,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 36623,\n            \"tablesSizeOnDisk\": 23548528,\n            \"tablesList\": {\n                \"znE_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"31\",\n                    \"insertedRows\": 32,\n                    \"size\": 229376\n                },\n                \"znE_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"88\",\n                    \"insertedRows\": 94,\n                    \"size\": 49152\n                },\n                \"znE_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"32\",\n                    \"insertedRows\": 37,\n                    \"size\": 147456\n                },\n                \"znE_duplicator_backups\": {\n                    \"inaccurateRows\": \"20\",\n                    \"insertedRows\": 20,\n                    \"size\": 491876\n                },\n                \"znE_duplicator_entities\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 12,\n                    \"size\": 47456\n                },\n                \"znE_evf_entries\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_entrymeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_options\": {\n                    \"inaccurateRows\": \"621\",\n                    \"insertedRows\": 622,\n                    \"size\": 3362240\n                },\n                \"znE_postmeta\": {\n                    \"inaccurateRows\": \"557\",\n                    \"insertedRows\": 557,\n                    \"size\": 711572\n                },\n                \"znE_posts\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 56,\n                    \"size\": 48924\n                },\n                \"znE_shortpixel_folders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_postmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_termmeta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 9440\n                },\n                \"znE_terms\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 11700\n                },\n                \"znE_term_relationships\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 21,\n                    \"size\": 3513\n                },\n                \"znE_term_taxonomy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 4740\n                },\n                \"znE_tm_taskmeta\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 58,\n                    \"size\": 81920\n                },\n                \"znE_tm_tasks\": {\n                    \"inaccurateRows\": \"47\",\n                    \"insertedRows\": 58,\n                    \"size\": 32768\n                },\n                \"znE_usermeta\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 19336\n                },\n                \"znE_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 7316\n                },\n                \"znE_wfauditevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfblockediplog\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 18,\n                    \"size\": 16384\n                },\n                \"znE_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"znE_wfconfig\": {\n                    \"inaccurateRows\": \"284\",\n                    \"insertedRows\": 286,\n                    \"size\": 2408448\n                },\n                \"znE_wfcrawlers\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wffilemods\": {\n                    \"inaccurateRows\": \"16596\",\n                    \"insertedRows\": 17204,\n                    \"size\": 8929280\n                },\n                \"znE_wfhits\": {\n                    \"inaccurateRows\": \"103\",\n                    \"insertedRows\": 30,\n                    \"size\": 1114112\n                },\n                \"znE_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"znE_wfknownfilelist\": {\n                    \"inaccurateRows\": \"16801\",\n                    \"insertedRows\": 17205,\n                    \"size\": 4734976\n                },\n                \"znE_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wflogins\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"znE_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"znE_wfls_settings\": {\n                    \"inaccurateRows\": \"29\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"znE_wfnotifications\": {\n                    \"inaccurateRows\": \"85\",\n                    \"insertedRows\": 261,\n                    \"size\": 16384\n                },\n                \"znE_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"znE_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"znE_wfstatus\": {\n                    \"inaccurateRows\": \"949\",\n                    \"insertedRows\": 949,\n                    \"size\": 262144\n                },\n                \"znE_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wpforms_payments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"znE_wpforms_payment_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_wpforms_tasks_meta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"znE_wpo_404_detector\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"znE_yoast_indexable\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 16740\n                },\n                \"znE_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 5414\n                },\n                \"znE_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 8672\n                },\n                \"znE_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_yoast_seo_links\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 39,\n                    \"size\": 7876\n                },\n                \"znE_yoast_seo_meta\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 2337\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.6.24\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 13443923,\n        \"File\": \"20251201_templatewebsite_2332235a50743cb67272_20251201011728_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\\/20251201_templatewebsite_2332235a50743cb67272_20251201011728_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 100,\n    \"schedule_id\": 11,\n    \"descriptorsMng\": {\n        \"hash\": \"2332235-01011728\",\n        \"date\": \"20251201011728\",\n        \"mapping\": {\n            \"orig_files\": \"orig_files\",\n            \"archive_config\": \"archive.txt\",\n            \"scan\": \"scan.json\",\n            \"file_list\": \"scanned-files.txt\",\n            \"dir_list\": \"scanned-dirs.txt\",\n            \"file_index\": \"index.txt\",\n            \"manual_extract\": \"manual-extract\",\n            \"db_dump\": \"db_dumps\\/20251201011728-dump.sql\",\n            \"inst_chunk_data\": \"installer-chunk-data.json\",\n            \"inst_notices\": \"installer-notices.json\",\n            \"inst_db_data\": \"installer-db-data.json\",\n            \"inst_db_seek_log\": \"installer-db-seek-tell-log.txt\",\n            \"inst_extraction_data\": \"installer-extraction.json\",\n            \"inst_s3_data\": \"installer-s3data.json\",\n            \"inst_php_error_log\": \"php_error.log\",\n            \"params\": \"params.json\"\n        }\n    },\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 0,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2025-12-01 01:17:28\",\n    \"updated\": \"2025-12-15 12:26:59\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 34,\n    \"mainActivityLogId\": 36\n}","20251201_templatewebsite_2332235a50743cb67272_20251201011728_archive.zip","0","SCHEDULE,ZIP_ARCHIVE","4.5.24.2","2025-12-15 12:26:59","Standard");

INSERT IGNORE INTO `znE_duplicator_backups` VALUES 
("96","20251201_templatewebsite","11ac5eab1fa7323b6183_20251201062837","100","2025-12-01 06:28:37","","{\n    \"ID\": 96,\n    \"VersionWP\": \"6.8.3\",\n    \"VersionDB\": \"10.6.24\",\n    \"VersionPHP\": \"8.2.29\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20251201_templatewebsite\",\n    \"hash\": \"11ac5eab1fa7323b6183_20251201062837\",\n    \"execType\": 2,\n    \"notes\": \"Created by schedule Monthly\",\n    \"StorePath\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/template.strng.us\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20251201_templatewebsite_11ac5eab1fa7323b6183_20251201062837_scan.json\",\n    \"timer_start\": 1764570709.420855045318603515625,\n    \"Runtime\": \"61.259 sec.\",\n    \"ExeSize\": \"127.68KB\",\n    \"ZipSize\": \"133.06MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/satbiz5\\/_backup\\/_template\",\n            \"\\/home\\/satbiz5\\/_template\\/.opcache\",\n            \"\\/home\\/satbiz5\\/_template\\/.tmb\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/bps-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/old-cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/updraft\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wfcache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/satbiz5\\/_template\\/.htaccess\",\n            \"\\/home\\/satbiz5\\/_template\\/.user.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/php.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/web.config\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-config.php\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20251201_templatewebsite_11ac5eab1fa7323b6183_20251201062837_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/satbiz5\\/_template\\/\",\n        \"Size\": 139523168,\n        \"Dirs\": [],\n        \"DirCount\": 3616,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 17059,\n        \"file_count\": 20675,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20251201_templatewebsite_11ac5eab1fa7323b6183_20251201062837_installer.php\",\n        \"Size\": 130749,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"hAwsx9KS0Q1Gvy9sYFtlaZLyDRhiyIarMENNJVTipE5WyLDfAyviJGsGtVL\\/nIGdnB28nbQdJibiJxMnSet6NA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb3_unicode_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MyISAM\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": true,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"satbiz5_template\",\n            \"tablesBaseCount\": 63,\n            \"tablesFinalCount\": 63,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 36643,\n            \"tablesSizeOnDisk\": 23565372,\n            \"tablesList\": {\n                \"znE_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"31\",\n                    \"insertedRows\": 31,\n                    \"size\": 229376\n                },\n                \"znE_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"88\",\n                    \"insertedRows\": 91,\n                    \"size\": 49152\n                },\n                \"znE_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"40\",\n                    \"insertedRows\": 45,\n                    \"size\": 163840\n                },\n                \"znE_duplicator_backups\": {\n                    \"inaccurateRows\": \"20\",\n                    \"insertedRows\": 20,\n                    \"size\": 491876\n                },\n                \"znE_duplicator_entities\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 47456\n                },\n                \"znE_evf_entries\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_entrymeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_options\": {\n                    \"inaccurateRows\": \"629\",\n                    \"insertedRows\": 629,\n                    \"size\": 3362240\n                },\n                \"znE_postmeta\": {\n                    \"inaccurateRows\": \"554\",\n                    \"insertedRows\": 554,\n                    \"size\": 711572\n                },\n                \"znE_posts\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 58,\n                    \"size\": 49384\n                },\n                \"znE_shortpixel_folders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_postmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_termmeta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 9440\n                },\n                \"znE_terms\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 11700\n                },\n                \"znE_term_relationships\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 21,\n                    \"size\": 3513\n                },\n                \"znE_term_taxonomy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 4740\n                },\n                \"znE_tm_taskmeta\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 58,\n                    \"size\": 81920\n                },\n                \"znE_tm_tasks\": {\n                    \"inaccurateRows\": \"47\",\n                    \"insertedRows\": 58,\n                    \"size\": 32768\n                },\n                \"znE_usermeta\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 60,\n                    \"size\": 19336\n                },\n                \"znE_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 7316\n                },\n                \"znE_wfauditevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfblockediplog\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 18,\n                    \"size\": 16384\n                },\n                \"znE_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"znE_wfconfig\": {\n                    \"inaccurateRows\": \"284\",\n                    \"insertedRows\": 286,\n                    \"size\": 2408448\n                },\n                \"znE_wfcrawlers\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wffilemods\": {\n                    \"inaccurateRows\": \"16596\",\n                    \"insertedRows\": 17204,\n                    \"size\": 8929280\n                },\n                \"znE_wfhits\": {\n                    \"inaccurateRows\": \"104\",\n                    \"insertedRows\": 31,\n                    \"size\": 1114112\n                },\n                \"znE_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"znE_wfknownfilelist\": {\n                    \"inaccurateRows\": \"16801\",\n                    \"insertedRows\": 17205,\n                    \"size\": 4734976\n                },\n                \"znE_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wflocs\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"znE_wflogins\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 7,\n                    \"size\": 49152\n                },\n                \"znE_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"znE_wfls_settings\": {\n                    \"inaccurateRows\": \"29\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"znE_wfnotifications\": {\n                    \"inaccurateRows\": \"85\",\n                    \"insertedRows\": 261,\n                    \"size\": 16384\n                },\n                \"znE_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"znE_wfreversecache\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"znE_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"znE_wfstatus\": {\n                    \"inaccurateRows\": \"949\",\n                    \"insertedRows\": 949,\n                    \"size\": 262144\n                },\n                \"znE_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wpforms_payments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"znE_wpforms_payment_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_wpforms_tasks_meta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"znE_wpo_404_detector\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"znE_yoast_indexable\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 16740\n                },\n                \"znE_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 5414\n                },\n                \"znE_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 8672\n                },\n                \"znE_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_yoast_seo_links\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 39,\n                    \"size\": 7876\n                },\n                \"znE_yoast_seo_meta\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 17,\n                    \"size\": 2337\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.6.24\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 13428263,\n        \"File\": \"20251201_templatewebsite_11ac5eab1fa7323b6183_20251201062837_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\\/20251201_templatewebsite_11ac5eab1fa7323b6183_20251201062837_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 100,\n    \"schedule_id\": 11,\n    \"descriptorsMng\": {\n        \"hash\": \"11ac5ea-01062837\",\n        \"date\": \"20251201062837\",\n        \"mapping\": {\n            \"orig_files\": \"orig_files\",\n            \"archive_config\": \"archive.txt\",\n            \"scan\": \"scan.json\",\n            \"file_list\": \"scanned-files.txt\",\n            \"dir_list\": \"scanned-dirs.txt\",\n            \"file_index\": \"index.txt\",\n            \"manual_extract\": \"manual-extract\",\n            \"db_dump\": \"db_dumps\\/20251201062837-dump.sql\",\n            \"inst_chunk_data\": \"installer-chunk-data.json\",\n            \"inst_notices\": \"installer-notices.json\",\n            \"inst_db_data\": \"installer-db-data.json\",\n            \"inst_db_seek_log\": \"installer-db-seek-tell-log.txt\",\n            \"inst_extraction_data\": \"installer-extraction.json\",\n            \"inst_s3_data\": \"installer-s3data.json\",\n            \"inst_php_error_log\": \"php_error.log\",\n            \"params\": \"params.json\"\n        }\n    },\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 0,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 1764570740,\n            \"chunkPosition\": [],\n            \"isProcessing\": false,\n            \"storage\": null,\n            \"packageExists\": false,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": [],\n            \"generalExtraData\": []\n        },\n        {\n            \"storage_id\": 16,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 66.085327918156423265827470459043979644775390625,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1764570584,\n            \"stopped_timestamp\": 1764570652,\n            \"chunkPosition\": [],\n            \"isProcessing\": false,\n            \"storage\": null,\n            \"packageExists\": false,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": [],\n            \"generalExtraData\": []\n        },\n        {\n            \"storage_id\": 16,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1764570726,\n            \"stopped_timestamp\": 1764570739,\n            \"chunkPosition\": [],\n            \"isProcessing\": false,\n            \"storage\": null,\n            \"packageExists\": false,\n            \"isDownloadFromRemote\": true,\n            \"copyExtraData\": [],\n            \"generalExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 16,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2025-12-01 06:28:37\",\n    \"updated\": \"2025-12-15 07:29:36\",\n    \"flags\": [\n        \"SCHEDULE_RUN_NOW\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 42,\n    \"mainActivityLogId\": 44\n}","20251201_templatewebsite_11ac5eab1fa7323b6183_20251201062837_archive.zip","0","SCHEDULE_RUN_NOW,ZIP_ARCHIVE","4.5.24.2","2025-12-15 07:29:36","Standard"),
("97","20251219_templatewebsite","b8ef4feccbfa49d43620_20251219082150","20","2025-12-19 08:21:50","","{\n    \"ID\": 97,\n    \"VersionWP\": \"6.9\",\n    \"VersionDB\": \"10.6.24\",\n    \"VersionPHP\": \"8.2.29\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20251219_templatewebsite\",\n    \"hash\": \"b8ef4feccbfa49d43620_20251219082150\",\n    \"execType\": 2,\n    \"notes\": \"Created by schedule Monthly\",\n    \"StorePath\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/template.strng.us\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20251219_templatewebsite_b8ef4feccbfa49d43620_20251219082150_scan.json\",\n    \"timer_start\": 1766132514.4693310260772705078125,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/satbiz5\\/_template\\/.opcache\",\n            \"\\/home\\/satbiz5\\/_template\\/.tmb\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/bps-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/old-cache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/updraft\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wfcache\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/satbiz5\\/_template\\/.htaccess\",\n            \"\\/home\\/satbiz5\\/_template\\/.user.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/php.ini\",\n            \"\\/home\\/satbiz5\\/_template\\/web.config\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-config.php\",\n            \"\\/home\\/satbiz5\\/_template\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20251219_templatewebsite_b8ef4feccbfa49d43620_20251219082150_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/satbiz5\\/_template\\/\",\n        \"Size\": 372350156,\n        \"Dirs\": [],\n        \"DirCount\": 3552,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 16746,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 236217538,\n                        \"bytes\": \"225.27MB\",\n                        \"nodes\": 15263,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 310880084,\n                        \"bytes\": \"296.48MB\",\n                        \"nodes\": 17071,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/home\\/satbiz5\\/_template\\/wp-snapshots\",\n                    \"\\/home\\/satbiz5\\/_template\\/.opcache\",\n                    \"\\/home\\/satbiz5\\/_template\\/.tmb\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-lite\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/ai1wm-backups\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backupwordpress\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/content\\/cache\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/contents\\/cache\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/managewp\\/backups\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/old-cache\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/updraft\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wpvividbackups\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wishlist-backup\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/wfcache\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/bps-backup\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/cache\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 9705065,\n                        \"bytes\": \"9.26MB\",\n                        \"nodes\": 1,\n                        \"name\": \"geoip.mmdb\",\n                        \"dir\": \"wp-content\\/plugins\\/wordfence\\/lib\",\n                        \"path\": \"wp-content\\/plugins\\/wordfence\\/lib\\/geoip.mmdb\"\n                    },\n                    {\n                        \"ubytes\": 4784755,\n                        \"bytes\": \"4.56MB\",\n                        \"nodes\": 1,\n                        \"name\": \"ast-block-templates-blocks-2.json\",\n                        \"dir\": \"wp-content\\/uploads\\/ast-block-templates-json\",\n                        \"path\": \"wp-content\\/uploads\\/ast-block-templates-json\\/ast-block-templates-blocks-2.json\"\n                    },\n                    {\n                        \"ubytes\": 9705065,\n                        \"bytes\": \"9.26MB\",\n                        \"nodes\": 1,\n                        \"name\": \"geoip.mmdb\",\n                        \"dir\": \"wp-content\\/wflogs\",\n                        \"path\": \"wp-content\\/wflogs\\/geoip.mmdb\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/home\\/satbiz5\\/_template\\/.htaccess\",\n                    \"\\/home\\/satbiz5\\/_template\\/.user.ini\",\n                    \"\\/home\\/satbiz5\\/_template\\/php.ini\",\n                    \"\\/home\\/satbiz5\\/_template\\/web.config\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-content\\/debug.log\",\n                    \"\\/home\\/satbiz5\\/_template\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"treeList\": []\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20251219_templatewebsite_b8ef4feccbfa49d43620_20251219082150_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": null,\n        \"passowrd\": \"K6HdB7dXnjDpwOIGPr8z5W14shK0m52K7oeze19FuAz6w0F9NRNDTIbUbmrQ6eKqCQ\\/D7YVrEnNoa13pEqPnGA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": null,\n        \"OptsDBHost\": null,\n        \"OptsDBName\": null,\n        \"OptsDBUser\": null,\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb3_unicode_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MyISAM\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": true,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"satbiz5_template\",\n            \"tablesBaseCount\": 63,\n            \"tablesFinalCount\": 63,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 38841,\n            \"tablesSizeOnDisk\": 21832704,\n            \"tablesList\": {\n                \"znE_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"32\",\n                    \"insertedRows\": 0,\n                    \"size\": 229376\n                },\n                \"znE_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"88\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"znE_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"54\",\n                    \"insertedRows\": 0,\n                    \"size\": 180224\n                },\n                \"znE_duplicator_backups\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 0,\n                    \"size\": 491876\n                },\n                \"znE_duplicator_entities\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 0,\n                    \"size\": 47456\n                },\n                \"znE_evf_entries\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_entrymeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_evf_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_options\": {\n                    \"inaccurateRows\": \"629\",\n                    \"insertedRows\": 0,\n                    \"size\": 3362240\n                },\n                \"znE_postmeta\": {\n                    \"inaccurateRows\": \"550\",\n                    \"insertedRows\": 0,\n                    \"size\": 714452\n                },\n                \"znE_posts\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 0,\n                    \"size\": 50540\n                },\n                \"znE_shortpixel_folders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_shortpixel_postmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_termmeta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 9440\n                },\n                \"znE_terms\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 0,\n                    \"size\": 11700\n                },\n                \"znE_term_relationships\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 0,\n                    \"size\": 3513\n                },\n                \"znE_term_taxonomy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 0,\n                    \"size\": 4740\n                },\n                \"znE_tm_taskmeta\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"znE_tm_tasks\": {\n                    \"inaccurateRows\": \"47\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_usermeta\": {\n                    \"inaccurateRows\": \"60\",\n                    \"insertedRows\": 0,\n                    \"size\": 19336\n                },\n                \"znE_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 7316\n                },\n                \"znE_wfauditevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfblockediplog\": {\n                    \"inaccurateRows\": \"20\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"znE_wfconfig\": {\n                    \"inaccurateRows\": \"284\",\n                    \"insertedRows\": 0,\n                    \"size\": 1359872\n                },\n                \"znE_wfcrawlers\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wffilemods\": {\n                    \"inaccurateRows\": \"17525\",\n                    \"insertedRows\": 0,\n                    \"size\": 8929280\n                },\n                \"znE_wfhits\": {\n                    \"inaccurateRows\": \"507\",\n                    \"insertedRows\": 0,\n                    \"size\": 344064\n                },\n                \"znE_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfissues\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"znE_wfknownfilelist\": {\n                    \"inaccurateRows\": \"17362\",\n                    \"insertedRows\": 0,\n                    \"size\": 4734976\n                },\n                \"znE_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wflocs\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wflogins\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"znE_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"znE_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"znE_wfls_settings\": {\n                    \"inaccurateRows\": \"29\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfnotifications\": {\n                    \"inaccurateRows\": \"86\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"znE_wfreversecache\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"znE_wfstatus\": {\n                    \"inaccurateRows\": \"1240\",\n                    \"insertedRows\": 0,\n                    \"size\": 327680\n                },\n                \"znE_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wpforms_payments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"znE_wpforms_payment_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"znE_wpforms_tasks_meta\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"znE_wpo_404_detector\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"znE_yoast_indexable\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 0,\n                    \"size\": 16740\n                },\n                \"znE_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 0,\n                    \"size\": 5414\n                },\n                \"znE_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 0,\n                    \"size\": 8672\n                },\n                \"znE_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"znE_yoast_seo_links\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 0,\n                    \"size\": 7876\n                },\n                \"znE_yoast_seo_meta\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 0,\n                    \"size\": 2337\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.6.24\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20251219_templatewebsite_b8ef4feccbfa49d43620_20251219082150_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/satbiz5\\/_template\\/wp-content\\/backups-dup-pro\\/tmp\\/20251219_templatewebsite_b8ef4feccbfa49d43620_20251219082150_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 20,\n    \"schedule_id\": 11,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 1766132517,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 372350156,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"znE_users\",\n            \"znE_usermeta\",\n            \"znE_actionscheduler_actions\",\n            \"znE_actionscheduler_claims\",\n            \"znE_actionscheduler_groups\",\n            \"znE_actionscheduler_logs\",\n            \"znE_commentmeta\",\n            \"znE_comments\",\n            \"znE_duplicator_activity_logs\",\n            \"znE_duplicator_backups\",\n            \"znE_duplicator_entities\",\n            \"znE_evf_entries\",\n            \"znE_evf_entrymeta\",\n            \"znE_evf_sessions\",\n            \"znE_e_events\",\n            \"znE_links\",\n            \"znE_options\",\n            \"znE_postmeta\",\n            \"znE_posts\",\n            \"znE_shortpixel_folders\",\n            \"znE_shortpixel_meta\",\n            \"znE_shortpixel_postmeta\",\n            \"znE_termmeta\",\n            \"znE_terms\",\n            \"znE_term_relationships\",\n            \"znE_term_taxonomy\",\n            \"znE_tm_taskmeta\",\n            \"znE_tm_tasks\",\n            \"znE_wfauditevents\",\n            \"znE_wfblockediplog\",\n            \"znE_wfblocks7\",\n            \"znE_wfconfig\",\n            \"znE_wfcrawlers\",\n            \"znE_wffilechanges\",\n            \"znE_wffilemods\",\n            \"znE_wfhits\",\n            \"znE_wfhoover\",\n            \"znE_wfissues\",\n            \"znE_wfknownfilelist\",\n            \"znE_wflivetraffichuman\",\n            \"znE_wflocs\",\n            \"znE_wflogins\",\n            \"znE_wfls_2fa_secrets\",\n            \"znE_wfls_role_counts\",\n            \"znE_wfls_settings\",\n            \"znE_wfnotifications\",\n            \"znE_wfpendingissues\",\n            \"znE_wfreversecache\",\n            \"znE_wfsecurityevents\",\n            \"znE_wfsnipcache\",\n            \"znE_wfstatus\",\n            \"znE_wftrafficrates\",\n            \"znE_wfwaffailures\",\n            \"znE_wpforms_payments\",\n            \"znE_wpforms_payment_meta\",\n            \"znE_wpforms_tasks_meta\",\n            \"znE_wpo_404_detector\",\n            \"znE_yoast_indexable\",\n            \"znE_yoast_indexable_hierarchy\",\n            \"znE_yoast_migrations\",\n            \"znE_yoast_primary_term\",\n            \"znE_yoast_seo_links\",\n            \"znE_yoast_seo_meta\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1766132515.1322209835052490234375,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 38844,\n            \"tables\": {\n                \"znE_users\": {\n                    \"start\": \"1\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_actionscheduler_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_actionscheduler_claims\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_actionscheduler_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_actionscheduler_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_duplicator_activity_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_duplicator_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_duplicator_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_evf_entries\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_evf_entrymeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_evf_sessions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_e_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_shortpixel_folders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_shortpixel_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_shortpixel_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_tm_taskmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_tm_tasks\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wfauditevents\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wfblockediplog\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wfblocks7\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wfconfig\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wfcrawlers\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wffilechanges\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wffilemods\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wfhits\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wfhoover\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wfissues\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wfknownfilelist\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wflivetraffichuman\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wflocs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wflogins\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wfls_2fa_secrets\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wfls_role_counts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wfls_settings\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wfnotifications\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wfpendingissues\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wfreversecache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wfsecurityevents\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wfsnipcache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wfstatus\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wftrafficrates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wfwaffailures\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wpforms_payments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wpforms_payment_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wpforms_tasks_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_wpo_404_detector\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_yoast_indexable\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_yoast_indexable_hierarchy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_yoast_migrations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_yoast_primary_term\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_yoast_seo_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"znE_yoast_seo_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 16,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"isProcessing\": false,\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": [],\n            \"generalExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2025-12-19 08:21:50\",\n    \"updated\": \"2025-12-19 08:21:57\",\n    \"flags\": [\n        \"SCHEDULE_RUN_NOW\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 54,\n    \"mainActivityLogId\": 56\n}","20251219_templatewebsite_b8ef4feccbfa49d43620_20251219082150_archive.zip","0","SCHEDULE_RUN_NOW,ZIP_ARCHIVE","4.5.24.3","2025-12-19 08:21:57","Standard");

INSERT IGNORE INTO `znE_duplicator_entities` VALUES 
("1","DUP_PRO_Global_Entity","{\n    \"email_summary_frequency\": \"never\",\n    \"email_summary_recipients\": [\n        \"stronganchortech@gmail.com\"\n    ],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 2,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": null,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 6,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"max_package_transfer_time_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 18,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"ajax_protocol\": \"https\",\n    \"custom_ajax_url\": \"http:\\/\\/template.strng.us\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"installer_name_mode\": \"withhash\",\n    \"installer_base_name\": \"installer.php\",\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"purgeBackupRecords\": 0,\n    \"manual_mode_storage_ids\": [\n        13\n    ],\n    \"license_key_visible\": 0,\n    \"last_system_check_timestamp\": 1683805931,\n    \"initial_activation_timestamp\": 1586094794,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 1,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2023-11-08 23:48:30\",\n    \"updated\": \"2025-12-19 08:13:32\"\n}","","","","","","4.5.24.3","2023-11-08 23:48:30","2025-12-19 08:13:32"),
("2","DUP_PRO_Secure_Global_Entity","{\n    \"basic_auth_password\": \"\",\n    \"lkp\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 2,\n    \"version\": \"4.5.22.3\",\n    \"created\": \"2023-11-08 23:48:30\",\n    \"updated\": \"2025-07-31 09:12:04\"\n}","","","","","","4.5.22.3","2023-11-08 23:48:30","2025-07-31 09:12:04"),
("3","DUP_PRO_System_Global_Entity","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1766132510,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 3,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2023-11-08 23:48:30\",\n    \"updated\": \"2025-12-19 08:21:50\"\n}","","","","","","4.5.24.3","2023-11-08 23:48:30","2025-12-19 08:21:50"),
("4","DUP_PRO_Package_Template_Entity","{\n    \"name\": \"Default\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": [],\n    \"installer_opts_secure_on\": null,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"HyGawgluK6EbfLnZuFwhn49T\\/WmisUnUXubdw\\/q0hVTqDXRbNXZXw7JKLHMy1ptDoKDYJAZJk4bkUE\\/SKwBUtw==\",\n    \"installer_opts_skip_scan\": null,\n    \"installer_opts_db_host\": null,\n    \"installer_opts_db_name\": null,\n    \"installer_opts_db_user\": null,\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"id\": 4\n}","","","","","","","2023-11-08 23:48:30","2023-11-08 23:48:30"),
("5","DUP_PRO_Package_Template_Entity","{\n    \"name\": \"[Manual Mode]\",\n    \"notes\": \"\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": [],\n    \"installer_opts_secure_on\": null,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"Xv8MlshUGDRld3CXjhhs2sW3ycr925JIuyRC08OkJ4xUT3BQb8RPlZKYZXz0nWH4q4lD4rAEip4RaisGb4CxgA==\",\n    \"installer_opts_skip_scan\": null,\n    \"installer_opts_db_host\": null,\n    \"installer_opts_db_name\": null,\n    \"installer_opts_db_user\": null,\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"id\": 5\n}","","","","","","","2023-11-08 23:48:30","2023-11-08 23:48:30"),
("8","DUP_PRO_Package_Template_Entity","{\n    \"name\": \"Migrate\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": [],\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"nr5dz3hfF7YlFHHXjsCQm51yaBnC0TxgqZ6BA3KZ8t\\/oJi\\/gJMwv1yA0ODK5432t\\/xqKlmCV0AxwD6K3dIL4QQ==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": \"on\",\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"turkisk9_startereng\",\n    \"installer_opts_cpnl_db_user\": \"turkisk9_startereng\",\n    \"installer_opts_brand\": \"-2\",\n    \"is_default\": false,\n    \"is_manual\": false,\n    \"id\": 8\n}","","","","","","","2023-11-08 23:48:30","2023-11-08 23:48:30"),
("11","DUP_PRO_Schedule_Entity","{\n    \"name\": \"Monthly\",\n    \"template_id\": 4,\n    \"start_ticks\": 1420077600,\n    \"repeat_type\": 2,\n    \"active\": true,\n    \"next_run_time\": 1767232800,\n    \"run_every\": 1,\n    \"weekly_days\": 0,\n    \"day_of_month\": 1,\n    \"cron_string\": \"0 2 1 * *\",\n    \"last_run_time\": 1764570740,\n    \"last_run_status\": 0,\n    \"times_run\": 83,\n    \"storage_ids\": [\n        16\n    ],\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 11,\n    \"version\": \"4.5.24.1\",\n    \"created\": \"2023-11-08 23:48:30\",\n    \"updated\": \"2025-12-01 06:32:20\"\n}","","","","","","4.5.24.1","2023-11-08 23:48:30","2025-12-01 06:32:20"),
("12","EmailSummary","{\n    \"manualPackageIds\": [],\n    \"scheduledPackageIds\": {\n        \"11\": [\n            91,\n            92,\n            93,\n            94,\n            95,\n            96\n        ]\n    },\n    \"failedPackageIds\": [],\n    \"failedUploads\": [],\n    \"cancelledUploads\": [],\n    \"successfulUploads\": {\n        \"10\": 5,\n        \"16\": 1\n    },\n    \"scheduleIds\": [],\n    \"storageIds\": [\n        16\n    ],\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 12,\n    \"version\": \"4.5.24.1\",\n    \"created\": \"0000-00-00 00:00:00\",\n    \"updated\": \"2025-12-01 06:36:48\"\n}","","","","","","4.5.24.1","0000-00-00 00:00:00","2025-12-01 06:36:48"),
("13","DUP_PRO_Storage_Entity","{\n    \"name\": \"Default\",\n    \"notes\": \"The default location for storage on this server.\",\n    \"storage_type\": -2,\n    \"config\": \"BTFxolIsMvwhQuCgZcxFms5xdLEWwmtx2dKzS2CZzyaOW5add7HcZsOXtEVt9\\/ryLVsD4x1joSsif2WKTZ6HLO87xKIc2JJE8A8+itv\\/XQ0WSZLMChGw5vT\\/WSDf2uikcCVdsb\\/+vADYzp41\\/gahQCCVHuwXVSbve4+P627x+LoIv9H6doGS9AapnPAJTkbg4uFbxpRHNgGkrZ7mcbPTZy5vt2OdOgeZF+CreI4if\\/LZD5KR4XFeFQ==\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 13,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2023-11-08 23:48:30\",\n    \"updated\": \"2025-12-19 08:13:32\"\n}","","","","","","4.5.24.3","2023-11-08 23:48:30","2025-12-19 08:13:32"),
("14","Dynamic_Entity","{\n    \"data\": \"NIqtXE0tzA97cJ53xvVUZhxUY6LpQ6wRKJFH6ppgVZcNKYbFxOtr78ns5FzJhclnChcfwLPZTBOdxEIFK+vWUobsXtT5CswT5cp9NrKncimxk17rWIaVvNlMPh5Vs2B40+s7NvmyeDvCkv4gyCHfRAfnaadpRlk0Nnj2umDmy5QI4PgTGQGnKQpZ1ZBiNvWlVb\\/cnrDKzpA2mKJ6Hs\\/8rmaLqXQHTjJx5CahkH1x7KcgRt047x0L+aAIuDPfIOsxJlufCJAsE\\/ayLXzTi3OGcwoXH8Cz2UwTncRCBSvr1lJlf69MG\\/Z4V+95A6Dvgik\\/bMEUVqYSafs9ceH26bhsmO3Ro3j5eXXbCU6GB4XWFYzsqoLhfo7Ew8X7rvl7BKZmZPd1Sv82raqhffTl+lfhLGDH+3H1qvRa9YL+qvtSL7mANgics4wtPQ==\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 14,\n    \"version\": \"4.5.24.3\",\n    \"created\": \"2024-01-12 04:33:11\",\n    \"updated\": \"2025-12-19 08:13:32\",\n    \"dataIsEncrypted\": true\n}","","","","","","4.5.24.3","2024-01-12 04:33:11","2025-12-19 08:13:32"),
("15","LicenseDataEntity","{\n    \"licenseKey\": \"jcwLlSQZG1Bbq\\/QQvPVZiXIP28LQGGnyfHWk4ytJtdHgqiny7EKVjcb5UkyIZm\\/P7vcM4NArVOXPHhUOGExhQkmqJx8xGO8el5KeqI+A0VGR5SakJHVc7HruCJhnYyiC\",\n    \"status\": \"txLCRT7W5l6Dp0hizrrqb27rX56\\/q5pUIKKeIrC4PC1SQ7QG11GtyLAEf9i4YGeNreopXky7UpcxuMOfwGrXvooLqV3Qho1x\",\n    \"type\": \"QSUbQoVJAiDoy7wEGgDQf3WloWCVSk2c7kGbo2T7tjXCOJoQbDjF6kxWiSKCEIh37AhQ8lEACJ\\/\\/q9AszFRvjigkkSNa\\/49i\",\n    \"data\": \"bsSXR\\/T231uYUO8CBbvK9fib\\/gC0Wtm90asaSPb3sUCwPS8kDNsrMuEGhgqzUDNR7HR\\/7IrPR1Mxp0+O8wV2yM6B8t3FrY7PPc53yeudAVVR+4mckN1yAI\\/VZ9zSdDV5eo9p61r5\\/8Br0fs\\/GdmDroYS9fijljChFMlrnCTYaIUJbAO+QLc8dGIoo3JI+cZDJ6jaoOUPXz9QOcSz2sL10Fv\\/j\\/sKXPAKZJJrllhCr1nLHlWgFQ6L9DgF7QeCSQXqM4jvpM5QzbbTQQCJtkFbdSwg0BiwlKMhGvjG6Qc7Sq4TLrLAwG3pU\\/eyca5JmiE\\/0ida8xLCqDgH3KoX38M8CUwQZoEf3WLrqGEhKDRVTF1teIKCFu0qCaAqmjqH3+pnbfF19za0vhRmjHgfO2d\\/i\\/f2hIyJuKPCFiHJ6pcU8bmOEQv\\/lyFQfl5+UMULmBccZkB7nUQL0dfOqsqZPAimcQ==\",\n    \"lastRemoteUpdate\": \"2025-12-12 09:49:23\",\n    \"lastFailureTime\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 15,\n    \"version\": \"4.5.24.2\",\n    \"created\": \"2024-03-13 04:29:27\",\n    \"updated\": \"2025-12-12 09:49:23\"\n}","","","","","","4.5.24.2","2024-03-13 04:29:27","2025-12-12 09:49:23"),
("16","DUP_PRO_Storage_Entity","{\n    \"name\": \"BackBlaze\",\n    \"notes\": \"\",\n    \"storage_type\": 9,\n    \"config\": \"rGcEjR1nj5OBx\\/LdpOHlC8+ABMXcRcS2aVbEZhh4LzeOW5add7HcZsOXtEVt9\\/ryN094ocpo5k3RIDVpVQ9Uhmm6E9aZVmbyjHoXwTIy6PirmQ3cOjpRn9mpPAYbw9U2skqeNpY0TgcGFPPZ+yz1ZiMZsgeff7CSjlV5NmVBR4V6IVMGX6G6E23iYn5gJ79\\/KdFJy2hojMsJAL+jnT20KyuLpH6QSUsWYVvgUYVjM9PGcy9y4JcoZHKdRCXbm9mVU6yHo6t7HnAHvTOkRo1rptxUo626SrkzoRnHjoFihchQ7ePYXEJLhy4tEHhTDqA\\/W5lX9Cd3B8mPXbdXL6bPwigXtHTHlxAaSXaX8r4Sy1g+pBbeKYpPmy1Wg+CMq6ahLWwlX+siggeLyFgZO\\/eMunBbrULCv0gq3qiNeHHguQPqbP1UOh+3xrv20rsD8wAtTdjsO4esWWRkuAsyJaPnpAGANOaam01C\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 16,\n    \"version\": \"4.5.24.1\",\n    \"created\": \"2025-12-01 06:27:53\",\n    \"updated\": \"2025-12-01 06:27:53\"\n}","","","","","","4.5.24.1","2025-12-01 06:27:53","2025-12-01 06:27:53");

INSERT IGNORE INTO `znE_options` VALUES 
("1","siteurl","https://template.strng.us","yes"),
("2","home","https://template.strng.us","yes"),
("3","blogname","Template Website","yes"),
("4","blogdescription","","yes"),
("5","users_can_register","0","yes"),
("6","admin_email","stronganchortech@gmail.com","yes"),
("7","start_of_week","1","yes"),
("8","use_balanceTags","0","yes"),
("9","use_smilies","1","yes"),
("10","require_name_email","1","yes"),
("11","comments_notify","1","yes"),
("12","posts_per_rss","10","yes"),
("13","rss_use_excerpt","1","yes"),
("14","mailserver_url","mail.example.com","yes"),
("15","mailserver_login","login@example.com","yes"),
("16","mailserver_pass","password","yes"),
("17","mailserver_port","110","yes"),
("18","default_category","1","yes"),
("19","default_comment_status","open","yes"),
("20","default_ping_status","open","yes"),
("21","default_pingback_flag","1","yes"),
("22","posts_per_page","10","yes"),
("23","date_format","F j, Y","yes"),
("24","time_format","g:i a","yes"),
("25","links_updated_date_format","F j, Y g:i a","yes"),
("26","comment_moderation","","yes"),
("27","moderation_notify","1","yes"),
("28","permalink_structure","/%postname%/","yes"),
("30","hack_file","0","yes"),
("31","blog_charset","UTF-8","yes"),
("32","moderation_keys","# List compiled by Oscar. (oscar at notagrouch dot com)\n#\n# Latest list available at http://notagrouch.com/files/wordpress-blacklist-words\n# Usage:\n# Copy the list of words below into your WordPress installation.\n# It is recommended to use this list for the \"Comment Moderation\" section only\n# (go to //wp-admin/options-discussion.php while logged in as an admin)\n# if you use this list in the \"Comment Blacklist\" window, you could find some\n# legitimate comments that get marked as spam. You should also review the list to\n# make sure you remove words that you don\'t want blacklisted or moderated based on\n# your niche.\n# Use Akismet as well and you\'ll have very little if any spam in your blog.\n# Current count: 113\n-online\n4u\nadderall\nadipex\nadvicer\nambien\nbaccarat\nbaccarrat\nblackjack\nbllogspot\nbooker\nbyob\ncar-rental-e-site\ncar-rentals-e-site\ncarisoprodol\ncasino\ncasinos\nchatroom\ncialis\ncitalopram\nclomid\ncoolcoolhu\ncoolhu\ncredit-card-debt\ncredit-report-4u\ncwas\ncyclen\ncyclobenzaprine\ncymbalta\ndating-e-site\nday-trading\ndebt-consolidation\ndebt-consolidation-consultant\ndiscreetordering\ndoxycycline\nduty-free\ndutyfree\nephedra\nequityloans\nfacial\nfemdom\nfetish\nfioricet\nflowers-leading-site\nfreenet\nfreenet-shopping\nfucking\ngambling\ngambling-\nhair-loss\nhealth-insurancedeals-4u\nholdem\nholdempoker\nholdemsoftware\nholdemtexasturbowilson\nhomeequityloans\nhomefinance\nhotel-dealse-site\nhotele-site\nhotelse-site\nhydrocodone\nincest\ninsurance-quotesdeals-4u\ninsurancedeals-4u\njrcreations\nlevitra\nlexapro\nlipitor\nlorazepam\nmacinstruct\nmortgage-4-u\nmortgagequotes\nonline-gambling\nonlinegambling-4u\nottawavalleyag\nownsthis\noxycodone\noxycontin\npalm-texas-holdem-game\npaxil\npenis\npercocet\npharmacy\nphentermine\npoker\npoker-chip\nporn\npoze\npropecia\npussy\nrental-car-e-site\nringtone\nringtones\nroulette\nsex\nshemale\nshoes\nslot-machine\ntexas holdem\ntexas-holdem\nthorcarlson\ntop-e-site\ntop-site\ntramadol\ntrim-spa\nultram\nvaleofglamorganconservatives\nvalium\nvaltrex\nviagra\nvioxx\nxanax\nzolus","no"),
("33","active_plugins","a:21:{i:0;s:47:\"0-anchor-github-token/0-anchor-github-token.php\";i:1;s:24:\"anchor-plugin/anchor.php\";i:2;s:27:\"astra-addon/astra-addon.php\";i:3;s:35:\"astra-pro-sites/astra-pro-sites.php\";i:4;s:33:\"duplicator-pro/duplicator-pro.php\";i:5;s:23:\"elementor/elementor.php\";i:6;s:65:\"essential-addons-for-elementor-lite/essential_adons_elementor.php\";i:7;s:31:\"everest-forms/everest-forms.php\";i:8;s:40:\"hcaptcha-for-forms-and-more/hcaptcha.php\";i:9;s:51:\"header-footer-elementor/header-footer-elementor.php\";i:10;s:39:\"https-redirection/https-redirection.php\";i:11;s:26:\"image-prioritizer/load.php\";i:12;s:29:\"mainwp-child/mainwp-child.php\";i:13;s:31:\"optimization-detective/load.php\";i:14;s:24:\"performance-lab/load.php\";i:15;s:37:\"rocket-lazy-load/rocket-lazy-load.php\";i:16;s:41:\"ultimate-elementor/ultimate-elementor.php\";i:18;s:21:\"webp-uploads/load.php\";i:19;s:23:\"wordfence/wordfence.php\";i:20;s:27:\"wp-optimize/wp-optimize.php\";i:21;s:33:\"wps-hide-login/wps-hide-login.php\";}","yes"),
("34","category_base","","yes"),
("35","ping_sites","https://rpc.pingomatic.com/","yes"),
("36","comment_max_links","1","yes"),
("37","gmt_offset","0","yes"),
("38","default_email_category","1","yes"),
("39","recently_edited","a:3:{i:0;s:67:\"/home/satbiz5/_template/wp-content/plugins/anchor-plugin/anchor.php\";i:2;s:57:\"/home/satbiz5/_template/wp-content/themes/astra/style.css\";i:3;s:0:\"\";}","no"),
("40","template","astra","yes"),
("41","stylesheet","astra","yes"),
("44","comment_registration","","yes"),
("45","html_type","text/html","yes"),
("46","use_trackback","0","yes"),
("47","default_role","subscriber","yes"),
("48","db_version","60717","yes"),
("49","uploads_use_yearmonth_folders","1","yes"),
("50","upload_path","","yes"),
("51","blog_public","1","yes"),
("52","default_link_category","2","yes"),
("53","show_on_front","page","yes"),
("54","tag_base","","yes"),
("55","show_avatars","1","yes"),
("56","avatar_rating","G","yes"),
("57","upload_url_path","","yes"),
("58","thumbnail_size_w","150","yes"),
("59","thumbnail_size_h","150","yes"),
("60","thumbnail_crop","1","yes"),
("61","medium_size_w","300","yes"),
("62","medium_size_h","300","yes"),
("63","avatar_default","mystery","yes"),
("64","large_size_w","1024","yes"),
("65","large_size_h","1024","yes"),
("66","image_default_link_type","","yes"),
("67","image_default_size","","yes"),
("68","image_default_align","","yes"),
("69","close_comments_for_old_posts","1","yes"),
("70","close_comments_days_old","28","yes"),
("71","thread_comments","1","yes"),
("72","thread_comments_depth","5","yes"),
("73","page_comments","","yes"),
("74","comments_per_page","20","yes"),
("75","default_comments_page","newest","yes"),
("76","comment_order","asc","yes"),
("77","sticky_posts","a:0:{}","yes"),
("78","widget_categories","a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes"),
("79","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("80","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("81","uninstall_plugins","a:9:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:39:\"https-redirection/https-redirection.php\";a:2:{i:0;s:14:\"Easy_HTTPS_SSL\";i:1;s:24:\"plugin_uninstall_handler\";}s:50:\"google-analytics-for-wordpress/googleanalytics.php\";s:35:\"monsterinsights_lite_uninstall_hook\";s:27:\"wp-optimize/wp-optimize.php\";a:2:{i:0;s:13:\"WPO_Uninstall\";i:1;s:7:\"actions\";}s:33:\"duplicator-pro/duplicator-pro.php\";a:2:{i:0;s:24:\"Duplicator\\Core\\Unistall\";i:1;s:8:\"unistall\";}s:20:\"worker/functions.php\";s:13:\"mwp_uninstall\";s:44:\"shortpixel-image-optimiser/wp-shortpixel.php\";a:2:{i:0;s:32:\"\\ShortPixel\\Helper\\InstallHelper\";i:1;s:15:\"uninstallPlugin\";}s:88:\"ultimate-elementor/home/satbiz5/_template/wp-content/plugins/wp-optimize/wp-optimize.php\";a:2:{i:0;s:13:\"WPO_Uninstall\";i:1;s:7:\"actions\";}s:29:\"webp-express/webp-express.php\";a:2:{i:0;s:28:\"\\WebPExpress\\PluginUninstall\";i:1;s:9:\"uninstall\";}}","no"),
("82","timezone_string","","yes"),
("83","page_for_posts","0","yes"),
("84","page_on_front","52","yes"),
("85","default_post_format","0","yes"),
("86","link_manager_enabled","0","yes"),
("87","finished_splitting_shared_terms","1","yes"),
("88","site_icon","209","yes"),
("89","medium_large_size_w","768","yes"),
("90","medium_large_size_h","0","yes"),
("91","wp_page_for_privacy_policy","3","yes"),
("92","show_comments_cookies_opt_in","1","yes"),
("93","admin_email_lifespan","1780121886","yes"),
("94","initial_db_version","47018","yes"),
("95","znE_user_roles","a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:118:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:20:\"manage_everest_forms\";b:1;s:20:\"duplicator_pro_basic\";b:1;s:21:\"duplicator_pro_create\";b:1;s:23:\"duplicator_pro_schedule\";b:1;s:22:\"duplicator_pro_storage\";b:1;s:29:\"duplicator_pro_backup_restore\";b:1;s:21:\"duplicator_pro_import\";b:1;s:21:\"duplicator_pro_export\";b:1;s:23:\"duplicator_pro_settings\";b:1;s:22:\"duplicator_pro_license\";b:1;s:13:\"access_cp_pro\";b:1;s:13:\"edit_cp_popup\";b:1;s:13:\"read_cp_popup\";b:1;s:15:\"delete_cp_popup\";b:1;s:14:\"edit_cp_popups\";b:1;s:21:\"edit_others_cp_popups\";b:1;s:17:\"publish_cp_popups\";b:1;s:22:\"read_private_cp_popups\";b:1;s:16:\"delete_cp_popups\";b:1;s:24:\"delete_private_cp_popups\";b:1;s:26:\"delete_published_cp_popups\";b:1;s:23:\"delete_others_cp_popups\";b:1;s:22:\"edit_private_cp_popups\";b:1;s:24:\"edit_published_cp_popups\";b:1;s:21:\"manage_cp_popup_terms\";b:1;s:19:\"edit_cp_popup_terms\";b:1;s:21:\"delete_cp_popup_terms\";b:1;s:21:\"assign_cp_popup_terms\";b:1;s:26:\"everest_forms_create_forms\";b:1;s:24:\"everest_forms_view_forms\";b:1;s:31:\"everest_forms_view_others_forms\";b:1;s:24:\"everest_forms_edit_forms\";b:1;s:31:\"everest_forms_edit_others_forms\";b:1;s:26:\"everest_forms_delete_forms\";b:1;s:33:\"everest_forms_delete_others_forms\";b:1;s:26:\"everest_forms_view_entries\";b:1;s:33:\"everest_forms_view_others_entries\";b:1;s:26:\"everest_forms_edit_entries\";b:1;s:33:\"everest_forms_edit_others_entries\";b:1;s:28:\"everest_forms_delete_entries\";b:1;s:35:\"everest_forms_delete_others_entries\";b:1;s:26:\"manage_ast_block_templates\";b:1;s:8:\"backwpup\";b:1;s:13:\"backwpup_jobs\";b:1;s:18:\"backwpup_jobs_edit\";b:1;s:19:\"backwpup_jobs_start\";b:1;s:16:\"backwpup_backups\";b:1;s:25:\"backwpup_backups_download\";b:1;s:23:\"backwpup_backups_delete\";b:1;s:13:\"backwpup_logs\";b:1;s:20:\"backwpup_logs_delete\";b:1;s:17:\"backwpup_settings\";b:1;s:16:\"backwpup_restore\";b:1;s:23:\"manage_zip_ai_assistant\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:23:\"manage_zip_ai_assistant\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:14:\"backwpup_admin\";a:2:{s:4:\"name\";s:14:\"BackWPup Admin\";s:12:\"capabilities\";a:12:{s:4:\"read\";b:1;s:8:\"backwpup\";b:1;s:13:\"backwpup_jobs\";b:1;s:18:\"backwpup_jobs_edit\";b:1;s:19:\"backwpup_jobs_start\";b:1;s:16:\"backwpup_backups\";b:1;s:25:\"backwpup_backups_download\";b:1;s:23:\"backwpup_backups_delete\";b:1;s:13:\"backwpup_logs\";b:1;s:20:\"backwpup_logs_delete\";b:1;s:17:\"backwpup_settings\";b:1;s:16:\"backwpup_restore\";b:1;}}s:14:\"backwpup_check\";a:2:{s:4:\"name\";s:21:\"BackWPup jobs checker\";s:12:\"capabilities\";a:12:{s:4:\"read\";b:1;s:8:\"backwpup\";b:1;s:13:\"backwpup_jobs\";b:1;s:18:\"backwpup_jobs_edit\";b:0;s:19:\"backwpup_jobs_start\";b:0;s:16:\"backwpup_backups\";b:1;s:25:\"backwpup_backups_download\";b:0;s:23:\"backwpup_backups_delete\";b:0;s:13:\"backwpup_logs\";b:1;s:20:\"backwpup_logs_delete\";b:0;s:17:\"backwpup_settings\";b:0;s:16:\"backwpup_restore\";b:0;}}s:15:\"backwpup_helper\";a:2:{s:4:\"name\";s:23:\"BackWPup jobs functions\";s:12:\"capabilities\";a:12:{s:4:\"read\";b:1;s:8:\"backwpup\";b:1;s:13:\"backwpup_jobs\";b:1;s:18:\"backwpup_jobs_edit\";b:0;s:19:\"backwpup_jobs_start\";b:1;s:16:\"backwpup_backups\";b:1;s:25:\"backwpup_backups_download\";b:1;s:23:\"backwpup_backups_delete\";b:1;s:13:\"backwpup_logs\";b:1;s:20:\"backwpup_logs_delete\";b:1;s:17:\"backwpup_settings\";b:0;s:16:\"backwpup_restore\";b:0;}}}","yes"),
("96","fresh_site","0","off"),
("97","widget_search","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("98","widget_recent-posts","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes"),
("99","widget_recent-comments","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes"),
("100","widget_archives","a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes"),
("101","widget_meta","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("102","sidebars_widgets","a:10:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:11:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";i:6;s:7:\"block-1\";i:7;s:7:\"block-2\";i:8;s:7:\"block-3\";i:9;s:7:\"block-4\";i:10;s:7:\"block-5\";}s:13:\"header-widget\";a:0:{}s:15:\"footer-widget-1\";a:1:{i:0;s:7:\"block-6\";}s:15:\"footer-widget-2\";a:0:{}s:24:\"advanced-footer-widget-1\";a:0:{}s:24:\"advanced-footer-widget-2\";a:0:{}s:24:\"advanced-footer-widget-3\";a:0:{}s:24:\"advanced-footer-widget-4\";a:0:{}s:13:\"array_version\";i:3;}","yes"),
("103","endurance_cache_level","2","yes"),
("104","monsterinsights_shareasale_id","1258907","yes"),
("113","allow_major_auto_core_updates","true","yes"),
("114","allow_minor_auto_core_updates","true","yes"),
("115","auto_update_plugin","true","yes"),
("116","auto_update_theme","true","yes"),
("117","auto_update_translation","true","yes"),
("118","mm_brand","BlueHost","yes"),
("119","mm_coming_soon","false","yes"),
("120","mm_host","BlueHost","yes"),
("121","cron","a:45:{i:1766132533;a:1:{s:34:\"od_trigger_page_cache_invalidation\";a:1:{s:32:\"d38bf3ceef616da487e3a5a67efee824\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:52;}}}}i:1766132538;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1766132824;a:1:{s:32:\"duplicator_backup_storages_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:41:\"duplicator_backup_storages_check_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:900;}}}i:1766132991;a:1:{s:36:\"puc_cron_check_updates-anchor-plugin\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1766134094;a:1:{s:14:\"mm_cron_hourly\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1766134535;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1766135524;a:1:{s:31:\"duplicator_activity_log_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"duplicator_daily_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766135659;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1766135948;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1766136096;a:1:{s:39:\"everest_forms_biweekly_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:8:\"biweekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}i:1766139056;a:1:{s:22:\"mwp_update_public_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766139413;a:1:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766139924;a:1:{s:33:\"updraftplus_clean_temporary_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1766143536;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766143539;a:1:{s:29:\"wpo_smush_clear_backup_images\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766146297;a:1:{s:26:\"everest_forms_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766149902;a:1:{s:17:\"od_url_metrics_gc\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766150059;a:3:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1766152093;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766152094;a:2:{s:13:\"mm_cron_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:18:\"mm_cron_twicedaily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1766152095;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766153291;a:1:{s:19:\"wpseo-reindex-links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766155253;a:1:{s:20:\"wpseo_home_url_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766157097;a:1:{s:30:\"everest_forms_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1766168272;a:1:{s:31:\"eael_remove_unused_options_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766169131;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1766170139;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766186738;a:1:{s:26:\"wpo_minify_purge_old_cache\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766205033;a:1:{s:29:\"astra_get_knowledge_base_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766208381;a:1:{s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766213720;a:1:{s:26:\"wordfence_daily_autoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766213735;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766214732;a:1:{s:27:\"astra_addon_get_addon_usage\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1766225522;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1766248333;a:1:{s:35:\"monsterinsights_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1766260564;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"4bc38813901acccef280d14051fcff08\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1766260564;}}}}i:1766324894;a:1:{s:14:\"mm_cron_weekly\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1766409259;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1766419200;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1766479321;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1766489140;a:1:{s:21:\"wpo_weekly_cron_tasks\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1766519764;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"de512c98134b95e804465c5566978628\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1766519764;}}}}i:1766556224;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1768649139;a:1:{s:28:\"wpo_smush_clear_failed_tasks\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"wpo_monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2592000;}}}s:7:\"version\";i:2;}","on"),
("124","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("125","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("126","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("127","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("128","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("129","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("130","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("131","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("132","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("134","monsterinsights_over_time","a:3:{s:17:\"installed_version\";s:6:\"7.10.4\";s:14:\"installed_date\";i:1586092459;s:13:\"installed_pro\";b:0;}","yes"),
("135","monsterinsights_db_version","7.4.0","yes"),
("136","monsterinsights_current_version","7.12.0","yes"),
("137","monsterinsights_settings","a:21:{s:22:\"enable_affiliate_links\";b:1;s:15:\"affiliate_links\";a:2:{i:0;a:2:{s:4:\"path\";s:4:\"/go/\";s:5:\"label\";s:9:\"affiliate\";}i:1;a:2:{s:4:\"path\";s:11:\"/recommend/\";s:5:\"label\";s:9:\"affiliate\";}}s:12:\"demographics\";i:1;s:12:\"ignore_users\";a:2:{i:0;s:13:\"administrator\";i:1;s:6:\"editor\";}s:19:\"dashboards_disabled\";i:0;s:13:\"anonymize_ips\";i:0;s:19:\"extensions_of_files\";s:34:\"doc,pdf,ppt,zip,xls,docx,pptx,xlsx\";s:18:\"subdomain_tracking\";s:0:\"\";s:16:\"link_attribution\";b:1;s:16:\"tag_links_in_rss\";b:1;s:12:\"allow_anchor\";i:0;s:16:\"add_allow_linker\";i:0;s:11:\"custom_code\";s:0:\"\";s:13:\"save_settings\";a:1:{i:0;s:13:\"administrator\";}s:12:\"view_reports\";a:2:{i:0;s:13:\"administrator\";i:1;s:6:\"editor\";}s:11:\"events_mode\";s:2:\"js\";s:13:\"tracking_mode\";s:9:\"analytics\";s:15:\"email_summaries\";s:2:\"on\";s:23:\"summaries_html_template\";s:3:\"yes\";s:25:\"summaries_email_addresses\";a:1:{i:0;a:1:{s:5:\"email\";s:26:\"stronganchortech@gmail.com\";}}s:17:\"automatic_updates\";s:4:\"none\";}","yes"),
("153","monsterinsights_usage_tracking_config","a:6:{s:3:\"day\";i:6;s:4:\"hour\";i:16;s:6:\"minute\";i:32;s:6:\"second\";i:13;s:6:\"offset\";i:577933;s:8:\"initsend\";i:1587227533;}","yes"),
("154","recovery_keys","a:0:{}","off"),
("157","_mm_refresh_token","5c273c94-a360-49b6-9348-51870a141f3b","yes"),
("162","eig_last_site_login","2020-04-28T08:53:38+00:00","yes"),
("165","do_activate","0","yes"),
("170","mm_install_date","Apr 05, 2020","yes"),
("171","mm_cron","a:1:{s:6:\"hourly\";a:1:{s:9:\"installed\";a:5:{s:1:\"t\";s:5:\"event\";s:2:\"ec\";s:13:\"plugin_status\";s:2:\"ea\";s:9:\"installed\";s:2:\"el\";s:26:\"Install date: Apr 05, 2020\";s:4:\"keep\";b:0;}}}","yes"),
("172","_amn_mi-lite_to_check","1592835800","yes"),
("177","monsterinsights_review","a:2:{s:4:\"time\";i:1586094495;s:9:\"dismissed\";b:0;}","yes"),
("194","theme_mods_twentytwenty","a:3:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1599326342;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}s:18:\"nav_menu_locations\";a:0:{}}","no"),
("195","recently_activated","a:0:{}","off"),
("202","duplicator_pro_reset_user_settings_required","0","yes"),
("205","e6ee6e148c8cc8e35bc93ecfa770bd87","a:2:{s:7:\"timeout\";i:1653633131;s:5:\"value\";s:1850:\"{\"new_version\":\"4.5.3\",\"stable_version\":\"4.5.3\",\"name\":\"Duplicator Pro\",\"slug\":\"duplicator-pro\",\"url\":\"https:\\/\\/snapcreek.com\\/downloads\\/duplicator-pro\\/?changelog=1\",\"last_updated\":\"2022-05-24 02:14:54\",\"homepage\":\"https:\\/\\/snapcreek.com\\/duplicator\",\"package\":\"https:\\/\\/snapcreek.com\\/edd-sl\\/package_download\\/MTY1NDY0NDczMTphYTEyYjliZmZlY2U3NjVhNGY1YTM2ZjA3MDJhZTNjMTozMTplOGQ1OTI5ZDIzMWRmNTcyNmY4MDAxMWY4MGJkMTJlMDpodHRwc0AvL3RlbXBsYXRlLnN0cm5nLnVzOjA=\",\"download_link\":\"https:\\/\\/snapcreek.com\\/edd-sl\\/package_download\\/MTY1NDY0NDczMTphYTEyYjliZmZlY2U3NjVhNGY1YTM2ZjA3MDJhZTNjMTozMTplOGQ1OTI5ZDIzMWRmNTcyNmY4MDAxMWY4MGJkMTJlMDpodHRwc0AvL3RlbXBsYXRlLnN0cm5nLnVzOjA=\",\"sections\":{\"faq\":\"<p>See <a href=\\\"https:\\/\\/snapcreek.com\\/duplicator\\/docs\\/faqs-tech\\/\\\">Technical FAQ<\\/a><\\/p>\",\"changelog\":\"<p>See <a href=\\\"https:\\/\\/snapcreek.com\\/duplicator\\/docs\\/changelog\\/\\\">Changelog<\\/a><\\/p>\",\"description\":\"<p>WordPress migration and backups are much easier with Duplicator Pro! Clone, backup, or transfer an entire site from one location to another.<\\/p>\"},\"banners\":{\"high\":\"\",\"low\":\"\"},\"icons\":\"a:0:{}\",\"tags\":[\"migration\",\"backup\",\"duplicate\",\"move\",\"migrate\"],\"requires\":\"4.0\",\"tested\":\"5.9.3\",\"requires_php\":\"5.6.20\",\"short_description\":\"WordPress migration and backups are much easier with Duplicator Pro! Clone, backup, or transfer an entire site from one location to another.\",\"upgrade_notice\":\"<p>No notes.<\\/p>\",\"screenshots\":[],\"faq\":[\"<p>See <a href=\\\"https:\\/\\/snapcreek.com\\/duplicator\\/docs\\/faqs-tech\\/\\\">Technical FAQ<\\/a><\\/p>\"],\"warnings\":[],\"changelog\":[\"<p>See <a href=\\\"https:\\/\\/snapcreek.com\\/duplicator\\/docs\\/changelog\\/\\\">Changelog<\\/a><\\/p>\"],\"description\":[\"<p>WordPress migration and backups are much easier with Duplicator Pro! Clone, backup, or transfer an entire site from one location to another.<\\/p>\"]}\";}","yes"),
("221","wordfence_installed","1","yes"),
("223","wf_plugin_act_error","","yes"),
("235","elementor_version","3.33.4","yes"),
("237","_elementor_installed_time","1586095195","yes"),
("238","elementor_remote_info_library","a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}","off"),
("239","elementor_remote_info_feed_data","a:3:{i:0;a:5:{s:5:\"title\";s:79:\"Introducing Elementor 3.33: Variables Manager, Custom CSS, Blend Modes, & more!\";s:7:\"excerpt\";s:340:\"Elementor 3.33 builds on the foundation of Editor V4, continuing our mission to create a faster, more scalable, and more intuitive design experience for Web Creators. With the addition of the Variables Manager, element-level Custom CSS, Background Clipping, and Blend Modes, designers have more creative precision and consistency than ever.\";s:7:\"created\";i:1762944115;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:145:\"https://elementor.com/blog/elementor-333-v4-variables-manager-custom-css/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}","off"),
("247","everest_forms_disable_user_details","no","yes"),
("248","everest_forms_recaptcha_type","v2","yes"),
("249","everest_forms_recaptcha_v2_site_key","","yes"),
("250","everest_forms_recaptcha_v2_secret_key","","yes"),
("251","everest_forms_recaptcha_v2_invisible_site_key","","yes"),
("252","everest_forms_recaptcha_v2_invisible_secret_key","","yes"),
("253","everest_forms_recaptcha_v2_invisible","no","yes"),
("254","everest_forms_recaptcha_v3_site_key","","yes"),
("255","everest_forms_recaptcha_v3_secret_key","","yes"),
("256","everest_forms_email_template","default","yes"),
("257","everest_forms_enable_email_copies","no","yes"),
("258","everest_forms_required_validation","This field is required.","yes"),
("259","everest_forms_url_validation","Please enter a valid URL.","yes"),
("260","everest_forms_email_validation","Please enter a valid email address.","yes"),
("261","everest_forms_email_suggestion","Did you mean {suggestion}?","yes"),
("262","everest_forms_confirm_validation","Field values do not match.","yes"),
("263","everest_forms_check_limit_validation","You have exceeded number of allowed selections: {#}.","yes"),
("264","everest_forms_number_validation","Please enter a valid number.","yes"),
("267","everest_forms_default_form_page_id","6","yes"),
("272","everest_forms_activated","1586095249","yes"),
("273","everest_forms_admin_notices","a:5:{i:0;s:6:\"review\";i:1;s:6:\"survey\";i:2;s:11:\"allow_usage\";i:3;s:15:\"php_deprecation\";i:4;s:12:\"email_failed\";}","yes"),
("277","everest_forms_review","a:2:{s:4:\"time\";i:1588679025;s:9:\"dismissed\";b:1;}","yes"),
("282","current_theme","Astra","yes"),
("283","theme_mods_zakra","a:10:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:19:\"zakra_header_top_bg\";a:6:{s:16:\"background-color\";s:7:\"#e9ecef\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:7:\"contain\";s:21:\"background-attachment\";s:6:\"scroll\";}s:20:\"zakra_header_main_bg\";a:6:{s:16:\"background-color\";s:7:\"#ffffff\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:7:\"contain\";s:21:\"background-attachment\";s:6:\"scroll\";}s:19:\"zakra_page_title_bg\";a:6:{s:16:\"background-color\";s:7:\"#ffffff\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:7:\"contain\";s:21:\"background-attachment\";s:6:\"scroll\";}s:33:\"zakra_footer_bar_section_one_html\";s:177:\"Copyright © 2020 <a href=\"/\">Template Website</a>. Website designed by <a href=\"https://www.stronganchortech.com/\" target=\"_blank\" rel=\"author noopener\">Strong Anchor Tech</a>.\";s:19:\"zakra_footer_bar_bg\";a:6:{s:16:\"background-color\";s:7:\"#ffffff\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:7:\"contain\";s:21:\"background-attachment\";s:6:\"scroll\";}s:23:\"zakra_footer_widgets_bg\";a:6:{s:16:\"background-color\";s:7:\"#ffffff\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:7:\"contain\";s:21:\"background-attachment\";s:6:\"scroll\";}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1597411954;s:4:\"data\";a:11:{s:19:\"wp_inactive_widgets\";a:0:{}s:23:\"header-top-left-sidebar\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:24:\"header-top-right-sidebar\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:13:\"sidebar-right\";a:0:{}s:12:\"sidebar-left\";a:0:{}s:16:\"footer-sidebar-1\";a:0:{}s:16:\"footer-sidebar-2\";a:0:{}s:16:\"footer-sidebar-3\";a:0:{}s:16:\"footer-sidebar-4\";a:0:{}s:23:\"footer-bar-left-sidebar\";a:0:{}s:24:\"footer-bar-right-sidebar\";a:0:{}}}}","no"),
("284","theme_switched","","yes"),
("294","zakra_admin_notice_welcome","1","yes"),
("300","wpseo","a:110:{s:8:\"tracking\";b:0;s:16:\"toggled_tracking\";b:0;s:22:\"license_server_version\";b:0;s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:1;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:13:\"first_install\";s:29:\"indexables_indexing_completed\";b:1;s:13:\"index_now_key\";s:0:\"\";s:7:\"version\";s:4:\"22.6\";s:16:\"previous_version\";s:4:\"22.5\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:0;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:43:\"Sho1x02oXcRNuWf95sY0aS83nEBMgl6t6VahJnkyCe0\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:34:\"inclusive_language_analysis_active\";b:0;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:16:\"enable_index_now\";b:1;s:19:\"enable_ai_generator\";b:0;s:22:\"ai_enabled_pre_default\";b:0;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1601542152;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:12:\"/%postname%/\";s:8:\"home_url\";s:25:\"https://template.strng.us\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:4:{s:22:\"elementor_library_type\";s:22:\"elementor_library_type\";s:26:\"elementor_library_category\";s:26:\"elementor_library_category\";s:11:\"cp_campaign\";s:11:\"cp_campaign\";s:14:\"cp_connections\";s:14:\"cp_connections\";}s:29:\"enable_enhanced_slack_sharing\";b:1;s:25:\"zapier_integration_active\";b:1;s:19:\"zapier_subscription\";a:0:{}s:14:\"zapier_api_key\";s:0:\"\";s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:28:\"configuration_finished_steps\";a:0:{}s:36:\"dismiss_configuration_workout_notice\";b:1;s:34:\"dismiss_premium_deactivated_notice\";b:0;s:19:\"importing_completed\";a:0:{}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:28:\"wordproof_integration_active\";b:0;s:29:\"wordproof_integration_changed\";b:0;s:18:\"first_time_install\";b:1;s:34:\"should_redirect_after_install_free\";b:0;s:34:\"activation_redirect_timestamp_free\";i:1652258756;s:18:\"remove_feed_global\";b:0;s:27:\"remove_feed_global_comments\";b:0;s:25:\"remove_feed_post_comments\";b:0;s:19:\"remove_feed_authors\";b:0;s:22:\"remove_feed_categories\";b:0;s:16:\"remove_feed_tags\";b:0;s:29:\"remove_feed_custom_taxonomies\";b:0;s:22:\"remove_feed_post_types\";b:0;s:18:\"remove_feed_search\";b:0;s:21:\"remove_atom_rdf_feeds\";b:0;s:17:\"remove_shortlinks\";b:0;s:21:\"remove_rest_api_links\";b:0;s:20:\"remove_rsd_wlw_links\";b:0;s:19:\"remove_oembed_links\";b:0;s:16:\"remove_generator\";b:0;s:20:\"remove_emoji_scripts\";b:0;s:24:\"remove_powered_by_header\";b:0;s:22:\"remove_pingback_header\";b:0;s:28:\"clean_campaign_tracking_urls\";b:0;s:16:\"clean_permalinks\";b:0;s:32:\"clean_permalinks_extra_variables\";s:0:\"\";s:14:\"search_cleanup\";b:0;s:20:\"search_cleanup_emoji\";b:0;s:23:\"search_cleanup_patterns\";b:0;s:22:\"search_character_limit\";i:50;s:20:\"deny_search_crawling\";b:0;s:21:\"deny_wp_json_crawling\";b:0;s:20:\"deny_adsbot_crawling\";b:0;s:19:\"deny_ccbot_crawling\";b:0;s:29:\"deny_google_extended_crawling\";b:0;s:20:\"deny_gptbot_crawling\";b:0;s:27:\"redirect_search_pretty_urls\";b:0;s:29:\"least_readability_ignore_list\";a:0:{}s:27:\"least_seo_score_ignore_list\";a:0:{}s:23:\"most_linked_ignore_list\";a:0:{}s:24:\"least_linked_ignore_list\";a:0:{}s:28:\"indexables_page_reading_list\";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:\"indexables_overview_state\";s:21:\"dashboard-not-visited\";s:28:\"last_known_public_post_types\";a:4:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:14:\"e-landing-page\";i:3;s:12:\"elementor-hf\";}s:28:\"last_known_public_taxonomies\";a:3:{i:0;s:8:\"category\";i:1;s:8:\"post_tag\";i:2;s:11:\"post_format\";}s:23:\"last_known_no_unindexed\";a:4:{s:40:\"wpseo_total_unindexed_post_type_archives\";i:1715059546;s:35:\"wpseo_total_unindexed_general_items\";i:1715059546;s:31:\"wpseo_unindexed_post_link_count\";i:1715059546;s:31:\"wpseo_unindexed_term_link_count\";i:1715059546;}s:14:\"new_post_types\";a:0:{}s:14:\"new_taxonomies\";a:0:{}s:34:\"show_new_content_type_notification\";b:0;}","yes"),
("301","wpseo_titles","a:129:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:23:\"is-media-purge-relevant\";b:0;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:23:\"%%term_title%% Archives\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:23:\"title-elementor_library\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-elementor_library\";s:0:\"\";s:25:\"noindex-elementor_library\";b:0;s:36:\"display-metabox-pt-elementor_library\";b:1;s:36:\"post_types-elementor_library-maintax\";i:0;s:34:\"schema-page-type-elementor_library\";s:7:\"WebPage\";s:37:\"schema-article-type-elementor_library\";s:4:\"None\";s:30:\"social-title-elementor_library\";s:9:\"%%title%%\";s:36:\"social-description-elementor_library\";s:0:\"\";s:34:\"social-image-url-elementor_library\";s:0:\"\";s:33:\"social-image-id-elementor_library\";i:0;s:18:\"title-elementor-hf\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-elementor-hf\";s:0:\"\";s:20:\"noindex-elementor-hf\";b:0;s:31:\"display-metabox-pt-elementor-hf\";b:1;s:31:\"post_types-elementor-hf-maintax\";i:0;s:29:\"schema-page-type-elementor-hf\";s:7:\"WebPage\";s:32:\"schema-article-type-elementor-hf\";s:4:\"None\";s:25:\"social-title-elementor-hf\";s:9:\"%%title%%\";s:31:\"social-description-elementor-hf\";s:0:\"\";s:29:\"social-image-url-elementor-hf\";s:0:\"\";s:28:\"social-image-id-elementor-hf\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:0;s:17:\"company_logo_meta\";b:0;s:16:\"person_logo_meta\";b:0;s:29:\"open_graph_frontpage_image_id\";i:0;}","yes"),
("302","wpseo_social","a:18:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";}","yes"),
("303","wpseo_flush_rewrite","1","yes"),
("312","wpseo_ryte","a:2:{s:6:\"status\";i:1;s:10:\"last_fetch\";i:1649019816;}","yes"),
("492","elementor_log","a:43:{s:32:\"9c14e123ea3ca25d250491e6162e6e0d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-05 10:58:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-05 10:58:13\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"b95498fc1126a2b32ac9f1d9f31655dd\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-05 10:58:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-05 10:58:13\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"8911b92b7f0a1ce19ba4fe13ef05cecd\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-05 10:58:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-05 10:58:13\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"1721b9033fc0b672541a6fb9659cda22\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-05 10:58:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.25.5\";s:2:\"to\";s:6:\"3.27.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-05 10:58:13\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.25.5\";s:2:\"to\";s:6:\"3.27.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"1eebf3f20227f03ebb4f5d70b0f6cbc6\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-05 10:58:14\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.25.5\";s:2:\"to\";s:6:\"3.27.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-05 10:58:14\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.25.5\";s:2:\"to\";s:6:\"3.27.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"4c17abd2a5feaaa7a112586f6ca8d410\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-29 06:15:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-29 06:15:25\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"cfde144595797e43e42022d9ad85ab70\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-29 06:15:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-29 06:15:25\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"85b0803482cd8106817050e407c0dda4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-29 06:15:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-29 06:15:25\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"44e80be848c8d20ee4570f327bad69d0\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-29 06:15:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:37:\"Elementor/Upgrades - _v_3_26_0 Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-29 06:15:25\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:37:\"Elementor/Upgrades - _v_3_26_0 Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"5607de4a8f91a69c3db12c0efe388f42\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-29 06:15:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:39:\"Elementor/Upgrades - _v_3_26_0 Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-29 06:15:25\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:39:\"Elementor/Upgrades - _v_3_26_0 Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"9140e54b1a6a7f8d0e10fb8e7739d82c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-29 06:15:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.27.3\";s:2:\"to\";s:6:\"3.28.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-29 06:15:25\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.27.3\";s:2:\"to\";s:6:\"3.28.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"bf0b52b85615d82c96a98dcf5beb4863\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-20 05:10:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-20 05:10:16\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.0\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"ae2df7c854f2d5414182465536524968\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-23 11:38:35\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-23 11:38:35\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"d5a1254f092ca728ac9e5d9cb7477de5\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-23 11:38:35\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-23 11:38:35\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"a81bef67abf1733a861da6490d5b3097\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-23 11:38:35\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-23 11:38:35\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"5c8ded95a0334006374f4913df12863b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-23 11:38:35\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-23 11:38:35\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"ce66c4f76bf55c3f086b160edce4eddf\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-01 12:56:38\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.2\";s:2:\"to\";s:6:\"3.30.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-01 12:56:38\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.2\";s:2:\"to\";s:6:\"3.30.0\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"6226d38ab73b0fc978ba32e908b43f11\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-01 12:56:39\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-01 12:56:39\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"9c1cf78c9ffc1359bb96cbccad0b35c8\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-01 12:56:39\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-01 12:56:39\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"f688b7c50fc2b9c9b5f8278b57533b0d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-01 12:56:39\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-01 12:56:39\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"5380614ffd60aee70e251bb48679c0fa\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-01 12:56:39\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.2\";s:2:\"to\";s:6:\"3.30.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-01 12:56:39\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.2\";s:2:\"to\";s:6:\"3.30.0\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"68095508d5c4524e9f9bee7a716ca32f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-08 09:11:57\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.0\";s:2:\"to\";s:6:\"3.30.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-08 09:11:57\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.0\";s:2:\"to\";s:6:\"3.30.1\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"daae7b6b03943e0a16b46bd981018aba\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-29 09:30:40\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-29 09:30:40\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"8933a07717610db32bb1eaa156af6f27\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-29 09:30:40\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-29 09:30:40\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"5af4a6d1eef5d9015eb5be7546ad8ad3\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-29 09:30:40\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-29 09:30:40\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"c42cf9a58f128d7c23170917ccda3a1a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-29 09:30:40\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.0\";s:2:\"to\";s:6:\"3.30.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-29 09:30:40\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.0\";s:2:\"to\";s:6:\"3.30.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"854eefbb5c48c1ea61e19eca0400cb12\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-29 09:30:40\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.0\";s:2:\"to\";s:6:\"3.30.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-29 09:30:40\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.0\";s:2:\"to\";s:6:\"3.30.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"1668ce165f32e38fa2bfc91636aad18b\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-08-28 09:15:50\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:52:\"Automatic conversion of false to array is deprecated\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-28 09:15:50\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:52:\"Automatic conversion of false to array is deprecated\";s:4:\"file\";s:69:\"/home/satbiz5/_template/wp-content/plugins/elementor/includes/api.php\";s:4:\"line\";i:176;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:69:\"/home/satbiz5/_template/wp-content/plugins/elementor/includes/api.php\";s:7:\"\0*\0line\";i:176;}s:32:\"542be58498de827c3463b1c4e2bb4b48\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-01 06:18:39\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-01 06:18:39\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"be616c6f0ff753b6496e7caa0f8fd08e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-01 06:18:39\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-01 06:18:39\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"8adef877fd913cb85d13a945370fbbe4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-01 06:18:39\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-01 06:18:39\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"7995a1075aa11e3a4d32aea24e91b53d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-01 06:18:39\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.3\";s:2:\"to\";s:6:\"3.33.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-01 06:18:39\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.3\";s:2:\"to\";s:6:\"3.33.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"96c1d1370c75463a7425d8e2b51f0a82\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-05 10:13:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-05 10:13:16\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"2ac5afac1c5991d5ebc27c2680c1fa02\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-05 10:13:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-05 10:13:16\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"9ec4bd043625c89a17c4b500c5334363\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-05 10:13:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-05 10:13:16\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"2b555bfe17b939ce675310377eff0747\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-05 10:13:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.2\";s:2:\"to\";s:6:\"3.33.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-05 10:13:16\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.2\";s:2:\"to\";s:6:\"3.33.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"46ad32c0ebab01ed59215dd4424b6d7d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-05 10:13:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.2\";s:2:\"to\";s:6:\"3.33.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-05 10:13:16\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.2\";s:2:\"to\";s:6:\"3.33.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"6201df6b3cec5eb2baab15b273c8f02f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-09 10:12:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-09 10:12:05\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"ed69c9b10be1b5492f7106c9d4623a1f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-09 10:12:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-09 10:12:05\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"a1078ca637551e5fa027e547e5830257\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-09 10:12:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-09 10:12:05\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"014c3e30e22bcd2920ae6c0b8c6860c4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-09 10:12:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.3\";s:2:\"to\";s:6:\"3.33.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-09 10:12:05\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.3\";s:2:\"to\";s:6:\"3.33.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"18f05e3d7497128f24eabd8f23e45c79\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-09 10:12:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.3\";s:2:\"to\";s:6:\"3.33.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-09 10:12:05\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.3\";s:2:\"to\";s:6:\"3.33.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"11c4920b05168e7119ef9d2b54f3ad36\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-09 10:12:07\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.3\";s:2:\"to\";s:6:\"3.33.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-09 10:12:07\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.33.3\";s:2:\"to\";s:6:\"3.33.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}}","off"),
("548","yoast_migrations_free","a:1:{s:7:\"version\";s:4:\"22.6\";}","yes"),
("612","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:26:\"stronganchortech@gmail.com\";s:7:\"version\";s:5:\"6.8.2\";s:9:\"timestamp\";i:1752641745;}","off"),
("794","rocket_lazyload_options","a:2:{s:6:\"images\";s:1:\"1\";s:7:\"iframes\";s:1:\"1\";}","yes"),
("802","wp-short-pixel-create-webp-markup","","no"),
("805","wp-short-pixel-activation-date","1695962337","no"),
("807","wp-short-pixel-compression","1","no"),
("808","wp-short-process_thumbnails","1","no"),
("809","wp-short-pixel_cmyk2rgb","1","no"),
("810","wp-short-backup_images","1","no"),
("811","wp-short-pixel-resize-images","0","no"),
("812","wp-short-pixel-resize-width","0","no"),
("813","wp-short-pixel-resize-height","0","no"),
("816","wp-short-pixel-keep-exif","0","no"),
("817","wp-short-create-webp","","no"),
("818","wp-short-pixel-optimize-retina","1","no"),
("819","wp-short-pixel-optimize-unlisted","0","no"),
("820","wp-short-pixel-resize-type","","no"),
("821","wp-short-pixel-site-auth-user","","no"),
("822","wp-short-pixel-site-auth-pass","","no"),
("823","wp-short-pixel-auto-media-library","1","no"),
("824","wp-short-pixel-optimize-pdfs","1","no"),
("825","wp-short-pixel-exclude-patterns","a:0:{}","no"),
("826","wp-short-pixel-png2jpg","0","no"),
("827","wp-short-pixel-excludeSizes","a:0:{}","no"),
("828","wp-short-pixel-cloudflareAPIEmail","","no"),
("829","wp-short-pixel-cloudflareAuthKey","","no"),
("830","wp-short-pixel-cloudflareAPIZoneID","","no"),
("831","wp-short-pixel-cloudflareToken","","no"),
("832","wp-short-pixel-include-next-gen","","no"),
("833","wp-short-pixel-has-custom-folders","","no"),
("837","wp-short-pixel-fileCount","98","yes"),
("838","wp-short-pixel-thumbnail-count","75","yes"),
("839","wp-short-pixel-files-under-5-percent","3","yes"),
("840","wp-short-pixel-savedSpace","4093490","yes"),
("841","wp-short-pixel-api-retries","0","yes"),
("842","wp-short-pixel-total-optimized","3272820","yes"),
("843","wp-short-pixel-total-original","7366310","yes"),
("844","wp-short-pixel-quota-exceeded","0","yes"),
("845","wp-short-pixel-protocol","https","no"),
("846","wp-short-pixel-download-protocol","http","yes"),
("847","wp-short-pixel-download-archive","5","yes"),
("850","wp-short-pixel-view-mode","1","yes"),
("852","wp-short-pixel-converted-png2jpg","a:0:{}","no"),
("1078","zakra_upgrade_notice_start_time","1590414609","yes"),
("1211","jetpack_connection_active_plugins","a:1:{s:7:\"jetpack\";a:1:{s:4:\"name\";s:7:\"Jetpack\";}}","yes"),
("1956","monsterinsights_version_upgraded_from","7.11.0","yes"),
("2851","monsterinsights_notifications","a:4:{s:6:\"update\";i:1599317544;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}","yes"),
("2903","disallowed_keys","","no"),
("2904","comment_previously_approved","1","yes"),
("2905","auto_plugin_theme_update_emails","a:1:{s:0:\"\";s:7:\"4.0.2.1\";}","no"),
("2906","finished_updating_comment_type","1","yes"),
("2907","db_upgraded","","on"),
("3017","theme_mods_astra","a:5:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:7:\"primary\";i:5;s:11:\"footer_menu\";i:5;}s:18:\"custom_css_post_id\";i:47;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1599326283;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:13:\"header-widget\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:15:\"footer-widget-1\";a:0:{}s:15:\"footer-widget-2\";a:0:{}s:24:\"advanced-footer-widget-1\";a:0:{}s:24:\"advanced-footer-widget-2\";a:0:{}s:24:\"advanced-footer-widget-3\";a:0:{}s:24:\"advanced-footer-widget-4\";a:0:{}}}s:11:\"custom_logo\";s:2:\"74\";}","yes"),
("3020","astra-settings","a:2059:{s:26:\"blog-single-post-structure\";a:2:{i:0;s:12:\"single-image\";i:1;s:17:\"single-title-meta\";}s:17:\"blog-single-width\";s:7:\"default\";s:21:\"blog-single-max-width\";i:1200;s:16:\"blog-single-meta\";a:3:{i:0;s:8:\"comments\";i:1;s:8:\"category\";i:2;s:6:\"author\";}s:19:\"blog-post-structure\";a:5:{i:0;s:5:\"image\";i:1;s:5:\"title\";i:2;s:10:\"title-meta\";i:3;s:7:\"excerpt\";i:4;s:9:\"read-more\";}s:10:\"blog-width\";s:7:\"default\";s:14:\"blog-max-width\";i:1200;s:17:\"blog-post-content\";s:7:\"excerpt\";s:9:\"blog-meta\";a:3:{i:0;s:8:\"comments\";i:1;s:8:\"category\";i:2;s:6:\"author\";}s:10:\"text-color\";s:25:\"var(--ast-global-color-3)\";s:10:\"link-color\";s:25:\"var(--ast-global-color-0)\";s:11:\"theme-color\";s:25:\"var(--ast-global-color-0)\";s:12:\"link-h-color\";s:25:\"var(--ast-global-color-1)\";s:18:\"heading-base-color\";s:25:\"var(--ast-global-color-2)\";s:13:\"footer-bg-obj\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:4:\"none\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:12:\"footer-color\";s:0:\"\";s:17:\"footer-link-color\";s:0:\"\";s:19:\"footer-link-h-color\";s:0:\"\";s:17:\"footer-adv-bg-obj\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:4:\"none\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:21:\"footer-adv-text-color\";s:0:\"\";s:21:\"footer-adv-link-color\";s:0:\"\";s:23:\"footer-adv-link-h-color\";s:0:\"\";s:26:\"footer-adv-wgt-title-color\";s:0:\"\";s:12:\"button-color\";s:25:\"var(--ast-global-color-2)\";s:14:\"button-h-color\";s:25:\"var(--ast-global-color-2)\";s:15:\"button-bg-color\";s:25:\"var(--ast-global-color-0)\";s:17:\"button-bg-h-color\";s:25:\"var(--ast-global-color-1)\";s:20:\"theme-button-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"17\";s:5:\"right\";s:2:\"40\";s:6:\"bottom\";s:2:\"17\";s:4:\"left\";s:2:\"40\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:2:\"16\";s:5:\"right\";s:2:\"32\";s:6:\"bottom\";s:2:\"16\";s:4:\"left\";s:2:\"32\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"15\";s:5:\"right\";s:2:\"28\";s:6:\"bottom\";s:2:\"15\";s:4:\"left\";s:2:\"28\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"button-radius\";i:4;s:37:\"theme-button-border-group-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:17:\"footer-sml-layout\";s:19:\"footer-sml-layout-1\";s:20:\"footer-sml-section-1\";s:6:\"custom\";s:27:\"footer-sml-section-1-credit\";s:72:\"Copyright &copy; [current_year] [site_title] | Powered by [theme_author]\";s:20:\"footer-sml-section-2\";s:0:\"\";s:27:\"footer-sml-section-2-credit\";s:72:\"Copyright &copy; [current_year] [site_title] | Powered by [theme_author]\";s:27:\"footer-sml-dist-equal-align\";b:1;s:18:\"footer-sml-divider\";i:1;s:24:\"footer-sml-divider-color\";s:7:\"#7a7a7a\";s:19:\"footer-layout-width\";s:7:\"content\";s:22:\"ast-header-retina-logo\";s:0:\"\";s:21:\"ast-header-logo-width\";s:0:\"\";s:32:\"ast-header-responsive-logo-width\";a:3:{s:7:\"desktop\";i:60;s:6:\"tablet\";i:60;s:6:\"mobile\";i:50;}s:23:\"header-color-site-title\";s:0:\"\";s:25:\"header-color-h-site-title\";s:0:\"\";s:25:\"header-color-site-tagline\";s:0:\"\";s:29:\"display-site-title-responsive\";a:3:{s:7:\"desktop\";b:0;s:6:\"tablet\";b:0;s:6:\"mobile\";b:0;}s:31:\"display-site-tagline-responsive\";a:3:{s:7:\"desktop\";i:0;s:6:\"tablet\";b:0;s:6:\"mobile\";i:0;}s:17:\"logo-title-inline\";i:1;s:19:\"disable-primary-nav\";b:0;s:14:\"header-layouts\";s:20:\"header-main-layout-1\";s:22:\"header-main-rt-section\";s:4:\"none\";s:27:\"header-display-outside-menu\";b:0;s:27:\"header-main-rt-section-html\";s:27:\"<button>Contact Us</button>\";s:34:\"header-main-rt-section-button-text\";s:6:\"Button\";s:34:\"header-main-rt-section-button-link\";s:23:\"https://www.wpastra.com\";s:41:\"header-main-rt-section-button-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:35:\"header-main-rt-section-button-style\";s:12:\"theme-button\";s:40:\"header-main-rt-section-button-text-color\";s:0:\"\";s:40:\"header-main-rt-section-button-back-color\";s:0:\"\";s:42:\"header-main-rt-section-button-text-h-color\";s:0:\"\";s:42:\"header-main-rt-section-button-back-h-color\";s:0:\"\";s:37:\"header-main-rt-section-button-padding\";a:3:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}}s:41:\"header-main-rt-section-button-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:15:\"header-main-sep\";i:1;s:21:\"header-main-sep-color\";s:0:\"\";s:24:\"header-main-layout-width\";s:7:\"content\";s:22:\"primary-submenu-border\";a:4:{s:3:\"top\";s:1:\"2\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:27:\"primary-submenu-item-border\";b:0;s:23:\"primary-submenu-b-color\";s:0:\"\";s:28:\"primary-submenu-item-b-color\";s:0:\"\";s:33:\"primary-header-button-font-family\";s:7:\"inherit\";s:33:\"primary-header-button-font-weight\";s:7:\"inherit\";s:31:\"primary-header-button-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"primary-header-button-text-transform\";s:0:\"\";s:33:\"primary-header-button-line-height\";i:1;s:36:\"primary-header-button-letter-spacing\";s:0:\"\";s:22:\"header-main-menu-label\";s:0:\"\";s:22:\"header-main-menu-align\";s:6:\"inline\";s:39:\"header-main-submenu-container-animation\";s:0:\"\";s:24:\"mobile-header-breakpoint\";s:0:\"\";s:18:\"mobile-header-logo\";s:0:\"\";s:24:\"mobile-header-logo-width\";s:0:\"\";s:11:\"site-layout\";s:21:\"ast-full-width-layout\";s:18:\"site-content-width\";i:1200;s:37:\"site-layout-outside-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:25:\"content-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:25:\"var(--ast-global-color-4)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:11:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:11:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:19:\"site-content-layout\";s:15:\"boxed-container\";s:26:\"single-page-content-layout\";s:7:\"default\";s:26:\"single-post-content-layout\";s:7:\"default\";s:27:\"archive-post-content-layout\";s:7:\"default\";s:16:\"body-font-family\";s:21:\"\'DM Sans\', sans-serif\";s:17:\"body-font-variant\";s:0:\"\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";d:1.6999999999999999555910790149937383830547332763671875;s:18:\"para-margin-bottom\";i:0;s:23:\"underline-content-links\";b:0;s:19:\"body-text-transform\";s:0:\"\";s:20:\"headings-font-family\";s:21:\"\'DM Sans\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"400\";s:23:\"headings-text-transform\";s:4:\"none\";s:20:\"headings-line-height\";s:0:\"\";s:20:\"font-size-site-title\";a:6:{s:7:\"desktop\";i:35;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"font-size-site-tagline\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"font-size-entry-title\";a:6:{s:7:\"desktop\";i:30;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"font-size-archive-summary-title\";a:6:{s:7:\"desktop\";i:40;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"font-size-page-title\";a:6:{s:7:\"desktop\";i:30;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h1\";a:6:{s:7:\"desktop\";s:2:\"64\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h2\";a:6:{s:7:\"desktop\";i:30;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h3\";a:6:{s:7:\"desktop\";s:2:\"20\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h4\";a:6:{s:7:\"desktop\";s:2:\"35\";s:6:\"tablet\";s:2:\"35\";s:6:\"mobile\";s:2:\"24\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h5\";a:6:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h6\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"site-sidebar-layout\";s:10:\"no-sidebar\";s:18:\"site-sidebar-width\";i:30;s:26:\"single-page-sidebar-layout\";s:7:\"default\";s:26:\"single-post-sidebar-layout\";s:7:\"default\";s:27:\"archive-post-sidebar-layout\";s:7:\"default\";s:10:\"footer-adv\";s:8:\"disabled\";s:23:\"footer-adv-border-width\";s:0:\"\";s:23:\"footer-adv-border-color\";s:7:\"#7a7a7a\";s:30:\"mobile-header-toggle-btn-style\";s:4:\"fill\";s:23:\"hide-custom-menu-mobile\";i:1;s:27:\"mobile-header-toggle-target\";s:4:\"icon\";s:25:\"load-google-fonts-locally\";b:0;s:19:\"preload-local-fonts\";b:0;s:20:\"enable-related-posts\";b:0;s:19:\"related-posts-title\";s:13:\"Related Posts\";s:29:\"releted-posts-title-alignment\";s:4:\"left\";s:25:\"related-posts-total-count\";i:2;s:28:\"enable-related-posts-excerpt\";b:0;s:27:\"related-posts-excerpt-count\";i:25;s:22:\"related-posts-based-on\";s:10:\"categories\";s:22:\"related-posts-order-by\";s:4:\"date\";s:19:\"related-posts-order\";s:3:\"asc\";s:29:\"related-posts-grid-responsive\";a:3:{s:7:\"desktop\";s:7:\"2-equal\";s:6:\"tablet\";s:7:\"2-equal\";s:6:\"mobile\";s:4:\"full\";}s:23:\"related-posts-structure\";a:2:{i:0;s:14:\"featured-image\";i:1;s:10:\"title-meta\";}s:28:\"related-posts-meta-structure\";a:3:{i:0;s:8:\"comments\";i:1;s:8:\"category\";i:2;s:6:\"author\";}s:24:\"related-posts-text-color\";s:0:\"\";s:24:\"related-posts-link-color\";s:0:\"\";s:25:\"related-posts-title-color\";s:0:\"\";s:30:\"related-posts-background-color\";s:0:\"\";s:24:\"related-posts-meta-color\";s:0:\"\";s:30:\"related-posts-link-hover-color\";s:0:\"\";s:35:\"related-posts-meta-link-hover-color\";s:0:\"\";s:39:\"related-posts-section-title-font-family\";s:7:\"inherit\";s:39:\"related-posts-section-title-font-weight\";s:7:\"inherit\";s:42:\"related-posts-section-title-text-transform\";s:0:\"\";s:39:\"related-posts-section-title-line-height\";s:0:\"\";s:37:\"related-posts-section-title-font-size\";a:6:{s:7:\"desktop\";s:2:\"30\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"related-posts-title-font-family\";s:7:\"inherit\";s:31:\"related-posts-title-font-weight\";s:7:\"inherit\";s:34:\"related-posts-title-text-transform\";s:0:\"\";s:31:\"related-posts-title-line-height\";s:1:\"1\";s:29:\"related-posts-title-font-size\";a:6:{s:7:\"desktop\";s:2:\"20\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"related-posts-meta-font-family\";s:7:\"inherit\";s:30:\"related-posts-meta-font-weight\";s:7:\"inherit\";s:33:\"related-posts-meta-text-transform\";s:0:\"\";s:30:\"related-posts-meta-line-height\";s:0:\"\";s:28:\"related-posts-meta-font-size\";a:6:{s:7:\"desktop\";s:2:\"14\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:33:\"related-posts-content-font-family\";s:7:\"inherit\";s:33:\"related-posts-content-font-weight\";s:7:\"inherit\";s:36:\"related-posts-content-text-transform\";s:0:\"\";s:33:\"related-posts-content-line-height\";s:0:\"\";s:31:\"related-posts-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"transparent-header-logo\";s:67:\"https://template.strng.us/wp-content/uploads/2021/11/logo-white.svg\";s:30:\"transparent-header-retina-logo\";s:0:\"\";s:26:\"different-transparent-logo\";b:1;s:33:\"different-transparent-retina-logo\";i:0;s:29:\"transparent-header-logo-width\";a:3:{s:7:\"desktop\";i:60;s:6:\"tablet\";i:60;s:6:\"mobile\";i:50;}s:25:\"transparent-header-enable\";i:0;s:34:\"transparent-header-disable-archive\";i:1;s:45:\"transparent-header-disable-latest-posts-index\";i:1;s:29:\"transparent-header-on-devices\";s:4:\"both\";s:27:\"transparent-header-main-sep\";i:0;s:33:\"transparent-header-main-sep-color\";s:0:\"\";s:27:\"transparent-header-bg-color\";s:0:\"\";s:35:\"transparent-header-color-site-title\";s:0:\"\";s:37:\"transparent-header-color-h-site-title\";s:0:\"\";s:25:\"transparent-menu-bg-color\";s:0:\"\";s:22:\"transparent-menu-color\";s:0:\"\";s:24:\"transparent-menu-h-color\";s:0:\"\";s:28:\"transparent-submenu-bg-color\";s:0:\"\";s:25:\"transparent-submenu-color\";s:0:\"\";s:27:\"transparent-submenu-h-color\";s:0:\"\";s:38:\"transparent-header-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:46:\"transparent-header-color-site-title-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-5)\";s:6:\"tablet\";s:7:\"#ffffff\";s:6:\"mobile\";s:7:\"#ffffff\";}s:48:\"transparent-header-color-h-site-title-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:36:\"transparent-menu-bg-color-responsive\";a:3:{s:7:\"desktop\";s:19:\"rgba(255,255,255,0)\";s:6:\"tablet\";s:7:\"#ffffff\";s:6:\"mobile\";s:7:\"#ffffff\";}s:33:\"transparent-menu-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-4)\";s:6:\"tablet\";s:7:\"#000000\";s:6:\"mobile\";s:7:\"#000000\";}s:35:\"transparent-menu-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-5)\";s:6:\"tablet\";s:25:\"var(--ast-global-color-0)\";s:6:\"mobile\";s:25:\"var(--ast-global-color-0)\";}s:39:\"transparent-submenu-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:36:\"transparent-submenu-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"transparent-submenu-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:49:\"transparent-content-section-text-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:49:\"transparent-content-section-link-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:51:\"transparent-content-section-link-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"breadcrumb-font-family\";s:7:\"inherit\";s:22:\"breadcrumb-font-weight\";s:7:\"inherit\";s:25:\"breadcrumb-text-transform\";s:0:\"\";s:32:\"breadcrumb-text-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"breadcrumb-active-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"breadcrumb-hover-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"breadcrumb-separator-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:19:\"breadcrumb-bg-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:18:\"breadcrumb-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"breadcrumb-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:8:\"h1-color\";s:0:\"\";s:8:\"h2-color\";s:0:\"\";s:8:\"h3-color\";s:0:\"\";s:8:\"h4-color\";s:0:\"\";s:8:\"h5-color\";s:0:\"\";s:8:\"h6-color\";s:0:\"\";s:14:\"font-family-h1\";s:7:\"inherit\";s:14:\"font-weight-h1\";s:7:\"inherit\";s:17:\"text-transform-h1\";s:0:\"\";s:14:\"line-height-h1\";s:0:\"\";s:14:\"font-family-h2\";s:7:\"inherit\";s:14:\"font-weight-h2\";s:7:\"inherit\";s:17:\"text-transform-h2\";s:0:\"\";s:14:\"line-height-h2\";s:0:\"\";s:14:\"font-family-h3\";s:7:\"inherit\";s:14:\"font-weight-h3\";s:7:\"inherit\";s:17:\"text-transform-h3\";s:0:\"\";s:14:\"line-height-h3\";s:0:\"\";s:14:\"font-family-h4\";s:16:\"\'Forum\', display\";s:14:\"font-weight-h4\";s:3:\"400\";s:17:\"text-transform-h4\";s:0:\"\";s:14:\"line-height-h4\";d:1.25;s:14:\"font-family-h5\";s:7:\"inherit\";s:14:\"font-weight-h5\";s:7:\"inherit\";s:17:\"text-transform-h5\";s:0:\"\";s:14:\"line-height-h5\";s:0:\"\";s:14:\"font-family-h6\";s:7:\"inherit\";s:14:\"font-weight-h6\";s:7:\"inherit\";s:17:\"text-transform-h6\";s:0:\"\";s:14:\"line-height-h6\";s:0:\"\";s:18:\"font-weight-button\";s:3:\"400\";s:18:\"font-family-button\";s:7:\"inherit\";s:16:\"font-size-button\";a:6:{s:7:\"desktop\";s:2:\"14\";s:6:\"tablet\";s:2:\"16\";s:6:\"mobile\";s:2:\"14\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"text-transform-button\";s:4:\"none\";s:21:\"theme-btn-line-height\";i:1;s:24:\"theme-btn-letter-spacing\";s:0:\"\";s:20:\"header-desktop-items\";a:5:{s:5:\"popup\";a:1:{s:13:\"popup_content\";a:1:{i:0;s:11:\"mobile-menu\";}}s:5:\"above\";a:5:{s:10:\"above_left\";a:0:{}s:17:\"above_left_center\";a:0:{}s:12:\"above_center\";a:0:{}s:18:\"above_right_center\";a:0:{}s:11:\"above_right\";a:0:{}}s:7:\"primary\";a:5:{s:12:\"primary_left\";a:1:{i:0;s:4:\"logo\";}s:19:\"primary_left_center\";a:0:{}s:14:\"primary_center\";a:0:{}s:20:\"primary_right_center\";a:0:{}s:13:\"primary_right\";a:2:{i:0;s:6:\"menu-1\";i:1;s:8:\"button-1\";}}s:5:\"below\";a:5:{s:10:\"below_left\";a:0:{}s:17:\"below_left_center\";a:0:{}s:12:\"below_center\";a:0:{}s:18:\"below_right_center\";a:0:{}s:11:\"below_right\";a:0:{}}s:4:\"flag\";b:0;}s:19:\"header-mobile-items\";a:5:{s:5:\"popup\";a:1:{s:13:\"popup_content\";a:1:{i:0;s:6:\"menu-1\";}}s:5:\"above\";a:3:{s:10:\"above_left\";a:0:{}s:12:\"above_center\";a:0:{}s:11:\"above_right\";a:0:{}}s:7:\"primary\";a:3:{s:12:\"primary_left\";a:1:{i:0;s:4:\"logo\";}s:14:\"primary_center\";a:0:{}s:13:\"primary_right\";a:1:{i:0;s:14:\"mobile-trigger\";}}s:5:\"below\";a:3:{s:10:\"below_left\";a:0:{}s:12:\"below_center\";a:0:{}s:11:\"below_right\";a:0:{}}s:4:\"flag\";b:0;}s:27:\"hb-header-main-layout-width\";s:7:\"content\";s:16:\"hb-header-height\";a:3:{s:7:\"desktop\";i:70;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:8:\"hb-stack\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:18:\"hb-header-main-sep\";i:0;s:24:\"hb-header-main-sep-color\";s:7:\"#eaeaea\";s:25:\"hb-header-main-menu-align\";s:6:\"inline\";s:27:\"hb-header-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:7:\"#ffffff\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:17:\"hb-header-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:3:\"1.5\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:3:\"1.5\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:17:\"hba-header-layout\";s:21:\"above-header-layout-1\";s:17:\"hba-header-height\";a:3:{s:7:\"desktop\";i:50;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:9:\"hba-stack\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:20:\"hba-header-separator\";i:1;s:30:\"hba-header-bottom-border-color\";s:7:\"#eaeaea\";s:28:\"hba-header-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:9:{s:16:\"background-color\";s:7:\"#ffffff\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:32:\"hba-header-text-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:32:\"hba-header-link-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"hba-header-link-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:18:\"hba-header-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:3:\"0.5\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"em\";}s:17:\"hbb-header-layout\";s:21:\"below-header-layout-1\";s:17:\"hbb-header-height\";a:3:{s:7:\"desktop\";i:60;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:9:\"hbb-stack\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:20:\"hbb-header-separator\";i:1;s:30:\"hbb-header-bottom-border-color\";s:7:\"#eaeaea\";s:28:\"hbb-header-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:9:{s:16:\"background-color\";s:7:\"#eeeeee\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:18:\"hbb-header-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"section-footer-builder-layout-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-footer-builder-layout-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-above-header-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-above-header-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-below-header-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-below-header-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-header-mobile-trigger-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"5\";s:5:\"right\";s:2:\"15\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:1:\"5\";s:5:\"right\";s:2:\"20\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:38:\"section-primary-header-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"section-primary-header-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"10\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:2:\"10\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"title_tagline-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"5\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:2:\"15\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:1:\"5\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:2:\"20\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"section-header-search-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-account-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-mobile-menu-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"5\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"5\";s:4:\"left\";s:1:\"0\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:1:\"5\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:1:\"5\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:33:\"section-header-mobile-menu-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-above-footer-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-above-footer-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-below-footer-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"section-footer-copyright-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:2:\"40\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-footer-menu-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:2:\"40\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:38:\"section-primary-footer-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"30\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:2:\"30\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:2:\"50\";s:5:\"right\";s:2:\"20\";s:6:\"bottom\";s:2:\"30\";s:4:\"left\";s:2:\"20\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"35\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:2:\"35\";s:4:\"left\";s:1:\"0\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"section-primary-footer-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button1-text\";s:12:\"202-555-0188\";s:26:\"header-button1-link-option\";a:3:{s:3:\"url\";s:16:\"tel:202-555-0188\";s:7:\"new_tab\";s:0:\"\";s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button1-font-family\";s:7:\"inherit\";s:26:\"header-button1-font-weight\";s:7:\"inherit\";s:29:\"header-button1-text-transform\";s:0:\"\";s:26:\"header-button1-line-height\";s:0:\"\";s:24:\"header-button1-font-size\";a:6:{s:7:\"desktop\";s:2:\"15\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button1-text-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-4)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button1-back-color\";a:3:{s:7:\"desktop\";s:13:\"rgba(0,0,0,0)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button1-text-h-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-5)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button1-back-h-color\";a:3:{s:7:\"desktop\";s:13:\"rgba(0,0,0,0)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button1-border-size\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";}s:27:\"header-button1-border-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-4)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-button1-border-radius\";i:4;s:27:\"section-hb-button-1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"15\";s:5:\"right\";s:2:\"25\";s:6:\"bottom\";s:2:\"15\";s:4:\"left\";s:2:\"25\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button1-text\";s:6:\"Button\";s:26:\"footer-button1-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button1-font-family\";s:7:\"inherit\";s:26:\"footer-button1-font-weight\";s:7:\"inherit\";s:29:\"footer-button1-text-transform\";s:0:\"\";s:26:\"footer-button1-line-height\";s:0:\"\";s:24:\"footer-button1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button1-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button1-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button1-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button1-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button1-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button1-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-button1-border-radius\";s:0:\"\";s:25:\"footer-button-1-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-1\";s:22:\"Insert HTML text here.\";s:18:\"header-html-1color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-1link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-1link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-1\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-1\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-1\";s:7:\"inherit\";s:29:\"line-height-section-hb-html-1\";s:0:\"\";s:32:\"text-transform-section-hb-html-1\";s:0:\"\";s:24:\"section-hb-html-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-1\";s:180:\"<img class=\"alignnone wp-image-74 size-thumbnail\" src=\"https://websitedemos.net/love-nature-02/wp-content/uploads/sites/988/2021/11/logo-green.svg\" alt=\"\" width=\"60\" height=\"50\" />\";s:18:\"footer-html-1color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-1link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-1link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-1\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-1-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-1\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-1\";s:7:\"inherit\";s:32:\"text-transform-section-fb-html-1\";s:0:\"\";s:29:\"line-height-section-fb-html-1\";s:0:\"\";s:24:\"section-fb-html-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:2:\"30\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:2:\"29\";s:4:\"left\";s:1:\"0\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"15\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:2:\"25\";s:4:\"left\";s:1:\"0\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-1-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-1-bg-space\";s:0:\"\";s:20:\"header-social-1-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-social-1-radius\";s:0:\"\";s:21:\"header-social-1-color\";s:0:\"\";s:23:\"header-social-1-h-color\";s:0:\"\";s:24:\"header-social-1-bg-color\";s:0:\"\";s:26:\"header-social-1-bg-h-color\";s:0:\"\";s:28:\"header-social-1-label-toggle\";b:0;s:26:\"header-social-1-color-type\";s:6:\"custom\";s:35:\"font-size-section-hb-social-icons-1\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-1\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-1-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-1-bg-space\";s:0:\"\";s:20:\"footer-social-1-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-1-radius\";s:0:\"\";s:21:\"footer-social-1-color\";s:0:\"\";s:23:\"footer-social-1-h-color\";s:0:\"\";s:24:\"footer-social-1-bg-color\";s:0:\"\";s:26:\"footer-social-1-bg-h-color\";s:0:\"\";s:28:\"footer-social-1-label-toggle\";b:0;s:26:\"footer-social-1-color-type\";s:6:\"custom\";s:35:\"font-size-section-fb-social-icons-1\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-1\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-1-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-1-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-1-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-1-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-1-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-1-font-family\";s:7:\"inherit\";s:27:\"header-widget-1-font-weight\";s:7:\"inherit\";s:30:\"header-widget-1-text-transform\";s:0:\"\";s:27:\"header-widget-1-line-height\";s:0:\"\";s:25:\"header-widget-1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-1-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-1-content-font-weight\";s:7:\"inherit\";s:38:\"header-widget-1-content-text-transform\";s:0:\"\";s:35:\"header-widget-1-content-line-height\";s:0:\"\";s:33:\"header-widget-1-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:38:\"sidebar-widgets-header-widget-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-1-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-1-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-1-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-1-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-1-font-family\";s:7:\"inherit\";s:27:\"footer-widget-1-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-1-text-transform\";s:0:\"\";s:27:\"footer-widget-1-line-height\";s:0:\"\";s:25:\"footer-widget-1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-1-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-1-content-font-weight\";s:7:\"inherit\";s:38:\"footer-widget-1-content-text-transform\";s:0:\"\";s:35:\"footer-widget-1-content-line-height\";s:0:\"\";s:33:\"footer-widget-1-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-1\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu1-bg-color\";s:0:\"\";s:18:\"header-menu1-color\";s:0:\"\";s:23:\"header-menu1-h-bg-color\";s:0:\"\";s:20:\"header-menu1-h-color\";s:0:\"\";s:23:\"header-menu1-a-bg-color\";s:0:\"\";s:20:\"header-menu1-a-color\";s:0:\"\";s:30:\"header-menu1-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu1-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu1-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu1-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu1-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu1-a-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu1-menu-hover-animation\";s:0:\"\";s:40:\"header-menu1-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu1-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu1-submenu-item-border\";b:0;s:32:\"header-menu1-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu1-submenu-item-b-color\";s:7:\"#eaeaea\";s:34:\"header-menu1-submenu-border-radius\";s:0:\"\";s:31:\"header-menu1-submenu-top-offset\";s:0:\"\";s:26:\"header-menu1-submenu-width\";s:0:\"\";s:27:\"header-menu1-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu1-menu-stack-on-mobile\";b:1;s:22:\"header-menu1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu1-font-weight\";s:7:\"inherit\";s:24:\"header-menu1-font-family\";s:7:\"inherit\";s:27:\"header-menu1-text-transform\";s:0:\"\";s:24:\"header-menu1-line-height\";s:0:\"\";s:27:\"section-hb-divider-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button2-text\";s:6:\"Button\";s:26:\"header-button2-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button2-font-family\";s:7:\"inherit\";s:26:\"header-button2-font-weight\";s:7:\"inherit\";s:29:\"header-button2-text-transform\";s:0:\"\";s:26:\"header-button2-line-height\";s:0:\"\";s:24:\"header-button2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button2-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button2-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button2-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button2-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button2-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button2-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-button2-border-radius\";s:0:\"\";s:27:\"section-hb-button-2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button2-text\";s:6:\"Button\";s:26:\"footer-button2-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button2-font-family\";s:7:\"inherit\";s:26:\"footer-button2-font-weight\";s:7:\"inherit\";s:29:\"footer-button2-text-transform\";s:0:\"\";s:26:\"footer-button2-line-height\";s:0:\"\";s:24:\"footer-button2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button2-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button2-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button2-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button2-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button2-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button2-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-button2-border-radius\";s:0:\"\";s:25:\"footer-button-2-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-2\";s:22:\"Insert HTML text here.\";s:18:\"header-html-2color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-2link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-2link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-2\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-2\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-2\";s:7:\"inherit\";s:29:\"line-height-section-hb-html-2\";s:0:\"\";s:32:\"text-transform-section-hb-html-2\";s:0:\"\";s:24:\"section-hb-html-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-2\";s:85:\"Copyright [copyright] 2022 | [site_title] | <a href=\"https://tyler.com\">Tyler.com</a>\";s:18:\"footer-html-2color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-2link-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-2link-h-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-4)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-2\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-2-alignment\";a:3:{s:7:\"desktop\";s:5:\"right\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-2\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-2\";s:7:\"inherit\";s:32:\"text-transform-section-fb-html-2\";s:0:\"\";s:29:\"line-height-section-fb-html-2\";s:0:\"\";s:24:\"section-fb-html-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:2:\"40\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-2-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-2-bg-space\";s:0:\"\";s:20:\"header-social-2-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-social-2-radius\";s:0:\"\";s:21:\"header-social-2-color\";s:0:\"\";s:23:\"header-social-2-h-color\";s:0:\"\";s:24:\"header-social-2-bg-color\";s:0:\"\";s:26:\"header-social-2-bg-h-color\";s:0:\"\";s:28:\"header-social-2-label-toggle\";b:0;s:26:\"header-social-2-color-type\";s:6:\"custom\";s:35:\"font-size-section-hb-social-icons-2\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-2\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-2-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-2-bg-space\";s:0:\"\";s:20:\"footer-social-2-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-2-radius\";s:0:\"\";s:21:\"footer-social-2-color\";s:0:\"\";s:23:\"footer-social-2-h-color\";s:0:\"\";s:24:\"footer-social-2-bg-color\";s:0:\"\";s:26:\"footer-social-2-bg-h-color\";s:0:\"\";s:28:\"footer-social-2-label-toggle\";b:0;s:26:\"footer-social-2-color-type\";s:6:\"custom\";s:35:\"font-size-section-fb-social-icons-2\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-2\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-2-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-2-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-2-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-2-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-2-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-2-font-family\";s:7:\"inherit\";s:27:\"header-widget-2-font-weight\";s:7:\"inherit\";s:30:\"header-widget-2-text-transform\";s:0:\"\";s:27:\"header-widget-2-line-height\";s:0:\"\";s:25:\"header-widget-2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-2-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-2-content-font-weight\";s:7:\"inherit\";s:38:\"header-widget-2-content-text-transform\";s:0:\"\";s:35:\"header-widget-2-content-line-height\";s:0:\"\";s:33:\"header-widget-2-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:38:\"sidebar-widgets-header-widget-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-2-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-2-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-2-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-2-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-2-font-family\";s:7:\"inherit\";s:27:\"footer-widget-2-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-2-text-transform\";s:0:\"\";s:27:\"footer-widget-2-line-height\";s:0:\"\";s:25:\"footer-widget-2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-2-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-2-content-font-weight\";s:7:\"inherit\";s:38:\"footer-widget-2-content-text-transform\";s:0:\"\";s:35:\"footer-widget-2-content-line-height\";s:0:\"\";s:33:\"footer-widget-2-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-2\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu2-bg-color\";s:0:\"\";s:18:\"header-menu2-color\";s:0:\"\";s:23:\"header-menu2-h-bg-color\";s:0:\"\";s:20:\"header-menu2-h-color\";s:0:\"\";s:23:\"header-menu2-a-bg-color\";s:0:\"\";s:20:\"header-menu2-a-color\";s:0:\"\";s:30:\"header-menu2-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu2-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu2-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu2-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu2-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu2-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu2-menu-hover-animation\";s:0:\"\";s:40:\"header-menu2-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu2-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu2-submenu-item-border\";b:0;s:32:\"header-menu2-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu2-submenu-item-b-color\";s:7:\"#eaeaea\";s:34:\"header-menu2-submenu-border-radius\";s:0:\"\";s:31:\"header-menu2-submenu-top-offset\";s:0:\"\";s:26:\"header-menu2-submenu-width\";s:0:\"\";s:27:\"header-menu2-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu2-menu-stack-on-mobile\";b:1;s:22:\"header-menu2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu2-font-weight\";s:7:\"inherit\";s:24:\"header-menu2-font-family\";s:7:\"inherit\";s:27:\"header-menu2-text-transform\";s:0:\"\";s:24:\"header-menu2-line-height\";s:0:\"\";s:27:\"section-hb-divider-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button3-text\";s:6:\"Button\";s:26:\"header-button3-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button3-font-family\";s:7:\"inherit\";s:26:\"header-button3-font-weight\";s:7:\"inherit\";s:29:\"header-button3-text-transform\";s:0:\"\";s:26:\"header-button3-line-height\";s:0:\"\";s:24:\"header-button3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button3-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button3-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button3-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button3-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button3-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button3-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-button3-border-radius\";s:0:\"\";s:27:\"section-hb-button-3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button3-text\";s:6:\"Button\";s:26:\"footer-button3-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button3-font-family\";s:7:\"inherit\";s:26:\"footer-button3-font-weight\";s:7:\"inherit\";s:29:\"footer-button3-text-transform\";s:0:\"\";s:26:\"footer-button3-line-height\";s:0:\"\";s:24:\"footer-button3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button3-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button3-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button3-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button3-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button3-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button3-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-button3-border-radius\";s:0:\"\";s:25:\"footer-button-3-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-3\";s:22:\"Insert HTML text here.\";s:18:\"header-html-3color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-3link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-3link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-3\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-3\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-3\";s:7:\"inherit\";s:29:\"line-height-section-hb-html-3\";s:0:\"\";s:32:\"text-transform-section-hb-html-3\";s:0:\"\";s:24:\"section-hb-html-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-3\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-3color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-3link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-3link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-3\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-3-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-3\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-3\";s:7:\"inherit\";s:32:\"text-transform-section-fb-html-3\";s:0:\"\";s:29:\"line-height-section-fb-html-3\";s:0:\"\";s:24:\"section-fb-html-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-3-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-3-bg-space\";s:0:\"\";s:20:\"header-social-3-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-social-3-radius\";s:0:\"\";s:21:\"header-social-3-color\";s:0:\"\";s:23:\"header-social-3-h-color\";s:0:\"\";s:24:\"header-social-3-bg-color\";s:0:\"\";s:26:\"header-social-3-bg-h-color\";s:0:\"\";s:28:\"header-social-3-label-toggle\";b:0;s:26:\"header-social-3-color-type\";s:6:\"custom\";s:35:\"font-size-section-hb-social-icons-3\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-3\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-3-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-3-bg-space\";s:0:\"\";s:20:\"footer-social-3-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-3-radius\";s:0:\"\";s:21:\"footer-social-3-color\";s:0:\"\";s:23:\"footer-social-3-h-color\";s:0:\"\";s:24:\"footer-social-3-bg-color\";s:0:\"\";s:26:\"footer-social-3-bg-h-color\";s:0:\"\";s:28:\"footer-social-3-label-toggle\";b:0;s:26:\"footer-social-3-color-type\";s:6:\"custom\";s:35:\"font-size-section-fb-social-icons-3\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-3\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-3-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-3-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-3-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-3-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-3-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-3-font-family\";s:7:\"inherit\";s:27:\"header-widget-3-font-weight\";s:7:\"inherit\";s:30:\"header-widget-3-text-transform\";s:0:\"\";s:27:\"header-widget-3-line-height\";s:0:\"\";s:25:\"header-widget-3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-3-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-3-content-font-weight\";s:7:\"inherit\";s:38:\"header-widget-3-content-text-transform\";s:0:\"\";s:35:\"header-widget-3-content-line-height\";s:0:\"\";s:33:\"header-widget-3-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:38:\"sidebar-widgets-header-widget-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-3-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-3-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-3-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-3-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-3-font-family\";s:7:\"inherit\";s:27:\"footer-widget-3-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-3-text-transform\";s:0:\"\";s:27:\"footer-widget-3-line-height\";s:0:\"\";s:25:\"footer-widget-3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-3-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-3-content-font-weight\";s:7:\"inherit\";s:38:\"footer-widget-3-content-text-transform\";s:0:\"\";s:35:\"footer-widget-3-content-line-height\";s:0:\"\";s:33:\"footer-widget-3-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-3\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu3-bg-color\";s:0:\"\";s:18:\"header-menu3-color\";s:0:\"\";s:23:\"header-menu3-h-bg-color\";s:0:\"\";s:20:\"header-menu3-h-color\";s:0:\"\";s:23:\"header-menu3-a-bg-color\";s:0:\"\";s:20:\"header-menu3-a-color\";s:0:\"\";s:30:\"header-menu3-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"tablet\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"mobile\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}}s:29:\"header-menu3-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu3-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu3-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu3-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu3-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu3-menu-hover-animation\";s:0:\"\";s:40:\"header-menu3-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu3-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu3-submenu-item-border\";b:0;s:32:\"header-menu3-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu3-submenu-item-b-color\";s:7:\"#eaeaea\";s:34:\"header-menu3-submenu-border-radius\";s:0:\"\";s:31:\"header-menu3-submenu-top-offset\";s:0:\"\";s:26:\"header-menu3-submenu-width\";s:0:\"\";s:27:\"header-menu3-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu3-menu-stack-on-mobile\";b:1;s:22:\"header-menu3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu3-font-weight\";s:7:\"inherit\";s:24:\"header-menu3-font-family\";s:7:\"inherit\";s:27:\"header-menu3-text-transform\";s:0:\"\";s:24:\"header-menu3-line-height\";s:0:\"\";s:27:\"section-hb-divider-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button4-text\";s:6:\"Button\";s:26:\"header-button4-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button4-font-family\";s:7:\"inherit\";s:26:\"header-button4-font-weight\";s:7:\"inherit\";s:29:\"header-button4-text-transform\";s:0:\"\";s:26:\"header-button4-line-height\";s:0:\"\";s:24:\"header-button4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button4-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button4-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button4-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button4-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button4-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button4-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-button4-border-radius\";s:0:\"\";s:27:\"section-hb-button-4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button4-text\";s:6:\"Button\";s:26:\"footer-button4-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button4-font-family\";s:7:\"inherit\";s:26:\"footer-button4-font-weight\";s:7:\"inherit\";s:29:\"footer-button4-text-transform\";s:0:\"\";s:26:\"footer-button4-line-height\";s:0:\"\";s:24:\"footer-button4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button4-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button4-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button4-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button4-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button4-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button4-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-button4-border-radius\";s:0:\"\";s:25:\"footer-button-4-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-4\";s:22:\"Insert HTML text here.\";s:18:\"header-html-4color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-4link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-4link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-4\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-4\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-4\";s:7:\"inherit\";s:29:\"line-height-section-hb-html-4\";s:0:\"\";s:32:\"text-transform-section-hb-html-4\";s:0:\"\";s:24:\"section-hb-html-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-4\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-4color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-4link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-4link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-4\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-4-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-4\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-4\";s:7:\"inherit\";s:32:\"text-transform-section-fb-html-4\";s:0:\"\";s:29:\"line-height-section-fb-html-4\";s:0:\"\";s:24:\"section-fb-html-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-4-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-4-bg-space\";s:0:\"\";s:20:\"header-social-4-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-social-4-radius\";s:0:\"\";s:21:\"header-social-4-color\";s:0:\"\";s:23:\"header-social-4-h-color\";s:0:\"\";s:24:\"header-social-4-bg-color\";s:0:\"\";s:26:\"header-social-4-bg-h-color\";s:0:\"\";s:28:\"header-social-4-label-toggle\";b:0;s:26:\"header-social-4-color-type\";s:6:\"custom\";s:35:\"font-size-section-hb-social-icons-4\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-4\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-4-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-4-bg-space\";s:0:\"\";s:20:\"footer-social-4-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-4-radius\";s:0:\"\";s:21:\"footer-social-4-color\";s:0:\"\";s:23:\"footer-social-4-h-color\";s:0:\"\";s:24:\"footer-social-4-bg-color\";s:0:\"\";s:26:\"footer-social-4-bg-h-color\";s:0:\"\";s:28:\"footer-social-4-label-toggle\";b:0;s:26:\"footer-social-4-color-type\";s:6:\"custom\";s:35:\"font-size-section-fb-social-icons-4\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-4\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-4-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-4-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-4-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-4-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-4-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-4-font-family\";s:7:\"inherit\";s:27:\"header-widget-4-font-weight\";s:7:\"inherit\";s:30:\"header-widget-4-text-transform\";s:0:\"\";s:27:\"header-widget-4-line-height\";s:0:\"\";s:25:\"header-widget-4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-4-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-4-content-font-weight\";s:7:\"inherit\";s:38:\"header-widget-4-content-text-transform\";s:0:\"\";s:35:\"header-widget-4-content-line-height\";s:0:\"\";s:33:\"header-widget-4-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:38:\"sidebar-widgets-header-widget-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-4-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-4-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-4-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-4-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-4-font-family\";s:7:\"inherit\";s:27:\"footer-widget-4-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-4-text-transform\";s:0:\"\";s:27:\"footer-widget-4-line-height\";s:0:\"\";s:25:\"footer-widget-4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-4-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-4-content-font-weight\";s:7:\"inherit\";s:38:\"footer-widget-4-content-text-transform\";s:0:\"\";s:35:\"footer-widget-4-content-line-height\";s:0:\"\";s:33:\"footer-widget-4-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-4\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu4-bg-color\";s:0:\"\";s:18:\"header-menu4-color\";s:0:\"\";s:23:\"header-menu4-h-bg-color\";s:0:\"\";s:20:\"header-menu4-h-color\";s:0:\"\";s:23:\"header-menu4-a-bg-color\";s:0:\"\";s:20:\"header-menu4-a-color\";s:0:\"\";s:30:\"header-menu4-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"tablet\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"mobile\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}}s:29:\"header-menu4-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu4-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu4-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu4-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu4-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu4-menu-hover-animation\";s:0:\"\";s:40:\"header-menu4-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu4-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu4-submenu-item-border\";b:0;s:32:\"header-menu4-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu4-submenu-item-b-color\";s:7:\"#eaeaea\";s:34:\"header-menu4-submenu-border-radius\";s:0:\"\";s:31:\"header-menu4-submenu-top-offset\";s:0:\"\";s:26:\"header-menu4-submenu-width\";s:0:\"\";s:27:\"header-menu4-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu4-menu-stack-on-mobile\";b:1;s:22:\"header-menu4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu4-font-weight\";s:7:\"inherit\";s:24:\"header-menu4-font-family\";s:7:\"inherit\";s:27:\"header-menu4-text-transform\";s:0:\"\";s:24:\"header-menu4-line-height\";s:0:\"\";s:27:\"section-hb-divider-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button5-text\";s:6:\"Button\";s:26:\"header-button5-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button5-font-family\";s:7:\"inherit\";s:26:\"header-button5-font-weight\";s:7:\"inherit\";s:29:\"header-button5-text-transform\";s:0:\"\";s:26:\"header-button5-line-height\";s:0:\"\";s:24:\"header-button5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button5-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button5-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button5-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button5-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button5-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button5-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-button5-border-radius\";s:0:\"\";s:27:\"section-hb-button-5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button5-text\";s:6:\"Button\";s:26:\"footer-button5-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button5-font-family\";s:7:\"inherit\";s:26:\"footer-button5-font-weight\";s:7:\"inherit\";s:29:\"footer-button5-text-transform\";s:0:\"\";s:26:\"footer-button5-line-height\";s:0:\"\";s:24:\"footer-button5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button5-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button5-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button5-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button5-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button5-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button5-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-button5-border-radius\";s:0:\"\";s:25:\"footer-button-5-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-5\";s:22:\"Insert HTML text here.\";s:18:\"header-html-5color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-5link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-5link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-5\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-5\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-5\";s:7:\"inherit\";s:29:\"line-height-section-hb-html-5\";s:0:\"\";s:32:\"text-transform-section-hb-html-5\";s:0:\"\";s:24:\"section-hb-html-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-5\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-5color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-5link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-5link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-5\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-5-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-5\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-5\";s:7:\"inherit\";s:32:\"text-transform-section-fb-html-5\";s:0:\"\";s:29:\"line-height-section-fb-html-5\";s:0:\"\";s:24:\"section-fb-html-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-5-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-5-bg-space\";s:0:\"\";s:20:\"header-social-5-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-social-5-radius\";s:0:\"\";s:21:\"header-social-5-color\";s:0:\"\";s:23:\"header-social-5-h-color\";s:0:\"\";s:24:\"header-social-5-bg-color\";s:0:\"\";s:26:\"header-social-5-bg-h-color\";s:0:\"\";s:28:\"header-social-5-label-toggle\";b:0;s:26:\"header-social-5-color-type\";s:6:\"custom\";s:35:\"font-size-section-hb-social-icons-5\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-5\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-5-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-5-bg-space\";s:0:\"\";s:20:\"footer-social-5-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-5-radius\";s:0:\"\";s:21:\"footer-social-5-color\";s:0:\"\";s:23:\"footer-social-5-h-color\";s:0:\"\";s:24:\"footer-social-5-bg-color\";s:0:\"\";s:26:\"footer-social-5-bg-h-color\";s:0:\"\";s:28:\"footer-social-5-label-toggle\";b:0;s:26:\"footer-social-5-color-type\";s:6:\"custom\";s:35:\"font-size-section-fb-social-icons-5\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-5\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-5-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-5-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-5-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-5-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-5-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-5-font-family\";s:7:\"inherit\";s:27:\"header-widget-5-font-weight\";s:7:\"inherit\";s:30:\"header-widget-5-text-transform\";s:0:\"\";s:27:\"header-widget-5-line-height\";s:0:\"\";s:25:\"header-widget-5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-5-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-5-content-font-weight\";s:7:\"inherit\";s:38:\"header-widget-5-content-text-transform\";s:0:\"\";s:35:\"header-widget-5-content-line-height\";s:0:\"\";s:33:\"header-widget-5-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:38:\"sidebar-widgets-header-widget-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-5-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-5-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-5-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-5-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-5-font-family\";s:7:\"inherit\";s:27:\"footer-widget-5-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-5-text-transform\";s:0:\"\";s:27:\"footer-widget-5-line-height\";s:0:\"\";s:25:\"footer-widget-5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-5-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-5-content-font-weight\";s:7:\"inherit\";s:38:\"footer-widget-5-content-text-transform\";s:0:\"\";s:35:\"footer-widget-5-content-line-height\";s:0:\"\";s:33:\"footer-widget-5-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-5\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu5-bg-color\";s:0:\"\";s:18:\"header-menu5-color\";s:0:\"\";s:23:\"header-menu5-h-bg-color\";s:0:\"\";s:20:\"header-menu5-h-color\";s:0:\"\";s:23:\"header-menu5-a-bg-color\";s:0:\"\";s:20:\"header-menu5-a-color\";s:0:\"\";s:30:\"header-menu5-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"tablet\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"mobile\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}}s:29:\"header-menu5-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu5-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu5-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu5-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu5-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu5-menu-hover-animation\";s:0:\"\";s:40:\"header-menu5-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu5-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu5-submenu-item-border\";b:0;s:32:\"header-menu5-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu5-submenu-item-b-color\";s:7:\"#eaeaea\";s:34:\"header-menu5-submenu-border-radius\";s:0:\"\";s:31:\"header-menu5-submenu-top-offset\";s:0:\"\";s:26:\"header-menu5-submenu-width\";s:0:\"\";s:27:\"header-menu5-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu5-menu-stack-on-mobile\";b:1;s:22:\"header-menu5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu5-font-weight\";s:7:\"inherit\";s:24:\"header-menu5-font-family\";s:7:\"inherit\";s:27:\"header-menu5-text-transform\";s:0:\"\";s:24:\"header-menu5-line-height\";s:0:\"\";s:27:\"section-hb-divider-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button6-text\";s:6:\"Button\";s:26:\"header-button6-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button6-font-family\";s:7:\"inherit\";s:26:\"header-button6-font-weight\";s:7:\"inherit\";s:29:\"header-button6-text-transform\";s:0:\"\";s:26:\"header-button6-line-height\";s:0:\"\";s:24:\"header-button6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button6-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button6-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button6-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button6-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button6-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button6-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-button6-border-radius\";s:0:\"\";s:27:\"section-hb-button-6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button6-text\";s:6:\"Button\";s:26:\"footer-button6-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button6-font-family\";s:7:\"inherit\";s:26:\"footer-button6-font-weight\";s:7:\"inherit\";s:29:\"footer-button6-text-transform\";s:0:\"\";s:26:\"footer-button6-line-height\";s:0:\"\";s:24:\"footer-button6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button6-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button6-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button6-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button6-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button6-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button6-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-button6-border-radius\";s:0:\"\";s:25:\"footer-button-6-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-6\";s:22:\"Insert HTML text here.\";s:18:\"header-html-6color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-6link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-6link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-6\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-6\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-6\";s:7:\"inherit\";s:29:\"line-height-section-hb-html-6\";s:0:\"\";s:32:\"text-transform-section-hb-html-6\";s:0:\"\";s:24:\"section-hb-html-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-6\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-6color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-6link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-6link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-6\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-6-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-6\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-6\";s:7:\"inherit\";s:32:\"text-transform-section-fb-html-6\";s:0:\"\";s:29:\"line-height-section-fb-html-6\";s:0:\"\";s:24:\"section-fb-html-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-6-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-6-bg-space\";s:0:\"\";s:20:\"header-social-6-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-social-6-radius\";s:0:\"\";s:21:\"header-social-6-color\";s:0:\"\";s:23:\"header-social-6-h-color\";s:0:\"\";s:24:\"header-social-6-bg-color\";s:0:\"\";s:26:\"header-social-6-bg-h-color\";s:0:\"\";s:28:\"header-social-6-label-toggle\";b:0;s:26:\"header-social-6-color-type\";s:6:\"custom\";s:35:\"font-size-section-hb-social-icons-6\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-6\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-6-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-6-bg-space\";s:0:\"\";s:20:\"footer-social-6-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-6-radius\";s:0:\"\";s:21:\"footer-social-6-color\";s:0:\"\";s:23:\"footer-social-6-h-color\";s:0:\"\";s:24:\"footer-social-6-bg-color\";s:0:\"\";s:26:\"footer-social-6-bg-h-color\";s:0:\"\";s:28:\"footer-social-6-label-toggle\";b:0;s:26:\"footer-social-6-color-type\";s:6:\"custom\";s:35:\"font-size-section-fb-social-icons-6\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-6\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-6-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-6-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-6-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-6-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-6-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-6-font-family\";s:7:\"inherit\";s:27:\"header-widget-6-font-weight\";s:7:\"inherit\";s:30:\"header-widget-6-text-transform\";s:0:\"\";s:27:\"header-widget-6-line-height\";s:0:\"\";s:25:\"header-widget-6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-6-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-6-content-font-weight\";s:7:\"inherit\";s:38:\"header-widget-6-content-text-transform\";s:0:\"\";s:35:\"header-widget-6-content-line-height\";s:0:\"\";s:33:\"header-widget-6-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:38:\"sidebar-widgets-header-widget-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-6-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-6-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-6-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-6-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-6-font-family\";s:7:\"inherit\";s:27:\"footer-widget-6-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-6-text-transform\";s:0:\"\";s:27:\"footer-widget-6-line-height\";s:0:\"\";s:25:\"footer-widget-6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-6-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-6-content-font-weight\";s:7:\"inherit\";s:38:\"footer-widget-6-content-text-transform\";s:0:\"\";s:35:\"footer-widget-6-content-line-height\";s:0:\"\";s:33:\"footer-widget-6-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-6\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu6-bg-color\";s:0:\"\";s:18:\"header-menu6-color\";s:0:\"\";s:23:\"header-menu6-h-bg-color\";s:0:\"\";s:20:\"header-menu6-h-color\";s:0:\"\";s:23:\"header-menu6-a-bg-color\";s:0:\"\";s:20:\"header-menu6-a-color\";s:0:\"\";s:30:\"header-menu6-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"tablet\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"mobile\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}}s:29:\"header-menu6-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu6-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu6-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu6-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu6-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu6-menu-hover-animation\";s:0:\"\";s:40:\"header-menu6-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu6-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu6-submenu-item-border\";b:0;s:32:\"header-menu6-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu6-submenu-item-b-color\";s:7:\"#eaeaea\";s:34:\"header-menu6-submenu-border-radius\";s:0:\"\";s:31:\"header-menu6-submenu-top-offset\";s:0:\"\";s:26:\"header-menu6-submenu-width\";s:0:\"\";s:27:\"header-menu6-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu6-menu-stack-on-mobile\";b:1;s:22:\"header-menu6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu6-font-weight\";s:7:\"inherit\";s:24:\"header-menu6-font-family\";s:7:\"inherit\";s:27:\"header-menu6-text-transform\";s:0:\"\";s:24:\"header-menu6-line-height\";s:0:\"\";s:27:\"section-hb-divider-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button7-text\";s:6:\"Button\";s:26:\"header-button7-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button7-font-family\";s:7:\"inherit\";s:26:\"header-button7-font-weight\";s:7:\"inherit\";s:29:\"header-button7-text-transform\";s:0:\"\";s:26:\"header-button7-line-height\";s:0:\"\";s:24:\"header-button7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button7-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button7-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button7-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button7-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button7-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button7-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-button7-border-radius\";s:0:\"\";s:27:\"section-hb-button-7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button7-text\";s:6:\"Button\";s:26:\"footer-button7-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button7-font-family\";s:7:\"inherit\";s:26:\"footer-button7-font-weight\";s:7:\"inherit\";s:29:\"footer-button7-text-transform\";s:0:\"\";s:26:\"footer-button7-line-height\";s:0:\"\";s:24:\"footer-button7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button7-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button7-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button7-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button7-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button7-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button7-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-button7-border-radius\";s:0:\"\";s:25:\"footer-button-7-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-7\";s:22:\"Insert HTML text here.\";s:18:\"header-html-7color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-7link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-7link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-7\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-7\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-7\";s:7:\"inherit\";s:29:\"line-height-section-hb-html-7\";s:0:\"\";s:32:\"text-transform-section-hb-html-7\";s:0:\"\";s:24:\"section-hb-html-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-7\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-7color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-7link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-7link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-7\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-7-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-7\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-7\";s:7:\"inherit\";s:32:\"text-transform-section-fb-html-7\";s:0:\"\";s:29:\"line-height-section-fb-html-7\";s:0:\"\";s:24:\"section-fb-html-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-7-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-7-bg-space\";s:0:\"\";s:20:\"header-social-7-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-social-7-radius\";s:0:\"\";s:21:\"header-social-7-color\";s:0:\"\";s:23:\"header-social-7-h-color\";s:0:\"\";s:24:\"header-social-7-bg-color\";s:0:\"\";s:26:\"header-social-7-bg-h-color\";s:0:\"\";s:28:\"header-social-7-label-toggle\";b:0;s:26:\"header-social-7-color-type\";s:6:\"custom\";s:35:\"font-size-section-hb-social-icons-7\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-7\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-7-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-7-bg-space\";s:0:\"\";s:20:\"footer-social-7-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-7-radius\";s:0:\"\";s:21:\"footer-social-7-color\";s:0:\"\";s:23:\"footer-social-7-h-color\";s:0:\"\";s:24:\"footer-social-7-bg-color\";s:0:\"\";s:26:\"footer-social-7-bg-h-color\";s:0:\"\";s:28:\"footer-social-7-label-toggle\";b:0;s:26:\"footer-social-7-color-type\";s:6:\"custom\";s:35:\"font-size-section-fb-social-icons-7\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-7\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-7-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-7-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-7-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-7-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-7-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-7-font-family\";s:7:\"inherit\";s:27:\"header-widget-7-font-weight\";s:7:\"inherit\";s:30:\"header-widget-7-text-transform\";s:0:\"\";s:27:\"header-widget-7-line-height\";s:0:\"\";s:25:\"header-widget-7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-7-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-7-content-font-weight\";s:7:\"inherit\";s:38:\"header-widget-7-content-text-transform\";s:0:\"\";s:35:\"header-widget-7-content-line-height\";s:0:\"\";s:33:\"header-widget-7-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:38:\"sidebar-widgets-header-widget-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-7-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-7-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-7-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-7-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-7-font-family\";s:7:\"inherit\";s:27:\"footer-widget-7-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-7-text-transform\";s:0:\"\";s:27:\"footer-widget-7-line-height\";s:0:\"\";s:25:\"footer-widget-7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-7-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-7-content-font-weight\";s:7:\"inherit\";s:38:\"footer-widget-7-content-text-transform\";s:0:\"\";s:35:\"footer-widget-7-content-line-height\";s:0:\"\";s:33:\"footer-widget-7-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-7\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu7-bg-color\";s:0:\"\";s:18:\"header-menu7-color\";s:0:\"\";s:23:\"header-menu7-h-bg-color\";s:0:\"\";s:20:\"header-menu7-h-color\";s:0:\"\";s:23:\"header-menu7-a-bg-color\";s:0:\"\";s:20:\"header-menu7-a-color\";s:0:\"\";s:30:\"header-menu7-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"tablet\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"mobile\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}}s:29:\"header-menu7-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu7-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu7-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu7-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu7-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu7-menu-hover-animation\";s:0:\"\";s:40:\"header-menu7-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu7-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu7-submenu-item-border\";b:0;s:32:\"header-menu7-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu7-submenu-item-b-color\";s:7:\"#eaeaea\";s:34:\"header-menu7-submenu-border-radius\";s:0:\"\";s:31:\"header-menu7-submenu-top-offset\";s:0:\"\";s:26:\"header-menu7-submenu-width\";s:0:\"\";s:27:\"header-menu7-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu7-menu-stack-on-mobile\";b:1;s:22:\"header-menu7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu7-font-weight\";s:7:\"inherit\";s:24:\"header-menu7-font-family\";s:7:\"inherit\";s:27:\"header-menu7-text-transform\";s:0:\"\";s:24:\"header-menu7-line-height\";s:0:\"\";s:27:\"section-hb-divider-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button8-text\";s:6:\"Button\";s:26:\"header-button8-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button8-font-family\";s:7:\"inherit\";s:26:\"header-button8-font-weight\";s:7:\"inherit\";s:29:\"header-button8-text-transform\";s:0:\"\";s:26:\"header-button8-line-height\";s:0:\"\";s:24:\"header-button8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button8-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button8-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button8-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button8-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button8-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button8-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-button8-border-radius\";s:0:\"\";s:27:\"section-hb-button-8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button8-text\";s:6:\"Button\";s:26:\"footer-button8-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button8-font-family\";s:7:\"inherit\";s:26:\"footer-button8-font-weight\";s:7:\"inherit\";s:29:\"footer-button8-text-transform\";s:0:\"\";s:26:\"footer-button8-line-height\";s:0:\"\";s:24:\"footer-button8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button8-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button8-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button8-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button8-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button8-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button8-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-button8-border-radius\";s:0:\"\";s:25:\"footer-button-8-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-8\";s:22:\"Insert HTML text here.\";s:18:\"header-html-8color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-8link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-8link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-8\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-8\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-8\";s:7:\"inherit\";s:29:\"line-height-section-hb-html-8\";s:0:\"\";s:32:\"text-transform-section-hb-html-8\";s:0:\"\";s:24:\"section-hb-html-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-8\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-8color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-8link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-8link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-8\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-8-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-8\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-8\";s:7:\"inherit\";s:32:\"text-transform-section-fb-html-8\";s:0:\"\";s:29:\"line-height-section-fb-html-8\";s:0:\"\";s:24:\"section-fb-html-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-8-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-8-bg-space\";s:0:\"\";s:20:\"header-social-8-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-social-8-radius\";s:0:\"\";s:21:\"header-social-8-color\";s:0:\"\";s:23:\"header-social-8-h-color\";s:0:\"\";s:24:\"header-social-8-bg-color\";s:0:\"\";s:26:\"header-social-8-bg-h-color\";s:0:\"\";s:28:\"header-social-8-label-toggle\";b:0;s:26:\"header-social-8-color-type\";s:6:\"custom\";s:35:\"font-size-section-hb-social-icons-8\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-8\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-8-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-8-bg-space\";s:0:\"\";s:20:\"footer-social-8-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-8-radius\";s:0:\"\";s:21:\"footer-social-8-color\";s:0:\"\";s:23:\"footer-social-8-h-color\";s:0:\"\";s:24:\"footer-social-8-bg-color\";s:0:\"\";s:26:\"footer-social-8-bg-h-color\";s:0:\"\";s:28:\"footer-social-8-label-toggle\";b:0;s:26:\"footer-social-8-color-type\";s:6:\"custom\";s:35:\"font-size-section-fb-social-icons-8\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-8\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-8-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-8-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-8-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-8-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-8-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-8-font-family\";s:7:\"inherit\";s:27:\"header-widget-8-font-weight\";s:7:\"inherit\";s:30:\"header-widget-8-text-transform\";s:0:\"\";s:27:\"header-widget-8-line-height\";s:0:\"\";s:25:\"header-widget-8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-8-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-8-content-font-weight\";s:7:\"inherit\";s:38:\"header-widget-8-content-text-transform\";s:0:\"\";s:35:\"header-widget-8-content-line-height\";s:0:\"\";s:33:\"header-widget-8-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:38:\"sidebar-widgets-header-widget-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-8-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-8-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-8-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-8-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-8-font-family\";s:7:\"inherit\";s:27:\"footer-widget-8-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-8-text-transform\";s:0:\"\";s:27:\"footer-widget-8-line-height\";s:0:\"\";s:25:\"footer-widget-8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-8-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-8-content-font-weight\";s:7:\"inherit\";s:38:\"footer-widget-8-content-text-transform\";s:0:\"\";s:35:\"footer-widget-8-content-line-height\";s:0:\"\";s:33:\"footer-widget-8-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-8\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu8-bg-color\";s:0:\"\";s:18:\"header-menu8-color\";s:0:\"\";s:23:\"header-menu8-h-bg-color\";s:0:\"\";s:20:\"header-menu8-h-color\";s:0:\"\";s:23:\"header-menu8-a-bg-color\";s:0:\"\";s:20:\"header-menu8-a-color\";s:0:\"\";s:30:\"header-menu8-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"tablet\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"mobile\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}}s:29:\"header-menu8-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu8-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu8-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu8-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu8-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu8-menu-hover-animation\";s:0:\"\";s:40:\"header-menu8-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu8-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu8-submenu-item-border\";b:0;s:32:\"header-menu8-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu8-submenu-item-b-color\";s:7:\"#eaeaea\";s:34:\"header-menu8-submenu-border-radius\";s:0:\"\";s:31:\"header-menu8-submenu-top-offset\";s:0:\"\";s:26:\"header-menu8-submenu-width\";s:0:\"\";s:27:\"header-menu8-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu8-menu-stack-on-mobile\";b:1;s:22:\"header-menu8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu8-font-weight\";s:7:\"inherit\";s:24:\"header-menu8-font-family\";s:7:\"inherit\";s:27:\"header-menu8-text-transform\";s:0:\"\";s:24:\"header-menu8-line-height\";s:0:\"\";s:27:\"section-hb-divider-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button9-text\";s:6:\"Button\";s:26:\"header-button9-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button9-font-family\";s:7:\"inherit\";s:26:\"header-button9-font-weight\";s:7:\"inherit\";s:29:\"header-button9-text-transform\";s:0:\"\";s:26:\"header-button9-line-height\";s:0:\"\";s:24:\"header-button9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button9-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button9-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button9-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button9-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button9-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button9-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-button9-border-radius\";s:0:\"\";s:27:\"section-hb-button-9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button9-text\";s:6:\"Button\";s:26:\"footer-button9-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button9-font-family\";s:7:\"inherit\";s:26:\"footer-button9-font-weight\";s:7:\"inherit\";s:29:\"footer-button9-text-transform\";s:0:\"\";s:26:\"footer-button9-line-height\";s:0:\"\";s:24:\"footer-button9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button9-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button9-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button9-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button9-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button9-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button9-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-button9-border-radius\";s:0:\"\";s:25:\"footer-button-9-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-9\";s:22:\"Insert HTML text here.\";s:18:\"header-html-9color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-9link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-9link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-9\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-9\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-9\";s:7:\"inherit\";s:29:\"line-height-section-hb-html-9\";s:0:\"\";s:32:\"text-transform-section-hb-html-9\";s:0:\"\";s:24:\"section-hb-html-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-9\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-9color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-9link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-9link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-9\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-9-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-9\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-9\";s:7:\"inherit\";s:32:\"text-transform-section-fb-html-9\";s:0:\"\";s:29:\"line-height-section-fb-html-9\";s:0:\"\";s:24:\"section-fb-html-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-9-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-9-bg-space\";s:0:\"\";s:20:\"header-social-9-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-social-9-radius\";s:0:\"\";s:21:\"header-social-9-color\";s:0:\"\";s:23:\"header-social-9-h-color\";s:0:\"\";s:24:\"header-social-9-bg-color\";s:0:\"\";s:26:\"header-social-9-bg-h-color\";s:0:\"\";s:28:\"header-social-9-label-toggle\";b:0;s:26:\"header-social-9-color-type\";s:6:\"custom\";s:35:\"font-size-section-hb-social-icons-9\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-9\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-9-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-9-bg-space\";s:0:\"\";s:20:\"footer-social-9-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-9-radius\";s:0:\"\";s:21:\"footer-social-9-color\";s:0:\"\";s:23:\"footer-social-9-h-color\";s:0:\"\";s:24:\"footer-social-9-bg-color\";s:0:\"\";s:26:\"footer-social-9-bg-h-color\";s:0:\"\";s:28:\"footer-social-9-label-toggle\";b:0;s:26:\"footer-social-9-color-type\";s:6:\"custom\";s:35:\"font-size-section-fb-social-icons-9\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-9\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-9-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-9-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-9-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-9-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-9-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-9-font-family\";s:7:\"inherit\";s:27:\"header-widget-9-font-weight\";s:7:\"inherit\";s:30:\"header-widget-9-text-transform\";s:0:\"\";s:27:\"header-widget-9-line-height\";s:0:\"\";s:25:\"header-widget-9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-9-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-9-content-font-weight\";s:7:\"inherit\";s:38:\"header-widget-9-content-text-transform\";s:0:\"\";s:35:\"header-widget-9-content-line-height\";s:0:\"\";s:33:\"header-widget-9-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:38:\"sidebar-widgets-header-widget-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-9-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-9-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-9-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-9-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-9-font-family\";s:7:\"inherit\";s:27:\"footer-widget-9-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-9-text-transform\";s:0:\"\";s:27:\"footer-widget-9-line-height\";s:0:\"\";s:25:\"footer-widget-9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-9-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-9-content-font-weight\";s:7:\"inherit\";s:38:\"footer-widget-9-content-text-transform\";s:0:\"\";s:35:\"footer-widget-9-content-line-height\";s:0:\"\";s:33:\"footer-widget-9-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-9\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:38:\"sidebar-widgets-footer-widget-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu9-bg-color\";s:0:\"\";s:18:\"header-menu9-color\";s:0:\"\";s:23:\"header-menu9-h-bg-color\";s:0:\"\";s:20:\"header-menu9-h-color\";s:0:\"\";s:23:\"header-menu9-a-bg-color\";s:0:\"\";s:20:\"header-menu9-a-color\";s:0:\"\";s:30:\"header-menu9-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"tablet\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"mobile\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}}s:29:\"header-menu9-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu9-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu9-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu9-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu9-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu9-menu-hover-animation\";s:0:\"\";s:40:\"header-menu9-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu9-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu9-submenu-item-border\";b:0;s:32:\"header-menu9-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu9-submenu-item-b-color\";s:7:\"#eaeaea\";s:34:\"header-menu9-submenu-border-radius\";s:0:\"\";s:31:\"header-menu9-submenu-top-offset\";s:0:\"\";s:26:\"header-menu9-submenu-width\";s:0:\"\";s:27:\"header-menu9-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu9-menu-stack-on-mobile\";b:1;s:22:\"header-menu9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu9-font-weight\";s:7:\"inherit\";s:24:\"header-menu9-font-family\";s:7:\"inherit\";s:27:\"header-menu9-text-transform\";s:0:\"\";s:24:\"header-menu9-line-height\";s:0:\"\";s:27:\"section-hb-divider-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"header-button10-text\";s:6:\"Button\";s:27:\"header-button10-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:27:\"header-button10-font-family\";s:7:\"inherit\";s:27:\"header-button10-font-weight\";s:7:\"inherit\";s:30:\"header-button10-text-transform\";s:0:\"\";s:27:\"header-button10-line-height\";s:0:\"\";s:25:\"header-button10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button10-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-button10-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-button10-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-button10-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-button10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-button10-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:28:\"header-button10-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-button10-border-radius\";s:0:\"\";s:28:\"section-hb-button-10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-hb-button-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"sticky-header-button10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"footer-button10-text\";s:6:\"Button\";s:27:\"footer-button10-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:27:\"footer-button10-font-family\";s:7:\"inherit\";s:27:\"footer-button10-font-weight\";s:7:\"inherit\";s:30:\"footer-button10-text-transform\";s:0:\"\";s:27:\"footer-button10-line-height\";s:0:\"\";s:25:\"footer-button10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button10-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-button10-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-button10-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-button10-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-button10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-button10-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:28:\"footer-button10-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"footer-button10-border-radius\";s:0:\"\";s:26:\"footer-button-10-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:28:\"section-fb-button-10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-button-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:14:\"header-html-10\";s:22:\"Insert HTML text here.\";s:19:\"header-html-10color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-html-10link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-html-10link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"font-size-section-hb-html-10\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"font-weight-section-hb-html-10\";s:7:\"inherit\";s:30:\"font-family-section-hb-html-10\";s:7:\"inherit\";s:30:\"line-height-section-hb-html-10\";s:0:\"\";s:33:\"text-transform-section-hb-html-10\";s:0:\"\";s:25:\"section-hb-html-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:14:\"footer-html-10\";s:22:\"Insert HTML text here.\";s:19:\"footer-html-10color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-html-10link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-html-10link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"font-size-section-fb-html-10\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"footer-html-10-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:30:\"font-weight-section-fb-html-10\";s:7:\"inherit\";s:30:\"font-family-section-fb-html-10\";s:7:\"inherit\";s:33:\"text-transform-section-fb-html-10\";s:0:\"\";s:30:\"line-height-section-fb-html-10\";s:0:\"\";s:25:\"section-fb-html-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"header-social-10-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-social-10-bg-space\";s:0:\"\";s:21:\"header-social-10-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-social-10-radius\";s:0:\"\";s:22:\"header-social-10-color\";s:0:\"\";s:24:\"header-social-10-h-color\";s:0:\"\";s:25:\"header-social-10-bg-color\";s:0:\"\";s:27:\"header-social-10-bg-h-color\";s:0:\"\";s:29:\"header-social-10-label-toggle\";b:0;s:27:\"header-social-10-color-type\";s:6:\"custom\";s:36:\"font-size-section-hb-social-icons-10\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"header-social-icons-10\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:33:\"section-hb-social-icons-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"footer-social-10-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-social-10-bg-space\";s:0:\"\";s:21:\"footer-social-10-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-social-10-radius\";s:0:\"\";s:22:\"footer-social-10-color\";s:0:\"\";s:24:\"footer-social-10-h-color\";s:0:\"\";s:25:\"footer-social-10-bg-color\";s:0:\"\";s:27:\"footer-social-10-bg-h-color\";s:0:\"\";s:29:\"footer-social-10-label-toggle\";b:0;s:27:\"footer-social-10-color-type\";s:6:\"custom\";s:36:\"font-size-section-fb-social-icons-10\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"footer-social-icons-10\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:26:\"footer-social-10-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:33:\"section-fb-social-icons-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-widget-10-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-widget-10-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-10-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-widget-10-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-10-font-family\";s:7:\"inherit\";s:28:\"header-widget-10-font-weight\";s:7:\"inherit\";s:31:\"header-widget-10-text-transform\";s:0:\"\";s:28:\"header-widget-10-line-height\";s:0:\"\";s:26:\"header-widget-10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"header-widget-10-content-font-family\";s:7:\"inherit\";s:36:\"header-widget-10-content-font-weight\";s:7:\"inherit\";s:39:\"header-widget-10-content-text-transform\";s:0:\"\";s:36:\"header-widget-10-content-line-height\";s:0:\"\";s:34:\"header-widget-10-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:39:\"sidebar-widgets-header-widget-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"footer-widget-10-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-widget-10-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-10-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"footer-widget-10-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-10-font-family\";s:7:\"inherit\";s:28:\"footer-widget-10-font-weight\";s:7:\"inherit\";s:31:\"footer-widget-10-text-transform\";s:0:\"\";s:28:\"footer-widget-10-line-height\";s:0:\"\";s:26:\"footer-widget-10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"footer-widget-10-content-font-family\";s:7:\"inherit\";s:36:\"footer-widget-10-content-font-weight\";s:7:\"inherit\";s:39:\"footer-widget-10-content-text-transform\";s:0:\"\";s:36:\"footer-widget-10-content-line-height\";s:0:\"\";s:34:\"footer-widget-10-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-widget-alignment-10\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:39:\"sidebar-widgets-footer-widget-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"header-menu10-bg-color\";s:0:\"\";s:19:\"header-menu10-color\";s:0:\"\";s:24:\"header-menu10-h-bg-color\";s:0:\"\";s:21:\"header-menu10-h-color\";s:0:\"\";s:24:\"header-menu10-a-bg-color\";s:0:\"\";s:21:\"header-menu10-a-color\";s:0:\"\";s:31:\"header-menu10-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"tablet\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"mobile\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}}s:30:\"header-menu10-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-menu10-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:32:\"header-menu10-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-menu10-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:32:\"header-menu10-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu10-menu-hover-animation\";s:0:\"\";s:41:\"header-menu10-submenu-container-animation\";s:0:\"\";s:25:\"section-hb-menu-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-menu10-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:33:\"header-menu10-submenu-item-border\";b:0;s:33:\"header-menu10-submenu-item-b-size\";s:1:\"1\";s:34:\"header-menu10-submenu-item-b-color\";s:7:\"#eaeaea\";s:35:\"header-menu10-submenu-border-radius\";s:0:\"\";s:32:\"header-menu10-submenu-top-offset\";s:0:\"\";s:27:\"header-menu10-submenu-width\";s:0:\"\";s:28:\"header-menu10-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:34:\"header-menu10-menu-stack-on-mobile\";b:1;s:23:\"header-menu10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu10-font-weight\";s:7:\"inherit\";s:25:\"header-menu10-font-family\";s:7:\"inherit\";s:28:\"header-menu10-text-transform\";s:0:\"\";s:25:\"header-menu10-line-height\";s:0:\"\";s:28:\"section-hb-divider-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"section-fb-divider-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"sticky-header-on-devices\";s:7:\"desktop\";s:19:\"sticky-header-style\";s:4:\"none\";s:20:\"footer-desktop-items\";a:10:{s:5:\"above\";a:6:{s:7:\"above_1\";a:0:{}s:7:\"above_2\";a:0:{}s:7:\"above_3\";a:0:{}s:7:\"above_4\";a:0:{}s:7:\"above_5\";a:0:{}s:7:\"above_6\";a:0:{}}s:7:\"primary\";a:6:{s:9:\"primary_1\";a:1:{i:0;s:4:\"menu\";}s:9:\"primary_2\";a:1:{i:0;s:6:\"html-1\";}s:9:\"primary_3\";a:1:{i:0;s:9:\"copyright\";}s:9:\"primary_4\";a:0:{}s:9:\"primary_5\";a:0:{}s:9:\"primary_6\";a:0:{}}s:5:\"below\";a:6:{s:7:\"below_1\";a:0:{}s:7:\"below_2\";a:0:{}s:7:\"below_3\";a:0:{}s:7:\"below_4\";a:0:{}s:7:\"below_5\";a:0:{}s:7:\"below_6\";a:0:{}}s:5:\"popup\";a:1:{s:13:\"popup_content\";a:0:{}}s:4:\"flag\";b:1;s:5:\"group\";s:36:\"astra-settings[footer-desktop-items]\";s:4:\"rows\";a:3:{i:0;s:5:\"above\";i:1;s:7:\"primary\";i:2;s:5:\"below\";}s:5:\"zones\";a:3:{s:5:\"above\";a:6:{s:7:\"above_1\";s:15:\"Above Section 1\";s:7:\"above_2\";s:15:\"Above Section 2\";s:7:\"above_3\";s:15:\"Above Section 3\";s:7:\"above_4\";s:15:\"Above Section 4\";s:7:\"above_5\";s:15:\"Above Section 5\";s:7:\"above_6\";s:15:\"Above Section 6\";}s:7:\"primary\";a:6:{s:9:\"primary_1\";s:17:\"Primary Section 1\";s:9:\"primary_2\";s:17:\"Primary Section 2\";s:9:\"primary_3\";s:17:\"Primary Section 3\";s:9:\"primary_4\";s:17:\"Primary Section 4\";s:9:\"primary_5\";s:17:\"Primary Section 5\";s:9:\"primary_6\";s:17:\"Primary Section 6\";}s:5:\"below\";a:6:{s:7:\"below_1\";s:15:\"Below Section 1\";s:7:\"below_2\";s:15:\"Below Section 2\";s:7:\"below_3\";s:15:\"Below Section 3\";s:7:\"below_4\";s:15:\"Below Section 4\";s:7:\"below_5\";s:15:\"Below Section 5\";s:7:\"below_6\";s:15:\"Below Section 6\";}}s:7:\"layouts\";a:3:{s:5:\"above\";a:2:{s:6:\"column\";s:1:\"2\";s:6:\"layout\";a:3:{s:7:\"desktop\";s:7:\"2-equal\";s:6:\"tablet\";s:7:\"2-equal\";s:6:\"mobile\";s:4:\"full\";}}s:7:\"primary\";a:2:{s:6:\"column\";s:1:\"3\";s:6:\"layout\";a:3:{s:6:\"mobile\";s:4:\"full\";s:6:\"tablet\";s:4:\"full\";s:7:\"desktop\";s:7:\"3-equal\";}}s:5:\"below\";a:2:{s:6:\"column\";s:1:\"1\";s:6:\"layout\";a:3:{s:7:\"desktop\";s:4:\"full\";s:6:\"tablet\";s:4:\"full\";s:6:\"mobile\";s:4:\"full\";}}}s:6:\"status\";a:3:{s:5:\"above\";b:1;s:7:\"primary\";b:1;s:5:\"below\";b:1;}}s:17:\"hba-footer-height\";i:60;s:17:\"hba-footer-column\";s:1:\"2\";s:17:\"hba-footer-layout\";a:3:{s:7:\"desktop\";s:7:\"2-equal\";s:6:\"tablet\";s:7:\"2-equal\";s:6:\"mobile\";s:4:\"full\";}s:28:\"hba-footer-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:9:{s:16:\"background-color\";s:7:\"#eeeeee\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:28:\"hbb-footer-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:9:{s:16:\"background-color\";s:7:\"#eeeeee\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:27:\"hb-footer-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:36:\"section-header-builder-layout-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:17:\"hbb-footer-height\";i:80;s:17:\"hbb-footer-column\";s:1:\"1\";s:17:\"hbb-footer-layout\";a:3:{s:7:\"desktop\";s:4:\"full\";s:6:\"tablet\";s:4:\"full\";s:6:\"mobile\";s:4:\"full\";}s:23:\"hba-footer-layout-width\";s:7:\"content\";s:22:\"hb-footer-layout-width\";s:7:\"content\";s:23:\"hbb-footer-layout-width\";s:7:\"content\";s:29:\"hba-footer-vertical-alignment\";s:10:\"flex-start\";s:28:\"hb-footer-vertical-alignment\";s:6:\"center\";s:29:\"hbb-footer-vertical-alignment\";s:10:\"flex-start\";s:24:\"footer-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:16:\"hb-footer-column\";s:1:\"3\";s:19:\"hb-footer-separator\";i:1;s:29:\"hb-footer-bottom-border-color\";s:7:\"#e6e6e6\";s:16:\"hb-footer-layout\";a:4:{s:7:\"desktop\";s:7:\"3-equal\";s:6:\"tablet\";s:4:\"full\";s:6:\"mobile\";s:4:\"full\";s:4:\"flag\";b:1;}s:18:\"hb-footer-main-sep\";i:0;s:24:\"hb-footer-main-sep-color\";s:7:\"#e6e6e6\";s:23:\"footer-copyright-editor\";s:26:\"Love Nature by Tyler Moore\";s:22:\"footer-copyright-color\";s:25:\"var(--ast-global-color-2)\";s:36:\"line-height-section-footer-copyright\";s:0:\"\";s:26:\"footer-copyright-alignment\";a:3:{s:7:\"desktop\";s:5:\"right\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:34:\"font-size-section-footer-copyright\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"font-weight-section-footer-copyright\";s:7:\"inherit\";s:36:\"font-family-section-footer-copyright\";s:7:\"inherit\";s:39:\"text-transform-section-footer-copyright\";s:0:\"\";s:21:\"footer-menu-alignment\";a:3:{s:7:\"desktop\";s:10:\"flex-start\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:36:\"section-below-footer-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-search-icon-space\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";i:18;s:6:\"mobile\";i:18;}s:24:\"header-search-icon-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:37:\"transparent-header-social-icons-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:39:\"transparent-header-social-icons-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:40:\"transparent-header-social-icons-bg-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:42:\"transparent-header-social-icons-bg-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"transparent-header-html-text-color\";s:0:\"\";s:34:\"transparent-header-html-link-color\";s:0:\"\";s:36:\"transparent-header-html-link-h-color\";s:0:\"\";s:37:\"transparent-header-widget-title-color\";s:0:\"\";s:39:\"transparent-header-widget-content-color\";s:0:\"\";s:36:\"transparent-header-widget-link-color\";s:0:\"\";s:38:\"transparent-header-widget-link-h-color\";s:0:\"\";s:36:\"transparent-header-button-text-color\";s:0:\"\";s:38:\"transparent-header-button-text-h-color\";s:0:\"\";s:34:\"transparent-header-button-bg-color\";s:0:\"\";s:36:\"transparent-header-button-bg-h-color\";s:0:\"\";s:17:\"off-canvas-layout\";s:10:\"side-panel\";s:16:\"off-canvas-slide\";s:5:\"right\";s:33:\"header-builder-menu-toggle-target\";s:4:\"icon\";s:34:\"header-offcanvas-content-alignment\";s:10:\"flex-start\";s:21:\"off-canvas-background\";a:9:{s:16:\"background-color\";s:7:\"#ffffff\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:4:\"none\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:22:\"off-canvas-close-color\";s:7:\"#3a3a3a\";s:18:\"mobile-header-type\";s:8:\"dropdown\";s:24:\"off-canvas-inner-spacing\";s:0:\"\";s:18:\"footer-menu-layout\";a:3:{s:7:\"desktop\";s:10:\"horizontal\";s:6:\"tablet\";s:10:\"horizontal\";s:6:\"mobile\";s:8:\"vertical\";}s:29:\"footer-menu-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:28:\"footer-menu-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-2)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"footer-menu-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:30:\"footer-menu-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"footer-menu-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:30:\"footer-menu-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-menu-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-menu-font-weight\";s:7:\"inherit\";s:23:\"footer-menu-font-family\";s:7:\"inherit\";s:26:\"footer-menu-text-transform\";s:0:\"\";s:23:\"footer-menu-line-height\";s:0:\"\";s:24:\"footer-main-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:2:\"15\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:2:\"20\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:2:\"20\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:2:\"10\";s:4:\"left\";s:1:\"0\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-trigger-icon\";s:5:\"menu2\";s:30:\"mobile-header-toggle-icon-size\";i:22;s:36:\"mobile-header-toggle-btn-border-size\";a:4:{s:3:\"top\";i:1;s:5:\"right\";i:1;s:6:\"bottom\";i:1;s:4:\"left\";i:1;}s:34:\"mobile-header-toggle-border-radius\";i:100;s:31:\"mobile-header-label-font-family\";s:7:\"inherit\";s:31:\"mobile-header-label-font-weight\";s:7:\"inherit\";s:34:\"mobile-header-label-text-transform\";s:0:\"\";s:31:\"mobile-header-label-line-height\";s:0:\"\";s:29:\"mobile-header-label-font-size\";s:0:\"\";s:20:\"global-color-palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#FF7A3D\";i:1;s:7:\"#FF5100\";i:2;s:7:\"#1E1810\";i:3;s:7:\"#575250\";i:4;s:7:\"#F8F5F4\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#000000\";i:7;s:7:\"#4B4F58\";i:8;s:7:\"#F6F7F8\";}s:4:\"flag\";b:1;}s:27:\"header-mobile-menu-bg-color\";s:0:\"\";s:24:\"header-mobile-menu-color\";s:0:\"\";s:29:\"header-mobile-menu-h-bg-color\";s:0:\"\";s:26:\"header-mobile-menu-h-color\";s:0:\"\";s:29:\"header-mobile-menu-a-bg-color\";s:0:\"\";s:26:\"header-mobile-menu-a-color\";s:0:\"\";s:36:\"header-mobile-menu-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:13:\"rgba(0,0,0,0)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:9:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:35:\"header-mobile-menu-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:7:\"#000000\";s:6:\"mobile\";s:0:\"\";}s:40:\"header-mobile-menu-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:13:\"rgba(0,0,0,0)\";s:6:\"mobile\";s:0:\"\";}s:37:\"header-mobile-menu-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:7:\"#000000\";s:6:\"mobile\";s:0:\"\";}s:40:\"header-mobile-menu-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:13:\"rgba(0,0,0,0)\";s:6:\"mobile\";s:0:\"\";}s:37:\"header-mobile-menu-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:25:\"var(--ast-global-color-0)\";s:6:\"mobile\";s:0:\"\";}s:46:\"header-mobile-menu-submenu-container-animation\";s:4:\"fade\";s:38:\"header-mobile-menu-submenu-item-border\";b:1;s:38:\"header-mobile-menu-submenu-item-b-size\";i:1;s:39:\"header-mobile-menu-submenu-item-b-color\";s:7:\"#eaeaea\";s:33:\"header-mobile-menu-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:28:\"header-mobile-menu-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"header-mobile-menu-font-weight\";s:7:\"inherit\";s:30:\"header-mobile-menu-font-family\";s:7:\"inherit\";s:33:\"header-mobile-menu-text-transform\";s:0:\"\";s:30:\"header-mobile-menu-line-height\";s:0:\"\";s:26:\"woo-header-cart-icon-style\";s:7:\"outline\";s:26:\"header-woo-cart-icon-color\";s:0:\"\";s:38:\"transparent-header-woo-cart-icon-color\";s:0:\"\";s:27:\"woo-header-cart-icon-radius\";i:3;s:29:\"woo-header-cart-total-display\";b:1;s:29:\"woo-header-cart-title-display\";b:1;s:26:\"header-woo-cart-text-color\";s:0:\"\";s:26:\"header-woo-cart-link-color\";s:0:\"\";s:32:\"header-woo-cart-background-color\";s:0:\"\";s:31:\"header-woo-cart-separator-color\";s:0:\"\";s:32:\"header-woo-cart-link-hover-color\";s:0:\"\";s:30:\"header-woo-cart-btn-text-color\";s:0:\"\";s:36:\"header-woo-cart-btn-background-color\";s:0:\"\";s:36:\"header-woo-cart-btn-text-hover-color\";s:0:\"\";s:34:\"header-woo-cart-btn-bg-hover-color\";s:0:\"\";s:34:\"header-woo-checkout-btn-text-color\";s:0:\"\";s:40:\"header-woo-checkout-btn-background-color\";s:0:\"\";s:40:\"header-woo-checkout-btn-text-hover-color\";s:0:\"\";s:38:\"header-woo-checkout-btn-bg-hover-color\";s:0:\"\";s:26:\"edd-header-cart-icon-style\";s:7:\"outline\";s:26:\"edd-header-cart-icon-color\";s:0:\"\";s:27:\"edd-header-cart-icon-radius\";i:3;s:38:\"transparent-header-edd-cart-icon-color\";s:0:\"\";s:29:\"edd-header-cart-total-display\";b:1;s:29:\"edd-header-cart-title-display\";b:1;s:26:\"header-edd-cart-text-color\";s:0:\"\";s:26:\"header-edd-cart-link-color\";s:0:\"\";s:32:\"header-edd-cart-background-color\";s:0:\"\";s:31:\"header-edd-cart-separator-color\";s:0:\"\";s:34:\"header-edd-checkout-btn-text-color\";s:0:\"\";s:40:\"header-edd-checkout-btn-background-color\";s:0:\"\";s:40:\"header-edd-checkout-btn-text-hover-color\";s:0:\"\";s:38:\"header-edd-checkout-btn-bg-hover-color\";s:0:\"\";s:19:\"header-account-type\";s:7:\"default\";s:26:\"header-account-login-style\";s:4:\"icon\";s:26:\"header-account-action-type\";s:4:\"link\";s:24:\"header-account-link-type\";s:7:\"default\";s:27:\"header-account-logout-style\";s:4:\"icon\";s:30:\"header-account-logged-out-text\";s:6:\"Log In\";s:29:\"header-account-logged-in-text\";s:10:\"My Account\";s:28:\"header-account-logout-action\";s:4:\"link\";s:26:\"header-account-image-width\";a:3:{s:7:\"desktop\";s:2:\"40\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-account-icon-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";i:18;s:6:\"mobile\";i:18;}s:25:\"header-account-icon-color\";s:0:\"\";s:25:\"header-account-login-link\";a:3:{s:3:\"url\";s:0:\"\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-account-logout-link\";a:3:{s:3:\"url\";s:38:\"https://wp3.woolearnr.com/wp-login.php\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:32:\"font-size-section-header-account\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"header-account-type-text-color\";s:0:\"\";s:23:\"header-account-woo-menu\";b:0;s:22:\"cloned-component-track\";a:12:{s:13:\"header-button\";i:2;s:13:\"footer-button\";i:2;s:11:\"header-html\";i:2;s:11:\"footer-html\";i:2;s:11:\"header-menu\";i:2;s:13:\"header-widget\";i:4;s:13:\"footer-widget\";i:4;s:19:\"header-social-icons\";i:1;s:19:\"footer-social-icons\";i:1;s:14:\"header-divider\";i:0;s:14:\"footer-divider\";i:0;s:13:\"removed-items\";a:0:{}}s:18:\"theme-auto-version\";s:7:\"4.11.18\";s:33:\"_astra_pb_compatibility_completed\";b:1;s:21:\"headings-font-variant\";s:7:\"400,700\";s:36:\"transparent-header-search-icon-color\";s:7:\"#ffffff\";s:29:\"header-button1-border-h-color\";a:1:{s:7:\"desktop\";s:25:\"var(--ast-global-color-5)\";}s:35:\"transparent-header-toggle-btn-color\";s:7:\"#ffffff\";s:38:\"transparent-header-toggle-btn-bg-color\";s:25:\"var(--ast-global-color-0)\";s:38:\"transparent-header-toggle-border-color\";s:13:\"rgba(0,0,0,0)\";s:38:\"section-header-mobile-menu-hide-tablet\";b:0;s:32:\"section-footer-menu-hide-desktop\";b:0;s:21:\"heading-typo-selector\";s:2:\"h4\";s:25:\"header-mobile-popup-items\";b:0;s:30:\"mobile-header-toggle-btn-color\";s:25:\"var(--ast-global-color-5)\";s:33:\"mobile-header-toggle-btn-bg-color\";s:25:\"var(--ast-global-color-0)\";s:29:\"breadcrumb-separator-selector\";s:7:\"unicode\";s:42:\"apply-content-background-fullwidth-layouts\";b:0;s:19:\"blocks-legacy-setup\";b:1;s:12:\"wp-blocks-ui\";s:6:\"legacy\";s:32:\"customizer-default-layout-update\";b:0;s:15:\"wp-blocks-v2-ui\";b:0;s:33:\"single-product-breadcrumb-disable\";b:1;s:29:\"woo-header-cart-label-display\";s:33:\"Cart/{cart_total_currency_symbol}\";s:12:\"border-color\";s:7:\"#dddddd\";s:22:\"modern-ecommerce-setup\";b:0;s:22:\"woo-show-password-icon\";b:0;s:19:\"woo-shop-style-flag\";b:1;s:32:\"astra-old-global-sidebar-default\";b:0;s:28:\"spectra-gutenberg-compat-css\";b:0;s:20:\"dynamic-blog-layouts\";b:0;s:32:\"theme-dynamic-customizer-support\";b:1;s:33:\"ast-dynamic-single-page-structure\";a:1:{i:0;s:29:\"ast-dynamic-single-page-title\";}s:32:\"ast-dynamic-single-page-metadata\";a:2:{i:0;s:8:\"comments\";i:1;s:6:\"author\";}s:22:\"ast-archive-page-title\";b:1;s:21:\"ast-single-page-title\";b:1;s:42:\"ast-dynamic-archive-page-banner-image-type\";s:4:\"none\";s:41:\"ast-dynamic-archive-page-banner-custom-bg\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:42:\"ast-dynamic-archive-page-title-font-family\";s:0:\"\";s:40:\"ast-dynamic-archive-page-title-font-size\";a:6:{s:7:\"desktop\";i:40;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:42:\"ast-dynamic-archive-page-title-font-weight\";s:0:\"\";s:42:\"ast-dynamic-archive-page-title-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:10:\"capitalize\";s:15:\"text-decoration\";s:0:\"\";}s:43:\"ast-dynamic-archive-page-banner-title-color\";s:0:\"\";s:42:\"ast-dynamic-archive-page-banner-text-color\";s:0:\"\";s:42:\"ast-dynamic-single-page-banner-title-color\";s:0:\"\";s:41:\"ast-dynamic-single-page-title-font-family\";s:0:\"\";s:39:\"ast-dynamic-single-page-title-font-size\";a:6:{s:7:\"desktop\";i:30;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:41:\"ast-dynamic-single-page-title-font-weight\";s:0:\"\";s:41:\"ast-dynamic-single-page-title-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"ast-dynamic-single-post-structure\";a:3:{i:0;s:29:\"ast-dynamic-single-post-image\";i:1;s:29:\"ast-dynamic-single-post-title\";i:2;s:28:\"ast-dynamic-single-post-meta\";}s:32:\"ast-dynamic-single-post-taxonomy\";s:8:\"category\";s:32:\"ast-dynamic-single-post-metadata\";a:3:{i:0;s:8:\"comments\";i:1;s:32:\"ast-dynamic-single-post-taxonomy\";i:2;s:6:\"author\";}s:22:\"ast-archive-post-title\";b:1;s:21:\"ast-single-post-title\";b:1;s:42:\"ast-dynamic-archive-post-banner-image-type\";s:4:\"none\";s:41:\"ast-dynamic-archive-post-banner-custom-bg\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:42:\"ast-dynamic-archive-post-title-font-family\";s:0:\"\";s:40:\"ast-dynamic-archive-post-title-font-size\";a:6:{s:7:\"desktop\";i:40;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:42:\"ast-dynamic-archive-post-title-font-weight\";s:0:\"\";s:42:\"ast-dynamic-archive-post-title-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:10:\"capitalize\";s:15:\"text-decoration\";s:0:\"\";}s:43:\"ast-dynamic-archive-post-banner-title-color\";s:0:\"\";s:42:\"ast-dynamic-archive-post-banner-text-color\";s:0:\"\";s:42:\"ast-dynamic-single-post-banner-title-color\";s:0:\"\";s:41:\"ast-dynamic-single-post-title-font-family\";s:0:\"\";s:39:\"ast-dynamic-single-post-title-font-size\";a:6:{s:7:\"desktop\";i:30;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:41:\"ast-dynamic-single-post-title-font-weight\";s:0:\"\";s:41:\"ast-dynamic-single-post-title-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:31:\"archive-download-content-layout\";s:7:\"default\";s:31:\"archive-download-sidebar-layout\";s:10:\"no-sidebar\";s:30:\"single-download-content-layout\";s:7:\"default\";s:30:\"single-download-sidebar-layout\";s:7:\"default\";s:19:\"enable-scroll-to-id\";b:0;s:20:\"scroll-to-top-enable\";b:0;s:25:\"update-default-color-typo\";b:0;s:22:\"v4-block-editor-compat\";b:0;s:23:\"v4-1-0-update-migration\";b:1;s:27:\"single-product-payment-list\";a:1:{s:5:\"items\";a:4:{i:0;a:6:{s:2:\"id\";s:8:\"item-100\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:4:\"icon\";s:7:\"cc-visa\";s:5:\"image\";s:0:\"\";s:5:\"label\";s:4:\"Visa\";}i:1;a:6:{s:2:\"id\";s:8:\"item-101\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:4:\"icon\";s:13:\"cc-mastercard\";s:5:\"image\";s:0:\"\";s:5:\"label\";s:10:\"Mastercard\";}i:2;a:6:{s:2:\"id\";s:8:\"item-102\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:4:\"icon\";s:7:\"cc-amex\";s:5:\"image\";s:0:\"\";s:5:\"label\";s:4:\"Amex\";}i:3;a:6:{s:2:\"id\";s:8:\"item-103\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:4:\"icon\";s:11:\"cc-discover\";s:5:\"image\";s:0:\"\";s:5:\"label\";s:8:\"Discover\";}}}s:27:\"woo_support_global_settings\";b:1;s:49:\"ast-dynamic-single-elementor-hf-title-font-extras\";a:1:{s:14:\"text-transform\";s:0:\"\";}s:23:\"v4-1-4-update-migration\";b:1;s:24:\"astra-addon-auto-version\";s:7:\"4.11.13\";s:28:\"is_astra_addon_queue_running\";b:0;s:27:\"list-block-vertical-spacing\";b:0;s:37:\"apply-modern-layout-sale-badge-styles\";b:0;s:23:\"ast-site-content-layout\";s:22:\"normal-width-container\";s:18:\"site-content-style\";s:5:\"boxed\";s:18:\"site-sidebar-style\";s:5:\"boxed\";s:30:\"single-post-ast-content-layout\";s:7:\"default\";s:25:\"single-post-content-style\";s:7:\"default\";s:25:\"single-post-sidebar-style\";s:7:\"default\";s:30:\"single-page-ast-content-layout\";s:7:\"default\";s:25:\"single-page-content-style\";s:7:\"default\";s:25:\"single-page-sidebar-style\";s:7:\"default\";s:31:\"archive-post-ast-content-layout\";s:7:\"default\";s:26:\"archive-post-content-style\";s:7:\"default\";s:26:\"archive-post-sidebar-style\";s:7:\"default\";s:25:\"fullwidth_sidebar_support\";b:0;s:23:\"v4-2-0-update-migration\";b:1;s:29:\"v4-2-2-core-form-btns-styling\";b:0;s:22:\"v4-4-0-backward-option\";b:0;s:28:\"secondary-font-family-button\";s:7:\"inherit\";s:26:\"secondary-font-size-button\";a:6:{s:7:\"desktop\";s:2:\"14\";s:6:\"tablet\";s:2:\"16\";s:6:\"mobile\";s:2:\"14\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"secondary-font-weight-button\";s:3:\"400\";s:25:\"secondary-button-bg-color\";s:25:\"var(--ast-global-color-0)\";s:27:\"secondary-button-bg-h-color\";s:25:\"var(--ast-global-color-1)\";s:64:\"ast-dynamic-single-post-article-featured-image-position-layout-1\";s:4:\"none\";s:64:\"ast-dynamic-single-post-article-featured-image-position-layout-2\";s:4:\"none\";s:57:\"ast-dynamic-single-post-article-featured-image-ratio-type\";s:7:\"default\";s:64:\"ast-dynamic-single-page-article-featured-image-position-layout-1\";s:4:\"none\";s:64:\"ast-dynamic-single-page-article-featured-image-position-layout-2\";s:4:\"none\";s:57:\"ast-dynamic-single-page-article-featured-image-ratio-type\";s:7:\"default\";s:22:\"v4-5-0-backward-option\";b:0;s:26:\"scndry-btn-default-padding\";b:0;s:22:\"v4-6-0-backward-option\";b:0;s:39:\"ast-sub-section-author-box-border-width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:40:\"ast-sub-section-author-box-border-radius\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:39:\"ast-sub-section-author-box-border-color\";s:0:\"\";s:28:\"single-content-images-shadow\";b:0;s:21:\"ast-font-style-update\";b:0;s:22:\"is_theme_queue_running\";b:0;s:22:\"v4-6-2-backward-option\";b:0;s:33:\"update-default-spacing-for-header\";b:0;s:39:\"restrict-banner-layout-with-page-header\";b:0;s:20:\"btn-stylings-upgrade\";b:0;s:24:\"elementor-headings-style\";b:0;s:33:\"elementor-container-padding-style\";b:0;s:14:\"font-extras-h1\";a:2:{s:11:\"line-height\";s:3:\"1.4\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-extras-h2\";a:2:{s:11:\"line-height\";s:3:\"1.3\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-extras-h3\";a:2:{s:11:\"line-height\";s:3:\"1.3\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-extras-h4\";a:2:{s:11:\"line-height\";s:3:\"1.2\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-extras-h5\";a:2:{s:11:\"line-height\";s:3:\"1.2\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-extras-h6\";a:2:{s:11:\"line-height\";s:4:\"1.25\";s:16:\"line-height-unit\";s:2:\"em\";}s:34:\"global-headings-line-height-update\";b:1;s:37:\"single_posts_pages_heading_clear_none\";b:0;s:21:\"elementor-btn-styling\";b:1;s:52:\"remove_single_posts_navigation_mobile_device_padding\";b:1;s:37:\"site-builder-templates-headings-space\";b:0;s:27:\"enable-4-6-14-compatibility\";b:0;s:33:\"hiding_social_share_icon_position\";b:0;s:24:\"heading-widget-font-size\";b:0;s:42:\"hba-transparent-header-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:42:\"hbb-transparent-header-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"enable-4-8-0-compatibility\";b:0;s:22:\"v4-8-2-backward-option\";b:0;s:26:\"enable-4-8-4-compatibility\";b:0;s:37:\"astra-heading-font-size-compatibility\";b:0;s:26:\"enable-4-8-9-compatibility\";b:0;s:20:\"off-canvas-move-body\";b:1;s:16:\"star-rating-comp\";b:0;s:22:\"v4-9-0-backward-option\";b:0;s:11:\"v4-9-2-comp\";b:0;s:18:\"load_more_btn_comp\";b:0;s:16:\"btn-consist-comp\";b:0;s:28:\"enable-4-11-12-compatibility\";b:0;}","yes");

INSERT IGNORE INTO `znE_options` VALUES 
("3023","astra-theme-old-setup","1","yes"),
("3048","astra-sites-tags","a:10:{i:0;a:3:{s:2:\"id\";i:1619;s:4:\"name\";s:3:\"Abo\";s:4:\"slug\";s:3:\"abo\";}i:1;a:3:{s:2:\"id\";i:1604;s:4:\"name\";s:8:\"Abour Us\";s:4:\"slug\";s:8:\"abour-us\";}i:2;a:3:{s:2:\"id\";i:352;s:4:\"name\";s:5:\"About\";s:4:\"slug\";s:5:\"about\";}i:3;a:3:{s:2:\"id\";i:1007;s:4:\"name\";s:8:\"about me\";s:4:\"slug\";s:8:\"about-me\";}i:4;a:3:{s:2:\"id\";i:455;s:4:\"name\";s:8:\"about us\";s:4:\"slug\";s:8:\"about-us\";}i:5;a:3:{s:2:\"id\";i:599;s:4:\"name\";s:9:\"ac repair\";s:4:\"slug\";s:9:\"ac-repair\";}i:6;a:3:{s:2:\"id\";i:639;s:4:\"name\";s:11:\"accessories\";s:4:\"slug\";s:11:\"accessories\";}i:7;a:3:{s:2:\"id\";i:999;s:4:\"name\";s:7:\"account\";s:4:\"slug\";s:7:\"account\";}i:8;a:3:{s:2:\"id\";i:447;s:4:\"name\";s:10:\"Accountant\";s:4:\"slug\";s:10:\"accountant\";}i:9;a:3:{s:2:\"id\";i:448;s:4:\"name\";s:10:\"Accounting\";s:4:\"slug\";s:10:\"accounting\";}}","no"),
("3053","astra-sites-categories","a:5:{i:0;a:3:{s:2:\"id\";i:27;s:4:\"name\";s:8:\"Business\";s:4:\"slug\";s:8:\"business\";}i:1;a:3:{s:2:\"id\";i:36;s:4:\"name\";s:5:\"Other\";s:4:\"slug\";s:5:\"other\";}i:2;a:3:{s:2:\"id\";i:37;s:4:\"name\";s:4:\"Blog\";s:4:\"slug\";s:4:\"blog\";}i:3;a:3:{s:2:\"id\";i:38;s:4:\"name\";s:9:\"eCommerce\";s:4:\"slug\";s:9:\"ecommerce\";}i:4;a:3:{s:2:\"id\";i:39;s:4:\"name\";s:4:\"Free\";s:4:\"slug\";s:4:\"free\";}}","no"),
("3060","astra-sites-last-export-checksums-latest","N1^B^V)T(v3x","off"),
("3064","astra-blocks-batch-status-string","Complete storing data for page 4","no"),
("3065","astra-blocks-requests","4","no"),
("3068","bsf_analytics_installed_time","1597411990","no"),
("3072","astra-sites-batch-is-complete","yes","no"),
("3274","_astra_sites_gettings_started","yes","no"),
("3338","elementor_active_kit","1316","yes"),
("3342","elementor_install_history","a:75:{s:5:\"3.0.0\";i:1598371521;s:5:\"3.0.2\";i:1598499111;s:5:\"3.0.3\";i:1598630183;s:5:\"3.0.4\";i:1598835405;s:5:\"3.0.5\";i:1598914507;s:5:\"3.0.6\";i:1599459956;s:5:\"3.0.7\";i:1599690411;s:7:\"3.0.8.1\";i:1600116462;s:5:\"3.0.9\";i:1600367526;s:6:\"3.0.10\";i:1600907063;s:6:\"3.0.11\";i:1601593280;s:6:\"3.0.12\";i:1603250713;s:6:\"3.0.13\";i:1604700043;s:6:\"3.0.14\";i:1606820724;s:6:\"3.0.15\";i:1608579256;s:6:\"3.0.16\";i:1609951632;s:5:\"3.1.0\";i:1611695969;s:5:\"3.1.1\";i:1612167911;s:5:\"3.1.2\";i:1614723086;s:5:\"3.1.3\";i:1614816600;s:5:\"3.1.4\";i:1615436914;s:5:\"3.2.1\";i:1619109587;s:5:\"3.2.2\";i:1619467255;s:5:\"3.2.3\";i:1620237788;s:5:\"3.2.4\";i:1622133392;s:5:\"3.2.5\";i:1623872296;s:5:\"3.3.0\";i:1626194550;s:5:\"3.3.1\";i:1626801345;s:5:\"3.4.0\";i:1629145511;s:5:\"3.4.4\";i:1631788476;s:5:\"3.4.5\";i:1634070987;s:5:\"3.4.6\";i:1634666915;s:5:\"3.4.7\";i:1635702431;s:5:\"3.4.8\";i:1637085489;s:5:\"3.5.0\";i:1639509796;s:5:\"3.5.3\";i:1641454820;s:5:\"3.5.5\";i:1645519684;s:5:\"3.5.6\";i:1646069166;s:5:\"3.6.1\";i:1648564922;s:5:\"3.6.2\";i:1649133054;s:5:\"3.6.4\";i:1649883260;s:5:\"3.7.8\";i:1664879531;s:5:\"3.9.0\";i:1671017266;s:6:\"3.12.1\";i:1680867688;s:6:\"3.12.2\";i:1683523041;s:6:\"3.13.2\";i:1684394210;s:6:\"3.13.4\";i:1685531450;s:6:\"3.14.0\";i:1687235464;s:6:\"3.15.0\";i:1690892659;s:6:\"3.15.1\";i:1691037035;s:6:\"3.15.2\";i:1691670492;s:6:\"3.16.3\";i:1694753063;s:6:\"3.16.6\";i:1697611791;s:6:\"3.17.1\";i:1698744029;s:6:\"3.17.2\";i:1698899481;s:6:\"3.18.3\";i:1703826932;s:6:\"3.19.0\";i:1706589047;s:6:\"3.21.4\";i:1715059557;s:6:\"3.21.5\";i:1715190515;s:6:\"3.21.6\";i:1716226642;s:6:\"3.23.3\";i:1722828337;s:6:\"3.24.4\";i:1727176823;s:6:\"3.24.5\";i:1727787313;s:6:\"3.24.7\";i:1729496501;s:6:\"3.25.3\";i:1730295489;s:6:\"3.25.4\";i:1730986771;s:6:\"3.25.5\";i:1731430485;s:6:\"3.27.3\";i:1738753093;s:6:\"3.28.4\";i:1745907325;s:6:\"3.29.2\";i:1750678715;s:6:\"3.30.0\";i:1751374599;s:6:\"3.30.3\";i:1753781440;s:6:\"3.33.2\";i:1764569919;s:6:\"3.33.3\";i:1764929596;s:6:\"3.33.4\";i:1765275125;}","yes"),
("3669","updraft_task_manager_dbversion","1.1","yes"),
("3674","updraft_unlocked_wpo_cache_preloader_creating_tasks","1","no"),
("3675","updraft_last_lock_time_wpo_cache_preloader_creating_tasks","2020-10-22 01:50:57","no"),
("3676","updraft_semaphore_wpo_cache_preloader_creating_tasks","0","no"),
("3838","elementor_load_fa4_shim","yes","yes"),
("3946","wpo_update_version","4.4.0","yes"),
("3948","wp-optimize-is_gzip_compression_enabled","gzip","yes"),
("3951","wp-optimize-install-or-update-notice-version","1.1","yes"),
("3955","wpo_cache_config","a:30:{s:19:\"enable_page_caching\";b:0;s:23:\"page_cache_length_value\";i:24;s:22:\"page_cache_length_unit\";s:5:\"hours\";s:17:\"page_cache_length\";i:86400;s:32:\"cache_exception_conditional_tags\";a:1:{i:0;s:0:\"\";}s:20:\"cache_exception_urls\";a:1:{i:0;s:0:\"\";}s:28:\"cache_ignore_query_variables\";a:0:{}s:23:\"cache_exception_cookies\";a:1:{i:0;s:0:\"\";}s:30:\"cache_exception_browser_agents\";a:1:{i:0;s:0:\"\";}s:22:\"enable_sitemap_preload\";b:0;s:23:\"enable_schedule_preload\";s:1:\"1\";s:21:\"preload_schedule_type\";s:22:\"wpo_use_cache_lifespan\";s:21:\"enable_mobile_caching\";s:1:\"1\";s:19:\"enable_user_caching\";s:1:\"0\";s:8:\"site_url\";s:26:\"https://template.strng.us/\";s:24:\"enable_cache_per_country\";b:0;s:27:\"enable_cache_aelia_currency\";b:0;s:19:\"permalink_structure\";s:12:\"/%postname%/\";s:7:\"uploads\";s:42:\"/home/satbiz5/_template/wp-content/uploads\";s:10:\"gmt_offset\";s:1:\"0\";s:15:\"timezone_string\";s:0:\"\";s:11:\"date_format\";s:6:\"F j, Y\";s:11:\"time_format\";s:5:\"g:i a\";s:15:\"use_webp_images\";b:0;s:12:\"show_avatars\";i:0;s:22:\"host_gravatars_locally\";i:0;s:28:\"auto_preload_purged_contents\";b:1;s:19:\"enable_rest_caching\";b:0;s:17:\"wpo_cache_cookies\";a:0:{}s:25:\"wpo_cache_query_variables\";a:0:{}}","yes"),
("3959","wp-optimize-completed_task_count","818","yes"),
("3960","wp-optimize-total_bytes_saved","1119918","yes"),
("3961","wp-optimize-total_percent_saved","0.4807090464547","yes"),
("3980","_hfe_db_version","2.7.0","yes"),
("3981","action_scheduler_hybrid_store_demarkation","46","yes"),
("3982","schema-ActionScheduler_StoreSchema","8.0.1754462252","yes"),
("3983","schema-ActionScheduler_LoggerSchema","3.0.1647552892","yes"),
("3984","action_scheduler_lock_async-request-runner","69450b10eb3350.13886132|1766132556","yes"),
("3985","wpforms_version_lite","1.6.2.2","yes"),
("3986","widget_wpforms-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("4046","elementor_container_width","","yes"),
("4047","elementor_cpt_support","a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}","yes"),
("4048","elementor_css_print_method","internal","yes"),
("4049","elementor_default_generic_fonts","Sans-serif","yes"),
("4050","elementor_disable_color_schemes","yes","yes"),
("4051","elementor_disable_typography_schemes","yes","yes"),
("4052","elementor_editor_break_lines","","yes"),
("4053","elementor_global_image_lightbox","yes","yes"),
("4054","elementor_page_title_selector","","yes"),
("4055","elementor_space_between_widgets","","yes"),
("4056","elementor_stretched_section_container","","yes"),
("4057","woocommerce_enable_signup_and_login_from_checkout","no","yes"),
("4058","woocommerce_enable_myaccount_registration","no","yes"),
("4059","woocommerce_registration_generate_username","no","yes"),
("4060","wpforms_settings","a:6:{s:11:\"disable-css\";s:1:\"2\";s:13:\"global-assets\";b:0;s:4:\"gdpr\";b:0;s:13:\"modern-markup\";s:1:\"1\";s:20:\"modern-markup-is-set\";b:1;s:26:\"modern-markup-hide-setting\";b:1;}","yes"),
("4087","wpforms_crypto_secret_key","uAAbhTH16LlxguY9rHRqSpF02GuWY5lutrVFXuvMXDk=","yes"),
("4098","elementor_allow_tracking","no","yes"),
("4099","elementor_tracker_notice","1","yes"),
("4103","wp-optimize-newly-activated","1","yes"),
("4104","wp-optimize-schedule","false","yes"),
("4105","wp-optimize-last-optimized","Never","yes"),
("4106","wp-optimize-schedule-type","wpo_weekly","yes"),
("4107","wp-optimize-retention-enabled","false","yes"),
("4108","wp-optimize-retention-period","2","yes"),
("4109","wp-optimize-enable-admin-menu","true","yes"),
("4110","wp-optimize-total-cleaned","0","yes"),
("4111","wp-optimize-auto","a:7:{s:9:\"revisions\";s:4:\"true\";s:5:\"spams\";s:4:\"true\";s:5:\"trash\";s:4:\"true\";s:10:\"unapproved\";s:5:\"false\";s:8:\"optimize\";s:5:\"false\";s:9:\"transient\";s:5:\"false\";s:6:\"drafts\";s:4:\"true\";}","yes"),
("4112","wp-optimize-settings","a:13:{s:10:\"user-spams\";s:5:\"false\";s:10:\"user-trash\";s:5:\"false\";s:13:\"user-optimize\";s:4:\"true\";s:14:\"user-revisions\";s:4:\"true\";s:14:\"user-transient\";s:4:\"true\";s:16:\"user-commentmeta\";s:5:\"false\";s:13:\"user-postmeta\";s:5:\"false\";s:15:\"user-unapproved\";s:5:\"false\";s:15:\"user-trackbacks\";s:5:\"false\";s:11:\"user-drafts\";s:4:\"true\";s:15:\"user-orphandata\";s:5:\"false\";s:14:\"user-pingbacks\";s:5:\"false\";s:13:\"last_saved_in\";s:6:\"3.1.12\";}","yes"),
("4113","wpo_minify_config","a:63:{s:5:\"debug\";b:0;s:19:\"enabled_css_preload\";b:0;s:18:\"enabled_js_preload\";b:0;s:11:\"hpreconnect\";s:0:\"\";s:8:\"hpreload\";s:0:\"\";s:7:\"loadcss\";b:0;s:10:\"remove_css\";b:0;s:17:\"critical_path_css\";s:0:\"\";s:31:\"critical_path_css_is_front_page\";s:0:\"\";s:30:\"preserve_settings_on_uninstall\";b:1;s:22:\"disable_when_logged_in\";b:0;s:16:\"default_protocol\";s:5:\"https\";s:17:\"html_minification\";b:1;s:16:\"clean_header_one\";b:0;s:13:\"emoji_removal\";b:1;s:18:\"merge_google_fonts\";b:1;s:19:\"enable_display_swap\";b:1;s:18:\"remove_googlefonts\";b:0;s:31:\"disable_google_fonts_processing\";b:0;s:13:\"gfonts_method\";s:7:\"exclude\";s:15:\"fawesome_method\";s:7:\"exclude\";s:10:\"enable_css\";b:1;s:23:\"enable_css_minification\";b:1;s:21:\"enable_merging_of_css\";b:1;s:23:\"remove_print_mediatypes\";b:1;s:10:\"inline_css\";b:1;s:9:\"enable_js\";b:1;s:22:\"enable_js_minification\";b:1;s:20:\"enable_merging_of_js\";b:1;s:15:\"enable_defer_js\";s:10:\"individual\";s:13:\"defer_js_type\";s:5:\"defer\";s:12:\"defer_jquery\";b:1;s:18:\"enable_js_trycatch\";b:0;s:19:\"exclude_defer_login\";b:0;s:7:\"cdn_url\";s:0:\"\";s:9:\"cdn_force\";b:0;s:15:\"enable_delay_js\";b:0;s:17:\"enable_preload_js\";b:0;s:16:\"exclude_delay_js\";s:0:\"\";s:9:\"async_css\";s:81:\"/wp-content/cache/wpo-minify/1599326990/assets/wpo-minify-header-a87c6fca.min.css\";s:8:\"async_js\";s:228:\"/wp-content/cache/wpo-minify/1599326990/assets/wpo-minify-footer-de7d338e.min.js\r\n/wp-content/cache/wpo-minify/1599329007/assets/wpo-minify-footer-swiper.min.js\r\n/wpo-minify/1599329007/assets/wpo-minify-footer-jquery-core.min.js\";s:24:\"disable_css_inline_merge\";b:1;s:6:\"ualist\";a:5:{i:0;s:9:\"Googlebot\";i:1;s:17:\"Chrome-Lighthouse\";i:2;s:8:\"GTmetrix\";i:3;s:14:\"HeadlessChrome\";i:4;s:7:\"Pingdom\";}s:32:\"exclude_js_from_page_speed_tools\";b:0;s:33:\"exclude_css_from_page_speed_tools\";b:0;s:9:\"blacklist\";a:0:{}s:11:\"ignore_list\";a:0:{}s:10:\"exclude_js\";s:0:\"\";s:11:\"exclude_css\";s:0:\"\";s:23:\"edit_default_exclutions\";b:0;s:18:\"merge_allowed_urls\";s:0:\"\";s:7:\"enabled\";b:1;s:17:\"last-cache-update\";i:1766131992;s:14:\"plugin_version\";s:5:\"0.0.0\";s:14:\"cache_lifespan\";s:1:\"0\";s:25:\"merge_inline_extra_css_js\";b:1;s:16:\"enable_analytics\";b:0;s:16:\"analytics_method\";s:6:\"gtagv4\";s:11:\"tracking_id\";s:0:\"\";s:17:\"enable_unused_css\";b:0;s:19:\"defer_for_pagespeed\";b:0;s:19:\"include_ui_elements\";b:1;s:19:\"minify_advanced_tab\";s:1:\"1\";}","yes"),
("4117","wp-optimize-corrupted-tables-count","0","yes"),
("4118","wp-optimize-enable-auto-backup","false","yes"),
("4125","wp-optimize-compression_server","resmushit","yes"),
("4126","wp-optimize-lossy_compression","1","yes"),
("4127","wp-optimize-back_up_original","1","yes"),
("4128","wp-optimize-back_up_delete_after","1","yes"),
("4129","wp-optimize-back_up_delete_after_days","50","yes"),
("4130","wp-optimize-autosmush","1","yes"),
("4131","wp-optimize-image_quality","95","yes"),
("4132","wp-optimize-show_smush_metabox","show","yes"),
("4139","wp-optimize-wpo_last_page_cache_preload_type","sitemap","yes"),
("4148","wp-optimize-wpo_last_page_cache_preload","1654297199","yes"),
("4207","Re_Smush_It_Task","1599327499","yes"),
("4221","Nitro_Smush_Task","1599327548","yes"),
("4542","wp-optimize-logging","","yes"),
("4543","wp-optimize-logging-additional","","yes"),
("4544","wp-optimize-enable-db-force-optimize","false","yes"),
("4546","wp-optimize-dismiss_page_notice_until","1655194749","yes"),
("4563","wp-optimize-dismiss_notice","1705913571","yes"),
("4630","wpassetcleanup_first_usage","1599331923","no"),
("4632","wpassetcleanup_global_data","{\"styles\":{\"assets_info\":{\"astra-theme-css\":{\"src\":\"\\/wp-content\\/themes\\/astra\\/assets\\/css\\/minified\\/style.min.css\",\"ver\":\"2.5.4\",\"args\":\"all\",\"extra\":{\"rtl\":\"replace\",\"after\":[\"html{font-size:100%;}a,.page-title{color:#1a6c7a;}a:hover,a:focus{color:#3a3a3a;}body,button,input,select,textarea,.ast-button,.ast-custom-button{font-family:\'Montserrat\',sans-serif;font-weight:400;font-size:16px;font-size:1rem;line-height:1.5;}blockquote{col