import type { SVGProps } from 'react';

interface CustomIconProps extends SVGProps<SVGSVGElement> {
    size?: number;
    fill?: string;
    stroke?: string;
    strokeWidth?: number;
    viewBox?: string;
}

const magicWand = ({
                                               size = 24,
                                               fill = 'none',
                                               stroke = 'none',
                                               strokeWidth = 2,
                                               viewBox = '0 0 24 24',
                                               ...props
                                           }:CustomIconProps) => (
    <svg
        width={size}
        height={size}
        fill={fill}
        stroke={stroke}
        strokeWidth={strokeWidth}
        viewBox={viewBox}
        strokeLinecap="round"
        strokeLinejoin="round"
        xmlns="http://www.w3.org/2000/svg"
        {...props}
    >
        <path fillRule="evenodd" clipRule="evenodd"
            d="M8.63498 7.07976C8.25225 6.89008 7.80285 6.89008 7.42007 7.07976C7.21559 7.18109 6.99692 7.40066 6.82417 7.57418C6.65066 7.7469 6.43109 7.9656 6.32976 8.17005C6.14008 8.55285 6.14008 9.00225 6.32976 9.38498C6.43109 9.5895 6.60609 9.76373 6.7796 9.93645L6.82417 9.98093L13.3136 16.4704C13.4863 16.6439 13.6605 16.8189 13.865 16.9202C14.2478 17.1099 14.6972 17.1099 15.08 16.9202C15.2844 16.8189 15.5031 16.5994 15.6758 16.4258C15.8493 16.2531 16.0689 16.0344 16.1702 15.83C16.3599 15.4472 16.3599 14.9978 16.1702 14.615C16.0689 14.4105 15.8939 14.2363 15.7204 14.0636L9.23093 7.57418L9.18645 7.52963C9.01373 7.35609 8.8395 7.18109 8.63498 7.07976ZM7.62068 8.36993C7.73498 8.25563 7.80435 8.18655 7.85948 8.13735C7.9146 8.07975 8.05943 7.99913 8.19765 8.13735C8.2527 8.18655 8.32208 8.25563 8.43645 8.36993L9.64988 9.58343L8.83418 10.3992L7.62068 9.1857C7.50638 9.0714 7.43729 9.00203 7.3881 8.9469C7.25118 8.80995 7.33105 8.66438 7.3881 8.60873C7.43729 8.55368 7.50638 8.48423 7.62068 8.36993Z"
            fill={fill}/>
        <path
            d="M12.75 0.9375C12.9853 0.9375 13.1959 1.08405 13.2775 1.30479L13.4986 1.90225C13.8064 2.73393 13.9111 2.98225 14.0894 3.16059C14.2678 3.33892 14.5161 3.44363 15.3478 3.75138L15.9452 3.97246C16.1659 4.05414 16.3125 4.26463 16.3125 4.5C16.3125 4.73537 16.1659 4.94586 15.9452 5.02754L15.3478 5.24862C14.5161 5.55638 14.2678 5.66108 14.0894 5.83941C13.9111 6.01775 13.8064 6.26607 13.4986 7.09776L13.2775 7.69522C13.1959 7.91595 12.9853 8.0625 12.75 8.0625C12.5147 8.0625 12.3041 7.91595 12.2225 7.69522L12.0014 7.09776C11.6936 6.26607 11.5889 6.01775 11.4106 5.83941C11.2322 5.66108 10.9839 5.55638 10.1522 5.24862L9.55478 5.02754C9.33405 4.94586 9.1875 4.73537 9.1875 4.5C9.1875 4.26463 9.33405 4.05414 9.55478 3.97246L10.1522 3.75138C10.9839 3.44363 11.2322 3.33892 11.4106 3.16059C11.5889 2.98225 11.6936 2.73393 12.0014 1.90225L12.2225 1.30479C12.3041 1.08405 12.5147 0.9375 12.75 0.9375Z"
            fill={fill}/>
        <path
            d="M4.5 2.4375C4.73537 2.4375 4.94586 2.58405 5.02754 2.80479L5.19335 3.25288C5.42863 3.88871 5.4971 4.03911 5.604 4.14601C5.71089 4.2529 5.86129 4.32137 6.49712 4.55665L6.94521 4.72246C7.16595 4.80414 7.3125 5.01463 7.3125 5.25C7.3125 5.48537 7.16595 5.69586 6.94521 5.77754L6.49712 5.94335C5.86129 6.17863 5.71089 6.2471 5.604 6.354C5.4971 6.46089 5.42863 6.61129 5.19335 7.24712L5.02754 7.69522C4.94586 7.91595 4.73537 8.0625 4.5 8.0625C4.26463 8.0625 4.05414 7.91595 3.97246 7.69522L3.80665 7.24712C3.57137 6.61129 3.5029 6.46089 3.39601 6.354C3.28911 6.2471 3.13871 6.17863 2.50288 5.94335L2.05479 5.77754C1.83405 5.69586 1.6875 5.48537 1.6875 5.25C1.6875 5.01463 1.83405 4.80414 2.05479 4.72246L2.50288 4.55665C3.13871 4.32137 3.28911 4.2529 3.39601 4.146C3.5029 4.03911 3.57137 3.88871 3.80665 3.25288L3.97246 2.80479C4.05414 2.58405 4.26463 2.4375 4.5 2.4375Z"
            fill={fill}/>
    </svg>
);

export default magicWand;